/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.session;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.SocketTimeoutException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jsmpp.DefaultPDUReader;
import org.jsmpp.DefaultPDUSender;
import org.jsmpp.InvalidCommandLengthException;
import org.jsmpp.InvalidResponseException;
import org.jsmpp.PDUException;
import org.jsmpp.PDUReader;
import org.jsmpp.PDUSender;
import org.jsmpp.PDUStringException;
import org.jsmpp.SynchronizedPDUSender;
import org.jsmpp.bean.Address;
import org.jsmpp.bean.AlertNotification;
import org.jsmpp.bean.BindResp;
import org.jsmpp.bean.BindType;
import org.jsmpp.bean.Command;
import org.jsmpp.bean.DataCoding;
import org.jsmpp.bean.DataSm;
import org.jsmpp.bean.DeliverSm;
import org.jsmpp.bean.ESMClass;
import org.jsmpp.bean.InterfaceVersion;
import org.jsmpp.bean.NumberingPlanIndicator;
import org.jsmpp.bean.OptionalParameter;
import org.jsmpp.bean.QuerySmResp;
import org.jsmpp.bean.RegisteredDelivery;
import org.jsmpp.bean.ReplaceIfPresentFlag;
import org.jsmpp.bean.SubmitMultiResp;
import org.jsmpp.bean.SubmitMultiResult;
import org.jsmpp.bean.SubmitSmResp;
import org.jsmpp.bean.TypeOfNumber;
import org.jsmpp.extra.NegativeResponseException;
import org.jsmpp.extra.PendingResponse;
import org.jsmpp.extra.ProcessRequestException;
import org.jsmpp.extra.ResponseTimeoutException;
import org.jsmpp.extra.SessionState;
import org.jsmpp.session.AbstractSession;
import org.jsmpp.session.AbstractSessionContext;
import org.jsmpp.session.BindCommandTask;
import org.jsmpp.session.BindParameter;
import org.jsmpp.session.CancelSmCommandTask;
import org.jsmpp.session.ClientSession;
import org.jsmpp.session.DataSmResult;
import org.jsmpp.session.GenericMessageReceiverListener;
import org.jsmpp.session.MessageReceiverListener;
import org.jsmpp.session.PDUProcessTask;
import org.jsmpp.session.QuerySmCommandTask;
import org.jsmpp.session.QuerySmResult;
import org.jsmpp.session.ReplaceSmCommandTask;
import org.jsmpp.session.ResponseHandler;
import org.jsmpp.session.SMPPSessionContext;
import org.jsmpp.session.SessionStateListener;
import org.jsmpp.session.SubmitMultiCommandTask;
import org.jsmpp.session.SubmitSmCommandTask;
import org.jsmpp.session.connection.Connection;
import org.jsmpp.session.connection.ConnectionFactory;
import org.jsmpp.session.connection.socket.SocketConnectionFactory;
import org.jsmpp.util.DefaultComposer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SMPPSession
extends AbstractSession
implements ClientSession {
    private static final Logger logger = LoggerFactory.getLogger(SMPPSession.class);
    private final PDUReader pduReader;
    private final ConnectionFactory connFactory;
    private Connection conn;
    private DataInputStream in;
    private OutputStream out;
    private final ResponseHandler responseHandler = new ResponseHandlerImpl();
    private MessageReceiverListener messageReceiverListener;
    private BoundSessionStateListener sessionStateListener = new BoundSessionStateListener();
    private SMPPSessionContext sessionContext = new SMPPSessionContext(this, this.sessionStateListener);
    private EnquireLinkSender enquireLinkSender;

    public SMPPSession() {
        this(new SynchronizedPDUSender(new DefaultPDUSender(new DefaultComposer())), new DefaultPDUReader(), SocketConnectionFactory.getInstance());
    }

    public SMPPSession(PDUSender pduSender, PDUReader pduReader, ConnectionFactory connFactory) {
        super(pduSender);
        this.pduReader = pduReader;
        this.connFactory = connFactory;
        this.addSessionStateListener(new BoundSessionStateListener());
    }

    public SMPPSession(String host, int port, BindParameter bindParam, PDUSender pduSender, PDUReader pduReader, ConnectionFactory connFactory) throws IOException {
        this(pduSender, pduReader, connFactory);
        this.connectAndBind(host, port, bindParam);
    }

    public SMPPSession(String host, int port, BindParameter bindParam) throws IOException {
        this();
        this.connectAndBind(host, port, bindParam);
    }

    public void connectAndBind(String host, int port, BindType bindType, String systemId, String password, String systemType, TypeOfNumber addrTon, NumberingPlanIndicator addrNpi, String addressRange) throws IOException {
        this.connectAndBind(host, port, new BindParameter(bindType, systemId, password, systemType, addrTon, addrNpi, addressRange), 60000L);
    }

    public void connectAndBind(String host, int port, BindType bindType, String systemId, String password, String systemType, TypeOfNumber addrTon, NumberingPlanIndicator addrNpi, String addressRange, long timeout) throws IOException {
        this.connectAndBind(host, port, new BindParameter(bindType, systemId, password, systemType, addrTon, addrNpi, addressRange), timeout);
    }

    public String connectAndBind(String host, int port, BindParameter bindParam) throws IOException {
        return this.connectAndBind(host, port, bindParam, 60000L);
    }

    public String connectAndBind(String host, int port, BindParameter bindParam, long timeout) throws IOException {
        logger.debug("Connect and bind to {} port {}", (Object)host, (Object)port);
        if (this.sequence().currentValue() != 1) {
            throw new IOException("Failed connecting");
        }
        this.conn = this.connFactory.createConnection(host, port);
        logger.info("Connected");
        this.conn.setSoTimeout(this.getEnquireLinkTimer());
        this.sessionContext.open();
        try {
            this.in = new DataInputStream(this.conn.getInputStream());
            this.out = this.conn.getOutputStream();
            new PDUReaderWorker().start();
            String smscSystemId = this.sendBind(bindParam.getBindType(), bindParam.getSystemId(), bindParam.getPassword(), bindParam.getSystemType(), InterfaceVersion.IF_34, bindParam.getAddrTon(), bindParam.getAddrNpi(), bindParam.getAddressRange(), timeout);
            this.sessionContext.bound(bindParam.getBindType());
            this.enquireLinkSender = new EnquireLinkSender();
            this.enquireLinkSender.start();
            return smscSystemId;
        }
        catch (PDUException e) {
            logger.error("Failed sending bind command", (Throwable)e);
            throw new IOException("Failed sending bind since some string parameter area invalid : " + e.getMessage());
        }
        catch (NegativeResponseException e) {
            String message = "Receive negative bind response";
            logger.error(message, (Throwable)e);
            this.close();
            throw new IOException(message + ": " + e.getMessage());
        }
        catch (InvalidResponseException e) {
            String message = "Receive invalid response of bind";
            logger.error(message, (Throwable)e);
            this.close();
            throw new IOException(message + ": " + e.getMessage());
        }
        catch (ResponseTimeoutException e) {
            String message = "Waiting bind response take time to long";
            logger.error(message, (Throwable)e);
            this.close();
            throw new IOException(message + ": " + e.getMessage());
        }
        catch (IOException e) {
            logger.error("IO Error occur", (Throwable)e);
            this.close();
            throw e;
        }
    }

    private String sendBind(BindType bindType, String systemId, String password, String systemType, InterfaceVersion interfaceVersion, TypeOfNumber addrTon, NumberingPlanIndicator addrNpi, String addressRange, long timeout) throws PDUException, ResponseTimeoutException, InvalidResponseException, NegativeResponseException, IOException {
        BindCommandTask task = new BindCommandTask(this.pduSender(), bindType, systemId, password, systemType, interfaceVersion, addrTon, addrNpi, addressRange);
        BindResp resp = (BindResp)this.executeSendCommand(task, timeout);
        return resp.getSystemId();
    }

    @Override
    public String submitShortMessage(String serviceType, TypeOfNumber sourceAddrTon, NumberingPlanIndicator sourceAddrNpi, String sourceAddr, TypeOfNumber destAddrTon, NumberingPlanIndicator destAddrNpi, String destinationAddr, ESMClass esmClass, byte protocolId, byte priorityFlag, String scheduleDeliveryTime, String validityPeriod, RegisteredDelivery registeredDelivery, byte replaceIfPresentFlag, DataCoding dataCoding, byte smDefaultMsgId, byte[] shortMessage, OptionalParameter ... optionalParameters) throws PDUException, ResponseTimeoutException, InvalidResponseException, NegativeResponseException, IOException {
        SubmitSmCommandTask submitSmTask = new SubmitSmCommandTask(this.pduSender(), serviceType, sourceAddrTon, sourceAddrNpi, sourceAddr, destAddrTon, destAddrNpi, destinationAddr, esmClass, protocolId, priorityFlag, scheduleDeliveryTime, validityPeriod, registeredDelivery, replaceIfPresentFlag, dataCoding, smDefaultMsgId, shortMessage, optionalParameters);
        SubmitSmResp resp = (SubmitSmResp)this.executeSendCommand(submitSmTask, this.getTransactionTimer());
        return resp.getMessageId();
    }

    @Override
    public SubmitMultiResult submitMultiple(String serviceType, TypeOfNumber sourceAddrTon, NumberingPlanIndicator sourceAddrNpi, String sourceAddr, Address[] destinationAddresses, ESMClass esmClass, byte protocolId, byte priorityFlag, String scheduleDeliveryTime, String validityPeriod, RegisteredDelivery registeredDelivery, ReplaceIfPresentFlag replaceIfPresentFlag, DataCoding dataCoding, byte smDefaultMsgId, byte[] shortMessage, OptionalParameter[] optionalParameters) throws PDUException, ResponseTimeoutException, InvalidResponseException, NegativeResponseException, IOException {
        SubmitMultiCommandTask task = new SubmitMultiCommandTask(this.pduSender(), serviceType, sourceAddrTon, sourceAddrNpi, sourceAddr, destinationAddresses, esmClass, protocolId, priorityFlag, scheduleDeliveryTime, validityPeriod, registeredDelivery, replaceIfPresentFlag, dataCoding, smDefaultMsgId, shortMessage, optionalParameters);
        SubmitMultiResp resp = (SubmitMultiResp)this.executeSendCommand(task, this.getTransactionTimer());
        return new SubmitMultiResult(resp.getMessageId(), resp.getUnsuccessSmes());
    }

    @Override
    public QuerySmResult queryShortMessage(String messageId, TypeOfNumber sourceAddrTon, NumberingPlanIndicator sourceAddrNpi, String sourceAddr) throws PDUException, ResponseTimeoutException, InvalidResponseException, NegativeResponseException, IOException {
        QuerySmCommandTask task = new QuerySmCommandTask(this.pduSender(), messageId, sourceAddrTon, sourceAddrNpi, sourceAddr);
        QuerySmResp resp = (QuerySmResp)this.executeSendCommand(task, this.getTransactionTimer());
        if (resp.getMessageId().equals(messageId)) {
            return new QuerySmResult(resp.getFinalDate(), resp.getMessageState(), resp.getErrorCode());
        }
        throw new InvalidResponseException("Requested message_id doesn't match with the result");
    }

    @Override
    public void replaceShortMessage(String messageId, TypeOfNumber sourceAddrTon, NumberingPlanIndicator sourceAddrNpi, String sourceAddr, String scheduleDeliveryTime, String validityPeriod, RegisteredDelivery registeredDelivery, byte smDefaultMsgId, byte[] shortMessage) throws PDUException, ResponseTimeoutException, InvalidResponseException, NegativeResponseException, IOException {
        ReplaceSmCommandTask replaceSmTask = new ReplaceSmCommandTask(this.pduSender(), messageId, sourceAddrTon, sourceAddrNpi, sourceAddr, scheduleDeliveryTime, validityPeriod, registeredDelivery, smDefaultMsgId, shortMessage);
        this.executeSendCommand(replaceSmTask, this.getTransactionTimer());
    }

    @Override
    public void cancelShortMessage(String serviceType, String messageId, TypeOfNumber sourceAddrTon, NumberingPlanIndicator sourceAddrNpi, String sourceAddr, TypeOfNumber destAddrTon, NumberingPlanIndicator destAddrNpi, String destinationAddress) throws PDUException, ResponseTimeoutException, InvalidResponseException, NegativeResponseException, IOException {
        CancelSmCommandTask task = new CancelSmCommandTask(this.pduSender(), serviceType, messageId, sourceAddrTon, sourceAddrNpi, sourceAddr, destAddrTon, destAddrNpi, destinationAddress);
        this.executeSendCommand(task, this.getTransactionTimer());
    }

    public MessageReceiverListener getMessageReceiverListener() {
        return this.messageReceiverListener;
    }

    public void setMessageReceiverListener(MessageReceiverListener messageReceiverListener) {
        this.messageReceiverListener = messageReceiverListener;
    }

    @Override
    protected Connection connection() {
        return this.conn;
    }

    @Override
    protected AbstractSessionContext sessionContext() {
        return this.sessionContext;
    }

    @Override
    protected GenericMessageReceiverListener messageReceiverListener() {
        return this.messageReceiverListener;
    }

    private synchronized boolean isReadPdu() {
        return this.sessionContext.getSessionState().isBound() || this.sessionContext.getSessionState().equals((Object)SessionState.OPEN);
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    private void fireAcceptDeliverSm(DeliverSm deliverSm) throws ProcessRequestException {
        if (this.messageReceiverListener != null) {
            this.messageReceiverListener.onAcceptDeliverSm(deliverSm);
        } else {
            logger.warn("Receive deliver_sm but MessageReceiverListener is null. Short message = " + new String(deliverSm.getShortMessage()));
        }
    }

    private void fireAcceptAlertNotification(AlertNotification alertNotification) {
        if (this.messageReceiverListener != null) {
            this.messageReceiverListener.onAcceptAlertNotification(alertNotification);
        } else {
            logger.warn("Receive alert_notification but MessageReceiverListener is null");
        }
    }

    private class BoundSessionStateListener
    implements SessionStateListener {
        private BoundSessionStateListener() {
        }

        @Override
        public void onStateChange(SessionState newState, SessionState oldState, Object source) {
            if (newState.isBound()) {
                try {
                    SMPPSession.this.conn.setSoTimeout(SMPPSession.this.getEnquireLinkTimer());
                }
                catch (IOException e) {
                    logger.error("Failed setting so_timeout for session timer", (Throwable)e);
                }
            }
        }
    }

    private class EnquireLinkSender
    extends Thread {
        private final AtomicBoolean sendingEnquireLink = new AtomicBoolean(false);

        private EnquireLinkSender() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            logger.info("Starting EnquireLinkSender");
            while (SMPPSession.this.isReadPdu()) {
                while (!this.sendingEnquireLink.compareAndSet(true, false) && SMPPSession.this.isReadPdu()) {
                    AtomicBoolean atomicBoolean = this.sendingEnquireLink;
                    synchronized (atomicBoolean) {
                        try {
                            this.sendingEnquireLink.wait(500L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                if (!SMPPSession.this.isReadPdu()) break;
                try {
                    SMPPSession.this.sendEnquireLink();
                }
                catch (ResponseTimeoutException e) {
                    SMPPSession.this.close();
                }
                catch (InvalidResponseException e) {
                    SMPPSession.this.unbindAndClose();
                }
                catch (IOException e) {
                    SMPPSession.this.close();
                }
            }
            logger.info("EnquireLinkSender stop");
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void enquireLink() {
            if (this.sendingEnquireLink.compareAndSet(false, true)) {
                logger.debug("Sending enquire link notify");
                AtomicBoolean atomicBoolean = this.sendingEnquireLink;
                synchronized (atomicBoolean) {
                    this.sendingEnquireLink.notify();
                }
            } else {
                logger.debug("Not sending enquire link notify");
            }
        }
    }

    private class PDUReaderWorker
    extends Thread {
        private ExecutorService executorService;
        private Runnable onIOExceptionTask;

        private PDUReaderWorker() {
            this.executorService = Executors.newFixedThreadPool(SMPPSession.this.getPduProcessorDegree());
            this.onIOExceptionTask = new Runnable(){

                @Override
                public void run() {
                    SMPPSession.this.close();
                }
            };
        }

        @Override
        public void run() {
            logger.info("Starting PDUReaderWorker with processor degree:{} ...", (Object)SMPPSession.this.getPduProcessorDegree());
            while (SMPPSession.this.isReadPdu()) {
                this.readPDU();
            }
            SMPPSession.this.close();
            this.executorService.shutdown();
            logger.info("PDUReaderWorker stop");
        }

        private void readPDU() {
            try {
                Command pduHeader = null;
                byte[] pdu = null;
                pduHeader = SMPPSession.this.pduReader.readPDUHeader(SMPPSession.this.in);
                pdu = SMPPSession.this.pduReader.readPDU(SMPPSession.this.in, pduHeader);
                PDUProcessTask task = new PDUProcessTask(pduHeader, pdu, SMPPSession.this.sessionContext.getStateProcessor(), SMPPSession.this.responseHandler, SMPPSession.this.sessionContext, this.onIOExceptionTask);
                this.executorService.execute(task);
            }
            catch (InvalidCommandLengthException e) {
                logger.warn("Receive invalid command length", (Throwable)e);
                try {
                    SMPPSession.this.pduSender().sendGenericNack(SMPPSession.this.out, 2, 0);
                }
                catch (IOException ee) {
                    logger.warn("Failed sending generic nack", (Throwable)ee);
                }
                SMPPSession.this.unbindAndClose();
            }
            catch (SocketTimeoutException e) {
                this.notifyNoActivity();
            }
            catch (IOException e) {
                SMPPSession.this.close();
            }
        }

        private void notifyNoActivity() {
            logger.debug("No activity notified");
            if (SMPPSession.this.sessionContext().getSessionState().isBound()) {
                SMPPSession.this.enquireLinkSender.enquireLink();
            }
        }
    }

    private class ResponseHandlerImpl
    implements ResponseHandler {
        private ResponseHandlerImpl() {
        }

        @Override
        public void processDeliverSm(DeliverSm deliverSm) throws ProcessRequestException {
            SMPPSession.this.fireAcceptDeliverSm(deliverSm);
        }

        @Override
        public DataSmResult processDataSm(DataSm dataSm) throws ProcessRequestException {
            return SMPPSession.this.fireAcceptDataSm(dataSm);
        }

        @Override
        public void processAlertNotification(AlertNotification alertNotification) {
            SMPPSession.this.fireAcceptAlertNotification(alertNotification);
        }

        @Override
        public void sendDataSmResp(DataSmResult dataSmResult, int sequenceNumber) throws IOException {
            try {
                SMPPSession.this.pduSender().sendDataSmResp(SMPPSession.this.out, sequenceNumber, dataSmResult.getMessageId(), dataSmResult.getOptionalParameters());
            }
            catch (PDUStringException e) {
                logger.error("SYSTEM ERROR. Failed sending dataSmResp", (Throwable)e);
            }
        }

        @Override
        public PendingResponse<Command> removeSentItem(int sequenceNumber) {
            return SMPPSession.this.removePendingResponse(sequenceNumber);
        }

        @Override
        public void notifyUnbonded() {
            SMPPSession.this.sessionContext.unbound();
        }

        @Override
        public void sendDeliverSmResp(int sequenceNumber) throws IOException {
            SMPPSession.this.pduSender().sendDeliverSmResp(SMPPSession.this.out, sequenceNumber);
            logger.debug("deliver_sm_resp with seq_number " + sequenceNumber + " has been sent");
        }

        @Override
        public void sendEnquireLinkResp(int sequenceNumber) throws IOException {
            logger.debug("Sending enquire_link_resp");
            SMPPSession.this.pduSender().sendEnquireLinkResp(SMPPSession.this.out, sequenceNumber);
        }

        @Override
        public void sendGenerickNack(int commandStatus, int sequenceNumber) throws IOException {
            SMPPSession.this.pduSender().sendGenericNack(SMPPSession.this.out, commandStatus, sequenceNumber);
        }

        @Override
        public void sendNegativeResponse(int originalCommandId, int commandStatus, int sequenceNumber) throws IOException {
            SMPPSession.this.pduSender().sendHeader(SMPPSession.this.out, originalCommandId | Integer.MIN_VALUE, commandStatus, sequenceNumber);
        }

        @Override
        public void sendUnbindResp(int sequenceNumber) throws IOException {
            SMPPSession.this.pduSender().sendUnbindResp(SMPPSession.this.out, 0, sequenceNumber);
        }
    }
}

