/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.util;

import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.TimeZone;
import org.jsmpp.util.TimeFormatter;

public class RelativeTimeFormatter
implements TimeFormatter {
    private final TimeZone timezone;
    private static final String DATE_FORMAT = "{0,number,00}{1,number,00}{2,number,00}{3,number,00}{4,number,00}{5,number,00}000R";

    public RelativeTimeFormatter() {
        this(TimeZone.getDefault());
    }

    public RelativeTimeFormatter(TimeZone timezone) {
        this.timezone = timezone;
    }

    @Override
    public String format(Calendar calendar) {
        if (calendar == null) {
            return null;
        }
        long relativeTime = calendar.getTimeInMillis() - (long)calendar.getTimeZone().getRawOffset() + (long)this.timezone.getRawOffset();
        Calendar cal = Calendar.getInstance();
        cal.setTimeInMillis(relativeTime);
        int year = cal.get(1) - 2000;
        int month = cal.get(2) + 1;
        int day = cal.get(5);
        int hour = cal.get(11);
        int minute = cal.get(12);
        int second = cal.get(13);
        return RelativeTimeFormatter.format(year, month, day, hour, minute, second);
    }

    @Override
    public String format(Date date) {
        if (date == null) {
            return null;
        }
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return this.format(cal);
    }

    public static final String format(Integer year, Integer month, Integer day, Integer hour, Integer minute, Integer second) {
        Object[] args = new Object[]{year, month, day, hour, minute, second};
        return MessageFormat.format(DATE_FORMAT, args);
    }
}

