/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smpp;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.smpp.SmppCommand;
import org.apache.camel.component.smpp.SmppConfiguration;
import org.jsmpp.bean.OptionalParameter;
import org.jsmpp.session.SMPPSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractSmppCommand
implements SmppCommand {
    protected final Logger log = LoggerFactory.getLogger(this.getClass());
    protected SMPPSession session;
    protected SmppConfiguration config;

    public AbstractSmppCommand(SMPPSession session, SmppConfiguration config) {
        this.session = session;
        this.config = config;
    }

    protected Message getResponseMessage(Exchange exchange) {
        Message message = exchange.getPattern().isOutCapable() ? exchange.getOut() : exchange.getIn();
        return message;
    }

    protected List<OptionalParameter> createOptionalParametersByCode(Map<Short, Object> optinalParamaters) {
        ArrayList<OptionalParameter> optParams = new ArrayList<OptionalParameter>();
        for (Map.Entry<Short, Object> entry : optinalParamaters.entrySet()) {
            OptionalParameter optParam = null;
            Short key = entry.getKey();
            Object value = entry.getValue();
            try {
                if (value == null) {
                    optParam = new OptionalParameter.Null(key);
                } else if (value instanceof byte[]) {
                    optParam = new OptionalParameter.OctetString((short)key, (byte[])value);
                } else if (value instanceof String) {
                    optParam = new OptionalParameter.COctetString((short)key, (String)value);
                } else if (value instanceof Byte) {
                    optParam = new OptionalParameter.Byte((short)key, (byte)((Byte)value));
                } else if (value instanceof Integer) {
                    optParam = new OptionalParameter.Int((short)key, (int)((Integer)value));
                } else if (value instanceof Short) {
                    optParam = new OptionalParameter.Short((short)key, (short)((Short)value));
                } else {
                    this.log.info("Couldn't determine optional parameter for value {} (type: {}). Skip this one.", value, value.getClass());
                    continue;
                }
                optParams.add(optParam);
            }
            catch (Exception e) {
                this.log.info("Couldn't determine optional parameter for key {} and value {}. Skip this one.", (Object)key, value);
            }
        }
        return optParams;
    }

    @Deprecated
    protected List<OptionalParameter> createOptionalParametersByName(Map<String, String> optinalParamaters) {
        ArrayList<OptionalParameter> optParams = new ArrayList<OptionalParameter>();
        for (Map.Entry<String, String> entry : optinalParamaters.entrySet()) {
            OptionalParameter optParam = null;
            try {
                OptionalParameter.Tag tag = OptionalParameter.Tag.valueOf(entry.getKey());
                Class<? extends OptionalParameter> type = this.determineTypeClass(tag);
                if (OptionalParameter.OctetString.class.equals(type)) {
                    optParam = new OptionalParameter.OctetString(tag.code(), entry.getValue());
                } else if (OptionalParameter.COctetString.class.equals(type)) {
                    optParam = new OptionalParameter.COctetString(tag.code(), entry.getValue());
                } else if (OptionalParameter.Byte.class.equals(type)) {
                    optParam = new OptionalParameter.Byte(tag.code(), (byte)Byte.valueOf(entry.getValue()));
                } else if (OptionalParameter.Int.class.equals(type)) {
                    optParam = new OptionalParameter.Int(tag.code(), (int)Integer.valueOf(entry.getValue()));
                } else if (OptionalParameter.Short.class.equals(type)) {
                    optParam = new OptionalParameter.Short(tag.code(), (short)Short.valueOf(entry.getValue()));
                } else if (OptionalParameter.Null.class.equals(type)) {
                    optParam = new OptionalParameter.Null(tag);
                }
                optParams.add(optParam);
            }
            catch (Exception e) {
                this.log.info("Couldn't determine optional parameter for key {} and value {}. Skip this one.", (Object)entry.getKey(), (Object)entry.getValue());
            }
        }
        return optParams;
    }

    protected Class<? extends OptionalParameter> determineTypeClass(OptionalParameter.Tag tag) throws SecurityException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        Field f = ((Object)((Object)tag)).getClass().getDeclaredField("type");
        f.setAccessible(true);
        return (Class)f.get((Object)tag);
    }
}

