/*
 * Decompiled with CFR 0.152.
 */
package org.jsmpp.session;

import java.io.IOException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.jsmpp.PDUStringException;
import org.jsmpp.bean.Bind;
import org.jsmpp.bean.BindType;
import org.jsmpp.bean.NumberingPlanIndicator;
import org.jsmpp.bean.TypeOfNumber;
import org.jsmpp.session.BindParameter;
import org.jsmpp.session.ServerResponseHandler;
import org.jsmpp.util.StringParameter;
import org.jsmpp.util.StringValidator;

public class BindRequest {
    private final Lock lock = new ReentrantLock();
    private final Condition condition = this.lock.newCondition();
    private final BindType bindType;
    private final String systemId;
    private final String password;
    private final String systemType;
    private final TypeOfNumber addrTon;
    private final NumberingPlanIndicator addrNpi;
    private final String addressRange;
    private final int originalSequenceNumber;
    private boolean done;
    private final ServerResponseHandler responseHandler;

    public BindRequest(int sequenceNumber, BindType bindType, String systemId, String password, String systemType, TypeOfNumber addrTon, NumberingPlanIndicator addrNpi, String addressRange, ServerResponseHandler responseHandler) {
        this.originalSequenceNumber = sequenceNumber;
        this.responseHandler = responseHandler;
        this.bindType = bindType;
        this.systemId = systemId;
        this.password = password;
        this.systemType = systemType;
        this.addrTon = addrTon;
        this.addrNpi = addrNpi;
        this.addressRange = addressRange;
    }

    public BindRequest(Bind bind, ServerResponseHandler responseHandler) {
        this(bind.getSequenceNumber(), BindType.valueOf(bind.getCommandId()), bind.getSystemId(), bind.getPassword(), bind.getSystemType(), TypeOfNumber.valueOf(bind.getAddrTon()), NumberingPlanIndicator.valueOf(bind.getAddrNpi()), bind.getAddressRange(), responseHandler);
    }

    @Deprecated
    public BindParameter getBindParameter() {
        return new BindParameter(this.bindType, this.systemId, this.password, this.systemType, this.addrTon, this.addrNpi, this.addressRange);
    }

    public BindType getBindType() {
        return this.bindType;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public String getPassword() {
        return this.password;
    }

    public String getSystemType() {
        return this.systemType;
    }

    public TypeOfNumber getAddrTon() {
        return this.addrTon;
    }

    public NumberingPlanIndicator getAddrNpi() {
        return this.addrNpi;
    }

    public String getAddressRange() {
        return this.addressRange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accept(String systemId) throws PDUStringException, IllegalStateException, IOException {
        block7: {
            StringValidator.validateString(systemId, StringParameter.SYSTEM_ID);
            this.lock.lock();
            try {
                if (!this.done) {
                    this.done = true;
                    try {
                        this.responseHandler.sendBindResp(systemId, this.bindType, this.originalSequenceNumber);
                        break block7;
                    }
                    finally {
                        this.condition.signal();
                    }
                }
                throw new IllegalStateException("Response already initiated");
            }
            finally {
                this.lock.unlock();
            }
        }
        this.done = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reject(int errorCode) throws IllegalStateException, IOException {
        this.lock.lock();
        try {
            if (this.done) {
                throw new IllegalStateException("Response already initiated");
            }
            this.done = true;
            try {
                this.responseHandler.sendNegativeResponse(this.bindType.commandId(), errorCode, this.originalSequenceNumber);
            }
            finally {
                this.condition.signal();
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

