/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smpp;

import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.smpp.SmppEndpoint;
import org.apache.camel.spi.ExceptionHandler;
import org.jsmpp.bean.AlertNotification;
import org.jsmpp.bean.DataSm;
import org.jsmpp.bean.DeliverSm;
import org.jsmpp.extra.ProcessRequestException;
import org.jsmpp.session.DataSmResult;
import org.jsmpp.session.MessageReceiverListener;
import org.jsmpp.session.Session;
import org.jsmpp.util.MessageIDGenerator;
import org.jsmpp.util.MessageId;
import org.jsmpp.util.RandomMessageIDGenerator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageReceiverListenerImpl
implements MessageReceiverListener {
    private static final Logger LOG = LoggerFactory.getLogger(MessageReceiverListenerImpl.class);
    private MessageIDGenerator messageIDGenerator = new RandomMessageIDGenerator();
    private SmppEndpoint endpoint;
    private Processor processor;
    private ExceptionHandler exceptionHandler;

    public MessageReceiverListenerImpl(SmppEndpoint endpoint, Processor processor, ExceptionHandler exceptionHandler) {
        this.endpoint = endpoint;
        this.processor = processor;
        this.exceptionHandler = exceptionHandler;
    }

    @Override
    public void onAcceptAlertNotification(AlertNotification alertNotification) {
        LOG.debug("Received an alertNotification {}", (Object)alertNotification);
        Exchange exchange = this.endpoint.createOnAcceptAlertNotificationExchange(alertNotification);
        try {
            this.processor.process(exchange);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        if (exchange.getException() != null) {
            this.exceptionHandler.handleException("Cannot process exchange. This exception will be ignored.", exchange, (Throwable)exchange.getException());
        }
    }

    @Override
    public void onAcceptDeliverSm(DeliverSm deliverSm) throws ProcessRequestException {
        Exchange exchange;
        LOG.debug("Received a deliverSm {}", (Object)deliverSm);
        try {
            exchange = this.endpoint.createOnAcceptDeliverSmExchange(deliverSm);
        }
        catch (Exception e) {
            this.exceptionHandler.handleException("Cannot create exchange. This exception will be ignored.", (Throwable)e);
            return;
        }
        try {
            this.processor.process(exchange);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        if (exchange.getException() != null) {
            ProcessRequestException pre = (ProcessRequestException)exchange.getException(ProcessRequestException.class);
            if (pre == null) {
                pre = new ProcessRequestException(exchange.getException().getMessage(), 255, exchange.getException());
            }
            throw pre;
        }
    }

    @Override
    public DataSmResult onAcceptDataSm(DataSm dataSm, Session session) throws ProcessRequestException {
        LOG.debug("Received a dataSm {}", (Object)dataSm);
        MessageId newMessageId = this.messageIDGenerator.newMessageId();
        Exchange exchange = this.endpoint.createOnAcceptDataSm(dataSm, newMessageId.getValue());
        try {
            this.processor.process(exchange);
        }
        catch (Exception e) {
            exchange.setException((Throwable)e);
        }
        if (exchange.getException() != null) {
            ProcessRequestException pre = (ProcessRequestException)exchange.getException(ProcessRequestException.class);
            if (pre == null) {
                pre = new ProcessRequestException(exchange.getException().getMessage(), 255, exchange.getException());
            }
            throw pre;
        }
        return new DataSmResult(newMessageId, dataSm.getOptionalParameters());
    }

    public void setMessageIDGenerator(MessageIDGenerator messageIDGenerator) {
        this.messageIDGenerator = messageIDGenerator;
    }
}

