/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smpp;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.camel.CamelContext;
import org.apache.camel.Exchange;
import org.apache.camel.component.smpp.SmppCommand;
import org.apache.camel.component.smpp.SmppCommandType;
import org.apache.camel.component.smpp.SmppConfiguration;
import org.apache.camel.component.smpp.SmppMessage;
import org.apache.camel.component.smpp.SmppMessageType;
import org.apache.camel.component.smpp.SmppUtils;
import org.jsmpp.bean.AlertNotification;
import org.jsmpp.bean.Alphabet;
import org.jsmpp.bean.DataSm;
import org.jsmpp.bean.DeliverSm;
import org.jsmpp.bean.DeliveryReceipt;
import org.jsmpp.bean.OptionalParameter;
import org.jsmpp.session.SMPPSession;
import org.jsmpp.util.DefaultDecomposer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmppBinding {
    private static final Logger LOG = LoggerFactory.getLogger(SmppBinding.class);
    private SmppConfiguration configuration;

    public SmppBinding() {
        this.configuration = new SmppConfiguration();
    }

    public SmppBinding(SmppConfiguration configuration) {
        this.configuration = configuration;
    }

    public SmppCommand createSmppCommand(SMPPSession session, Exchange exchange) {
        SmppCommandType commandType = SmppCommandType.fromExchange(exchange);
        SmppCommand command = commandType.createCommand(session, this.configuration);
        return command;
    }

    public SmppMessage createSmppMessage(CamelContext camelContext, AlertNotification alertNotification) {
        SmppMessage smppMessage = new SmppMessage(alertNotification, this.configuration);
        smppMessage.setCamelContext(camelContext);
        smppMessage.setHeader("CamelSmppMessageType", SmppMessageType.AlertNotification.toString());
        smppMessage.setHeader("CamelSmppSequenceNumber", alertNotification.getSequenceNumber());
        smppMessage.setHeader("CamelSmppCommandId", alertNotification.getCommandId());
        smppMessage.setHeader("CamelSmppCommandStatus", alertNotification.getCommandStatus());
        smppMessage.setHeader("CamelSmppSourceAddr", alertNotification.getSourceAddr());
        smppMessage.setHeader("CamelSmppSourceAddrNpi", alertNotification.getSourceAddrNpi());
        smppMessage.setHeader("CamelSmppSourceAddrTon", alertNotification.getSourceAddrTon());
        smppMessage.setHeader("CamelSmppEsmeAddr", alertNotification.getEsmeAddr());
        smppMessage.setHeader("CamelSmppEsmeAddrNpi", alertNotification.getEsmeAddrNpi());
        smppMessage.setHeader("CamelSmppEsmeAddrTon", alertNotification.getEsmeAddrTon());
        return smppMessage;
    }

    public SmppMessage createSmppMessage(CamelContext camelContext, DeliverSm deliverSm) throws Exception {
        SmppMessage smppMessage = new SmppMessage(deliverSm, this.configuration);
        smppMessage.setCamelContext(camelContext);
        String messagePayload = null;
        if (deliverSm.getShortMessage() == null && deliverSm.getOptionalParameters() != null) {
            List<OptionalParameter> oplist = Arrays.asList(deliverSm.getOptionalParameters());
            for (OptionalParameter optPara : oplist) {
                if (OptionalParameter.Tag.MESSAGE_PAYLOAD.code() != optPara.tag || !OptionalParameter.OctetString.class.isInstance(optPara)) continue;
                messagePayload = ((OptionalParameter.OctetString)optPara).getValueAsString();
                break;
            }
        }
        if (deliverSm.isSmscDeliveryReceipt()) {
            smppMessage.setHeader("CamelSmppMessageType", SmppMessageType.DeliveryReceipt.toString());
            DeliveryReceipt smscDeliveryReceipt = null;
            if (deliverSm.getShortMessage() != null) {
                smscDeliveryReceipt = deliverSm.getShortMessageAsDeliveryReceipt();
            } else if (messagePayload != null) {
                smscDeliveryReceipt = DefaultDecomposer.getInstance().deliveryReceipt(messagePayload);
            }
            if (smscDeliveryReceipt != null) {
                smppMessage.setBody(smscDeliveryReceipt.getText());
                smppMessage.setHeader("CamelSmppId", smscDeliveryReceipt.getId());
                smppMessage.setHeader("CamelSmppDelivered", smscDeliveryReceipt.getDelivered());
                smppMessage.setHeader("CamelSmppDoneDate", smscDeliveryReceipt.getDoneDate());
                if (!"000".equals(smscDeliveryReceipt.getError())) {
                    smppMessage.setHeader("CamelSmppError", smscDeliveryReceipt.getError());
                }
                smppMessage.setHeader("CamelSmppSubmitDate", smscDeliveryReceipt.getSubmitDate());
                smppMessage.setHeader("CamelSmppSubmitted", smscDeliveryReceipt.getSubmitted());
                smppMessage.setHeader("CamelSmppStatus", (Object)smscDeliveryReceipt.getFinalStatus());
            }
            if (deliverSm.getOptionalParameters() != null && deliverSm.getOptionalParameters().length > 0) {
                Map<String, Object> optionalParameters = this.createOptionalParameterByName(deliverSm);
                smppMessage.setHeader("CamelSmppOptionalParameters", optionalParameters);
                Map<Short, Object> optionalParameter = this.createOptionalParameterByCode(deliverSm);
                smppMessage.setHeader("CamelSmppOptionalParameter", optionalParameter);
            }
        } else {
            smppMessage.setHeader("CamelSmppMessageType", SmppMessageType.DeliverSm.toString());
            if (deliverSm.getShortMessage() != null) {
                Alphabet alphabet = Alphabet.parseDataCoding(deliverSm.getDataCoding());
                if (SmppUtils.is8Bit(alphabet)) {
                    smppMessage.setBody(deliverSm.getShortMessage());
                } else {
                    smppMessage.setBody(String.valueOf(new String(deliverSm.getShortMessage(), this.configuration.getEncoding())));
                }
            } else if (messagePayload != null) {
                smppMessage.setBody(messagePayload);
            }
            smppMessage.setHeader("CamelSmppSequenceNumber", deliverSm.getSequenceNumber());
            smppMessage.setHeader("CamelSmppCommandId", deliverSm.getCommandId());
            smppMessage.setHeader("CamelSmppSourceAddr", deliverSm.getSourceAddr());
            smppMessage.setHeader("CamelSmppSourceAddrNpi", deliverSm.getSourceAddrNpi());
            smppMessage.setHeader("CamelSmppSourceAddrTon", deliverSm.getSourceAddrTon());
            smppMessage.setHeader("CamelSmppDataCoding", deliverSm.getDataCoding());
            smppMessage.setHeader("CamelSmppDestAddr", deliverSm.getDestAddress());
            smppMessage.setHeader("CamelSmppDestAddrNpi", deliverSm.getDestAddrNpi());
            smppMessage.setHeader("CamelSmppDestAddrTon", deliverSm.getDestAddrTon());
            smppMessage.setHeader("CamelSmppScheduleDeliveryTime", deliverSm.getScheduleDeliveryTime());
            smppMessage.setHeader("CamelSmppValidityPeriod", deliverSm.getValidityPeriod());
            smppMessage.setHeader("CamelSmppServiceType", deliverSm.getServiceType());
        }
        return smppMessage;
    }

    private Map<String, Object> createOptionalParameterByName(DeliverSm deliverSm) {
        List<OptionalParameter> oplist = Arrays.asList(deliverSm.getOptionalParameters());
        HashMap<String, Object> optParams = new HashMap<String, Object>();
        for (OptionalParameter optPara : oplist) {
            try {
                OptionalParameter.Tag valueOfTag = OptionalParameter.Tag.valueOf(optPara.tag);
                if (valueOfTag != null) {
                    if (OptionalParameter.COctetString.class.isInstance(optPara)) {
                        optParams.put(valueOfTag.toString(), ((OptionalParameter.COctetString)optPara).getValueAsString());
                        continue;
                    }
                    if (OptionalParameter.OctetString.class.isInstance(optPara)) {
                        optParams.put(valueOfTag.toString(), ((OptionalParameter.OctetString)optPara).getValueAsString());
                        continue;
                    }
                    if (OptionalParameter.Byte.class.isInstance(optPara)) {
                        optParams.put(valueOfTag.toString(), ((OptionalParameter.Byte)optPara).getValue());
                        continue;
                    }
                    if (OptionalParameter.Short.class.isInstance(optPara)) {
                        optParams.put(valueOfTag.toString(), ((OptionalParameter.Short)optPara).getValue());
                        continue;
                    }
                    if (OptionalParameter.Int.class.isInstance(optPara)) {
                        optParams.put(valueOfTag.toString(), ((OptionalParameter.Int)optPara).getValue());
                        continue;
                    }
                    if (!OptionalParameter.Null.class.isInstance(optPara)) continue;
                    optParams.put(valueOfTag.toString(), null);
                    continue;
                }
                LOG.debug("Skipping optional parameter with tag {} because it was not recognized", (Object)optPara.tag);
            }
            catch (IllegalArgumentException e) {
                LOG.debug("Skipping optional parameter with tag {} due to {}", (Object)optPara.tag, (Object)e.getMessage());
            }
        }
        return optParams;
    }

    private Map<Short, Object> createOptionalParameterByCode(DeliverSm deliverSm) {
        List<OptionalParameter> oplist = Arrays.asList(deliverSm.getOptionalParameters());
        HashMap<Short, Object> optParams = new HashMap<Short, Object>();
        for (OptionalParameter optPara : oplist) {
            if (OptionalParameter.COctetString.class.isInstance(optPara)) {
                optParams.put(optPara.tag, ((OptionalParameter.COctetString)optPara).getValueAsString());
                continue;
            }
            if (OptionalParameter.OctetString.class.isInstance(optPara)) {
                optParams.put(optPara.tag, ((OptionalParameter.OctetString)optPara).getValue());
                continue;
            }
            if (OptionalParameter.Byte.class.isInstance(optPara)) {
                optParams.put(optPara.tag, ((OptionalParameter.Byte)optPara).getValue());
                continue;
            }
            if (OptionalParameter.Short.class.isInstance(optPara)) {
                optParams.put(optPara.tag, ((OptionalParameter.Short)optPara).getValue());
                continue;
            }
            if (OptionalParameter.Int.class.isInstance(optPara)) {
                optParams.put(optPara.tag, ((OptionalParameter.Int)optPara).getValue());
                continue;
            }
            if (!OptionalParameter.Null.class.isInstance(optPara)) continue;
            optParams.put(optPara.tag, null);
        }
        return optParams;
    }

    public SmppMessage createSmppMessage(CamelContext camelContext, DataSm dataSm, String smppMessageId) {
        SmppMessage smppMessage = new SmppMessage(dataSm, this.configuration);
        smppMessage.setCamelContext(camelContext);
        smppMessage.setHeader("CamelSmppMessageType", SmppMessageType.DataSm.toString());
        smppMessage.setHeader("CamelSmppId", smppMessageId);
        smppMessage.setHeader("CamelSmppSequenceNumber", dataSm.getSequenceNumber());
        smppMessage.setHeader("CamelSmppCommandId", dataSm.getCommandId());
        smppMessage.setHeader("CamelSmppCommandStatus", dataSm.getCommandStatus());
        smppMessage.setHeader("CamelSmppSourceAddr", dataSm.getSourceAddr());
        smppMessage.setHeader("CamelSmppSourceAddrNpi", dataSm.getSourceAddrNpi());
        smppMessage.setHeader("CamelSmppSourceAddrTon", dataSm.getSourceAddrTon());
        smppMessage.setHeader("CamelSmppDestAddr", dataSm.getDestAddress());
        smppMessage.setHeader("CamelSmppDestAddrNpi", dataSm.getDestAddrNpi());
        smppMessage.setHeader("CamelSmppDestAddrTon", dataSm.getDestAddrTon());
        smppMessage.setHeader("CamelSmppServiceType", dataSm.getServiceType());
        smppMessage.setHeader("CamelSmppRegisteredDelivery", dataSm.getRegisteredDelivery());
        smppMessage.setHeader("CamelSmppDataCoding", dataSm.getDataCoding());
        return smppMessage;
    }

    Date getCurrentDate() {
        return new Date();
    }

    public SmppConfiguration getConfiguration() {
        return this.configuration;
    }

    public void setConfiguration(SmppConfiguration configuration) {
        this.configuration = configuration;
    }
}

