/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.smpp;

import org.apache.camel.Exchange;
import org.apache.camel.Message;
import org.apache.camel.component.smpp.AbstractSmppCommand;
import org.apache.camel.component.smpp.SmppConfiguration;
import org.apache.camel.component.smpp.SmppException;
import org.jsmpp.bean.CancelSm;
import org.jsmpp.bean.NumberingPlanIndicator;
import org.jsmpp.bean.TypeOfNumber;
import org.jsmpp.session.SMPPSession;

public class SmppCancelSmCommand
extends AbstractSmppCommand {
    public SmppCancelSmCommand(SMPPSession session, SmppConfiguration config) {
        super(session, config);
    }

    @Override
    public void execute(Exchange exchange) throws SmppException {
        CancelSm cancelSm = this.createCancelSm(exchange);
        if (this.log.isDebugEnabled()) {
            this.log.debug("Canceling a short message for exchange id '{}' and message id '{}'", (Object)exchange.getExchangeId(), (Object)cancelSm.getMessageId());
        }
        try {
            this.session.cancelShortMessage(cancelSm.getServiceType(), cancelSm.getMessageId(), TypeOfNumber.valueOf(cancelSm.getSourceAddrTon()), NumberingPlanIndicator.valueOf(cancelSm.getSourceAddrNpi()), cancelSm.getSourceAddr(), TypeOfNumber.valueOf(cancelSm.getDestAddrTon()), NumberingPlanIndicator.valueOf(cancelSm.getDestAddrNpi()), cancelSm.getDestinationAddress());
        }
        catch (Exception e) {
            throw new SmppException(e);
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("Cancel a short message for exchange id '{}' and message id '{}'", (Object)exchange.getExchangeId(), (Object)cancelSm.getMessageId());
        }
        Message message = this.getResponseMessage(exchange);
        message.setHeader("CamelSmppId", (Object)cancelSm.getMessageId());
    }

    protected CancelSm createCancelSm(Exchange exchange) {
        Message in = exchange.getIn();
        CancelSm cancelSm = new CancelSm();
        if (in.getHeaders().containsKey("CamelSmppId")) {
            cancelSm.setMessageId((String)in.getHeader("CamelSmppId", String.class));
        }
        if (in.getHeaders().containsKey("CamelSmppSourceAddr")) {
            cancelSm.setSourceAddr((String)in.getHeader("CamelSmppSourceAddr", String.class));
        } else {
            cancelSm.setSourceAddr(this.config.getSourceAddr());
        }
        if (in.getHeaders().containsKey("CamelSmppSourceAddrTon")) {
            cancelSm.setSourceAddrTon((Byte)in.getHeader("CamelSmppSourceAddrTon", Byte.class));
        } else {
            cancelSm.setSourceAddrTon(this.config.getSourceAddrTon());
        }
        if (in.getHeaders().containsKey("CamelSmppSourceAddrNpi")) {
            cancelSm.setSourceAddrNpi((Byte)in.getHeader("CamelSmppSourceAddrNpi", Byte.class));
        } else {
            cancelSm.setSourceAddrNpi(this.config.getSourceAddrNpi());
        }
        if (in.getHeaders().containsKey("CamelSmppDestAddr")) {
            cancelSm.setDestinationAddress((String)in.getHeader("CamelSmppDestAddr", String.class));
        } else {
            cancelSm.setDestinationAddress(this.config.getDestAddr());
        }
        if (in.getHeaders().containsKey("CamelSmppDestAddrTon")) {
            cancelSm.setDestAddrTon((Byte)in.getHeader("CamelSmppDestAddrTon", Byte.class));
        } else {
            cancelSm.setDestAddrTon(this.config.getDestAddrTon());
        }
        if (in.getHeaders().containsKey("CamelSmppDestAddrNpi")) {
            cancelSm.setDestAddrNpi((Byte)in.getHeader("CamelSmppDestAddrNpi", Byte.class));
        } else {
            cancelSm.setDestAddrNpi(this.config.getDestAddrNpi());
        }
        if (in.getHeaders().containsKey("CamelSmppServiceType")) {
            cancelSm.setServiceType((String)in.getHeader("CamelSmppServiceType", String.class));
        } else {
            cancelSm.setServiceType(this.config.getServiceType());
        }
        return cancelSm;
    }
}

