/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TimerTask;
import org.snmp4j.CommandResponder;
import org.snmp4j.CommandResponderEvent;
import org.snmp4j.DefaultTimeoutModel;
import org.snmp4j.MessageDispatcher;
import org.snmp4j.MessageDispatcherImpl;
import org.snmp4j.MessageException;
import org.snmp4j.PDU;
import org.snmp4j.PDUv1;
import org.snmp4j.SNMP4JSettings;
import org.snmp4j.ScopedPDU;
import org.snmp4j.SecureTarget;
import org.snmp4j.Session;
import org.snmp4j.Target;
import org.snmp4j.TimeoutModel;
import org.snmp4j.TransportMapping;
import org.snmp4j.UserTarget;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.event.ResponseListener;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogFactory;
import org.snmp4j.mp.MPv1;
import org.snmp4j.mp.MPv2c;
import org.snmp4j.mp.MPv3;
import org.snmp4j.mp.MessageProcessingModel;
import org.snmp4j.mp.PduHandle;
import org.snmp4j.mp.PduHandleCallback;
import org.snmp4j.mp.SnmpConstants;
import org.snmp4j.mp.StatusInformation;
import org.snmp4j.security.SecurityModel;
import org.snmp4j.security.SecurityProtocols;
import org.snmp4j.security.USM;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.ConnectionOrientedTransportMapping;
import org.snmp4j.transport.TransportMappings;
import org.snmp4j.util.CommonTimer;

public class Snmp
implements Session,
CommandResponder {
    private static final LogAdapter logger = LogFactory.getLogger(Snmp.class);
    private static final int DEFAULT_MAX_REQUEST_STATUS = 2;
    private static final int ENGINE_ID_DISCOVERY_MAX_REQUEST_STATUS = 0;
    private MessageDispatcher messageDispatcher;
    private final Map<PduHandle, PendingRequest> pendingRequests = new Hashtable<PduHandle, PendingRequest>(50);
    private final Map<Object, PduHandle> asyncRequests = new Hashtable<Object, PduHandle>(50);
    private CommonTimer timer;
    private List<CommandResponder> commandResponderListeners;
    private TimeoutModel timeoutModel = new DefaultTimeoutModel();
    private NotificationDispatcher notificationDispatcher = null;
    private ReportHandler reportHandler = new ReportProcessor();
    private Map<Address, OctetString> contextEngineIDs = Collections.synchronizedMap(new HashMap());
    private boolean contextEngineIdDiscoveryDisabled;

    public Snmp() {
        this.messageDispatcher = new MessageDispatcherImpl();
    }

    protected final void initMessageDispatcher() {
        this.messageDispatcher.addCommandResponder(this);
        this.messageDispatcher.addMessageProcessingModel(new MPv2c());
        this.messageDispatcher.addMessageProcessingModel(new MPv1());
        this.messageDispatcher.addMessageProcessingModel(new MPv3());
        SecurityProtocols.getInstance().addDefaultProtocols();
    }

    public Snmp(TransportMapping transportMapping) {
        this();
        this.initMessageDispatcher();
        if (transportMapping != null) {
            this.addTransportMapping(transportMapping);
        }
    }

    public Snmp(MessageDispatcher messageDispatcher, TransportMapping transportMapping) {
        this.messageDispatcher = messageDispatcher;
        this.messageDispatcher.addCommandResponder(this);
        if (transportMapping != null) {
            this.addTransportMapping(transportMapping);
        }
    }

    public Snmp(MessageDispatcher messageDispatcher) {
        this.messageDispatcher = messageDispatcher;
        this.messageDispatcher.addCommandResponder(this);
    }

    public MessageDispatcher getMessageDispatcher() {
        return this.messageDispatcher;
    }

    public void addTransportMapping(TransportMapping transportMapping) {
        this.messageDispatcher.addTransportMapping(transportMapping);
        transportMapping.addTransportListener(this.messageDispatcher);
    }

    public void removeTransportMapping(TransportMapping<Address> transportMapping) {
        this.messageDispatcher.removeTransportMapping(transportMapping);
        transportMapping.removeTransportListener(this.messageDispatcher);
    }

    public synchronized boolean addNotificationListener(Address listenAddress, CommandResponder listener) {
        TransportMapping tm = TransportMappings.getInstance().createTransportMapping(listenAddress);
        if (tm == null) {
            if (logger.isInfoEnabled()) {
                logger.info("Failed to add notification listener for address: " + listenAddress);
            }
            return false;
        }
        if (tm instanceof ConnectionOrientedTransportMapping) {
            ((ConnectionOrientedTransportMapping)tm).setConnectionTimeout(0L);
        }
        tm.addTransportListener(this.messageDispatcher);
        if (this.notificationDispatcher == null) {
            this.notificationDispatcher = new NotificationDispatcher();
            this.addCommandResponder(this.notificationDispatcher);
        }
        this.notificationDispatcher.addNotificationListener(listenAddress, tm, listener);
        try {
            tm.listen();
            if (logger.isInfoEnabled()) {
                logger.info("Added notification listener for address: " + listenAddress);
            }
            return true;
        }
        catch (IOException ex) {
            logger.warn((Serializable)((Object)("Failed to initialize notification listener for address '" + listenAddress + "': " + ex.getMessage())));
            return false;
        }
    }

    public synchronized boolean removeNotificationListener(Address listenAddress) {
        if (this.notificationDispatcher != null) {
            if (logger.isInfoEnabled()) {
                logger.info("Removing notification listener for address: " + listenAddress);
            }
            return this.notificationDispatcher.removeNotificationListener(listenAddress);
        }
        return false;
    }

    public void listen() throws IOException {
        for (TransportMapping tm : this.messageDispatcher.getTransportMappings()) {
            if (tm.isListening()) continue;
            tm.listen();
        }
    }

    public int getNextRequestID() {
        return this.messageDispatcher.getNextRequestID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        ArrayList<PendingRequest> pr;
        for (TransportMapping tm : this.messageDispatcher.getTransportMappings()) {
            if (!tm.isListening()) continue;
            tm.close();
        }
        CommonTimer t = this.timer;
        this.timer = null;
        if (t != null) {
            t.cancel();
        }
        if (this.notificationDispatcher != null) {
            this.notificationDispatcher.closeAll();
        }
        Map<PduHandle, PendingRequest> map = this.pendingRequests;
        synchronized (map) {
            pr = new ArrayList<PendingRequest>(this.pendingRequests.values());
        }
        for (PendingRequest pending : pr) {
            ResponseEvent e = new ResponseEvent(this, null, pending.pdu, null, pending.userObject, new InterruptedException("Snmp session has been closed"));
            ResponseListener l = pending.listener;
            if (l == null) continue;
            l.onResponse(e);
        }
    }

    public ResponseEvent get(PDU pdu, Target target) throws IOException {
        pdu.setType(-96);
        return this.send(pdu, target);
    }

    public void get(PDU pdu, Target target, Object userHandle, ResponseListener listener) throws IOException {
        pdu.setType(-96);
        this.send(pdu, target, userHandle, listener);
    }

    public ResponseEvent getNext(PDU pdu, Target target) throws IOException {
        pdu.setType(-95);
        return this.send(pdu, target);
    }

    public void getNext(PDU pdu, Target target, Object userHandle, ResponseListener listener) throws IOException {
        pdu.setType(-95);
        this.send(pdu, target, userHandle, listener);
    }

    public ResponseEvent getBulk(PDU pdu, Target target) throws IOException {
        pdu.setType(-91);
        return this.send(pdu, target);
    }

    public void getBulk(PDU pdu, Target target, Object userHandle, ResponseListener listener) throws IOException {
        pdu.setType(-91);
        this.send(pdu, target, userHandle, listener);
    }

    public ResponseEvent inform(PDU pdu, Target target) throws IOException {
        pdu.setType(-90);
        return this.send(pdu, target);
    }

    public void inform(PDU pdu, Target target, Object userHandle, ResponseListener listener) throws IOException {
        pdu.setType(-90);
        this.send(pdu, target, userHandle, listener);
    }

    public void trap(PDUv1 pdu, Target target) throws IOException {
        if (target.getVersion() != 0) {
            throw new IllegalArgumentException("SNMPv1 trap PDU must be used with SNMPv1");
        }
        pdu.setType(-92);
        this.send(pdu, target);
    }

    public void notify(PDU pdu, Target target) throws IOException {
        if (target.getVersion() == 0) {
            throw new IllegalArgumentException("Notifications PDUs cannot be used with SNMPv1");
        }
        pdu.setType(-89);
        this.send(pdu, target);
    }

    public ResponseEvent set(PDU pdu, Target target) throws IOException {
        pdu.setType(-93);
        return this.send(pdu, target);
    }

    public void set(PDU pdu, Target target, Object userHandle, ResponseListener listener) throws IOException {
        pdu.setType(-93);
        this.send(pdu, target, userHandle, listener);
    }

    @Override
    public ResponseEvent send(PDU pdu, Target target) throws IOException {
        return this.send(pdu, target, null);
    }

    @Override
    public ResponseEvent send(PDU pdu, Target target, TransportMapping transport) throws IOException {
        return this.send(pdu, target, transport, 2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResponseEvent send(PDU pdu, Target target, TransportMapping transport, int maxRequestStatus) throws IOException {
        if (!pdu.isConfirmedPdu()) {
            this.sendMessage(pdu, target, transport, null);
            return null;
        }
        if (this.timer == null) {
            this.createPendingTimer();
        }
        SyncResponseListener syncResponse = new SyncResponseListener();
        PendingRequest retryRequest = null;
        SyncResponseListener syncResponseListener = syncResponse;
        synchronized (syncResponseListener) {
            PduHandle handle = null;
            PendingRequest request = new PendingRequest(syncResponse, target, pdu, target, transport);
            request.maxRequestStatus = maxRequestStatus;
            handle = this.sendMessage(request.pdu, target, transport, request);
            long totalTimeout = this.timeoutModel.getRequestTimeout(target.getRetries(), target.getTimeout());
            long stopTime = System.nanoTime() + totalTimeout * 1000L;
            try {
                while (syncResponse.getResponse() == null && System.nanoTime() < stopTime) {
                    syncResponse.wait(totalTimeout);
                }
                retryRequest = this.pendingRequests.remove(handle);
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("Removed pending request with handle: " + handle)));
                }
                request.setFinished();
                request.cancel();
            }
            catch (InterruptedException iex) {
                logger.warn(iex);
                request.setFinished();
                request.cancel();
                retryRequest = this.pendingRequests.remove(handle);
                if (retryRequest != null) {
                    retryRequest.setFinished();
                    retryRequest.cancel();
                }
                Thread.currentThread().interrupt();
            }
            finally {
                if (!request.finished && (retryRequest = this.pendingRequests.remove(handle)) != null) {
                    retryRequest.setFinished();
                    retryRequest.cancel();
                }
            }
        }
        if (retryRequest != null) {
            retryRequest.setFinished();
            retryRequest.cancel();
        }
        if (syncResponse.getResponse() == null) {
            syncResponse.response = new ResponseEvent(this, null, pdu, null, null);
        }
        return syncResponse.response;
    }

    private synchronized void createPendingTimer() {
        if (this.timer == null) {
            this.timer = SNMP4JSettings.getTimerFactory().createTimer();
        }
    }

    @Override
    public void send(PDU pdu, Target target, Object userHandle, ResponseListener listener) throws IOException {
        this.send(pdu, target, null, userHandle, listener);
    }

    @Override
    public void send(PDU pdu, Target target, TransportMapping transport, Object userHandle, ResponseListener listener) throws IOException {
        if (!pdu.isConfirmedPdu()) {
            this.sendMessage(pdu, target, transport, null);
            return;
        }
        if (this.timer == null) {
            this.createPendingTimer();
        }
        AsyncPendingRequest request = new AsyncPendingRequest(listener, userHandle, pdu, target, transport);
        this.sendMessage(request.pdu, target, transport, request);
    }

    protected PduHandle sendMessage(PDU pdu, Target target, TransportMapping transport, PduHandleCallback<PDU> pduHandleCallback) throws IOException {
        TransportMapping tm = transport;
        if (tm == null) {
            tm = this.lookupTransportMapping(target);
        }
        PduHandle handle = this.messageDispatcher.sendPdu(tm, target, pdu, true, pduHandleCallback);
        return handle;
    }

    protected TransportMapping lookupTransportMapping(Target target) {
        List<TransportMapping<? extends Address>> preferredTransports = target.getPreferredTransports();
        if (preferredTransports != null) {
            for (TransportMapping<? extends Address> tm : preferredTransports) {
                if (!tm.getSupportedAddressClass().isInstance(target.getAddress())) continue;
                return tm;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel(PDU request, ResponseListener listener) {
        PendingRequest pendingRequest;
        AsyncRequestKey key = new AsyncRequestKey(request, listener);
        PduHandle pending = this.asyncRequests.remove(key);
        if (logger.isDebugEnabled()) {
            logger.debug((Serializable)((Object)("Cancelling pending request with handle " + pending)));
        }
        if (pending != null && (pendingRequest = this.pendingRequests.remove(pending)) != null) {
            PendingRequest pendingRequest2 = pendingRequest;
            synchronized (pendingRequest2) {
                pendingRequest.setFinished();
                pendingRequest.cancel();
            }
        }
    }

    public void setLocalEngine(byte[] engineID, int engineBoots, int engineTime) {
        MPv3 mpv3 = this.getMPv3();
        mpv3.setLocalEngineID(engineID);
        USM usm = (USM)mpv3.getSecurityModel(3);
        usm.setLocalEngine(new OctetString(engineID), engineBoots, engineTime);
    }

    public byte[] getLocalEngineID() {
        return this.getMPv3().getLocalEngineID();
    }

    private MPv3 getMPv3() {
        MPv3 mpv3 = (MPv3)this.getMessageProcessingModel(3);
        if (mpv3 == null) {
            throw new NoSuchElementException("MPv3 not available");
        }
        return mpv3;
    }

    public byte[] discoverAuthoritativeEngineID(Address address, long timeout) {
        USM usm;
        MPv3 mpv3 = this.getMPv3();
        OctetString engineID = mpv3.removeEngineID(address);
        if (engineID != null && (usm = this.getUSM()) != null) {
            usm.removeEngineTime(engineID);
        }
        ScopedPDU scopedPDU = new ScopedPDU();
        scopedPDU.setType(-96);
        UserTarget target = new UserTarget();
        target.setTimeout(timeout);
        target.setAddress(address);
        target.setSecurityLevel(1);
        try {
            this.send((PDU)scopedPDU, (Target)target, null, 0);
            OctetString authoritativeEngineID = mpv3.getEngineID(address);
            if (authoritativeEngineID == null) {
                return null;
            }
            return new OctetString(authoritativeEngineID.getValue()).getValue();
        }
        catch (IOException ex) {
            logger.error((Serializable)((Object)("IO error while trying to discover authoritative engine ID: " + ex)));
            return null;
        }
    }

    public USM getUSM() {
        MPv3 mp = (MPv3)this.getMessageProcessingModel(3);
        if (mp != null) {
            return (USM)mp.getSecurityModel(3);
        }
        return null;
    }

    public MessageProcessingModel getMessageProcessingModel(int messageProcessingModel) {
        return this.messageDispatcher.getMessageProcessingModel(messageProcessingModel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processPdu(CommandResponderEvent event) {
        PduHandle handle = event.getPduHandle();
        PDU pdu = event.getPDU();
        if (pdu.getType() == -88) {
            event.setProcessed(true);
            this.reportHandler.processReport(handle, event);
        } else if (pdu.getType() == -94) {
            ResponseListener l;
            PendingRequest request;
            event.setProcessed(true);
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Looking up pending request with handle " + handle)));
            }
            Map<PduHandle, PendingRequest> map = this.pendingRequests;
            synchronized (map) {
                request = this.pendingRequests.get(handle);
                if (request != null) {
                    request.responseReceived();
                }
            }
            if (request == null) {
                if (logger.isWarnEnabled()) {
                    logger.warn((Serializable)((Object)("Received response that cannot be matched to any outstanding request, address=" + event.getPeerAddress() + ", requestID=" + pdu.getRequestID())));
                }
            } else if (!this.resendRequest(request, pdu) && (l = request.listener) != null) {
                l.onResponse(new ResponseEvent(this, event.getPeerAddress(), request.pdu, pdu, request.userObject));
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug((Serializable)((Object)("Fire process PDU event: " + event.toString())));
            }
            this.fireProcessPdu(event);
        }
    }

    public boolean isContextEngineIdDiscoveryDisabled() {
        return this.contextEngineIdDiscoveryDisabled;
    }

    public void setContextEngineIdDiscoveryDisabled(boolean contextEngineIdDiscoveryDisabled) {
        this.contextEngineIdDiscoveryDisabled = contextEngineIdDiscoveryDisabled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean resendRequest(PendingRequest request, PDU response) {
        if (request.useNextPDU()) {
            request.responseReceived = false;
            Map<PduHandle, PendingRequest> map = this.pendingRequests;
            synchronized (map) {
                this.pendingRequests.remove(request.key);
                request.key = null;
                this.handleInternalResponse(response, request.pdu, request.target.getAddress());
                try {
                    this.sendMessage(request.pdu, request.target, request.transport, request);
                }
                catch (IOException e) {
                    logger.error("IOException while resending request after RFC 5343 context engine ID discovery: " + e.getMessage(), e);
                }
            }
            return true;
        }
        return false;
    }

    protected void handleInternalResponse(PDU response, PDU pdu, Address target) {
        Variable contextEngineID = response.getVariable(SnmpConstants.snmpEngineID);
        if (contextEngineID instanceof OctetString && pdu instanceof ScopedPDU) {
            ((ScopedPDU)pdu).setContextEngineID((OctetString)contextEngineID);
            if (logger.isInfoEnabled()) {
                logger.info("Discovered contextEngineID '" + contextEngineID + "' by RFC 5343 for " + target);
            }
        }
    }

    public synchronized void removeCommandResponder(CommandResponder listener) {
        if (this.commandResponderListeners != null && this.commandResponderListeners.contains(listener)) {
            ArrayList<CommandResponder> v = new ArrayList<CommandResponder>(this.commandResponderListeners);
            v.remove(listener);
            this.commandResponderListeners = v;
        }
    }

    public synchronized void addCommandResponder(CommandResponder listener) {
        ArrayList<CommandResponder> v;
        ArrayList<CommandResponder> arrayList = v = this.commandResponderListeners == null ? new ArrayList<CommandResponder>(2) : new ArrayList<CommandResponder>(this.commandResponderListeners);
        if (!v.contains(listener)) {
            v.add(listener);
            this.commandResponderListeners = v;
        }
    }

    protected void fireProcessPdu(CommandResponderEvent event) {
        if (this.commandResponderListeners != null) {
            List<CommandResponder> listeners = this.commandResponderListeners;
            for (CommandResponder listener : listeners) {
                listener.processPdu(event);
                if (!event.isProcessed()) continue;
                return;
            }
        }
    }

    public TimeoutModel getTimeoutModel() {
        return this.timeoutModel;
    }

    public ReportHandler getReportHandler() {
        return this.reportHandler;
    }

    public void setTimeoutModel(TimeoutModel timeoutModel) {
        if (timeoutModel == null) {
            throw new NullPointerException("Timeout model cannot be null");
        }
        this.timeoutModel = timeoutModel;
    }

    public void setReportHandler(ReportHandler reportHandler) {
        if (reportHandler == null) {
            throw new IllegalArgumentException("ReportHandler must not be null");
        }
        this.reportHandler = reportHandler;
    }

    private boolean isEmptyContextEngineID(PDU pdu) {
        if (pdu instanceof ScopedPDU) {
            ScopedPDU scopedPDU = (ScopedPDU)pdu;
            return scopedPDU.getContextEngineID() == null || scopedPDU.getContextEngineID().length() == 0;
        }
        return false;
    }

    class NotificationDispatcher
    implements CommandResponder {
        private Hashtable<Address, TransportMapping> notificationListeners = new Hashtable(10);
        private Hashtable<TransportMapping, CommandResponder> notificationTransports = new Hashtable(10);

        protected NotificationDispatcher() {
        }

        public synchronized void addNotificationListener(Address listenAddress, TransportMapping transport, CommandResponder listener) {
            this.notificationListeners.put(listenAddress, transport);
            this.notificationTransports.put(transport, listener);
        }

        public synchronized boolean removeNotificationListener(Address listenAddress) {
            block3: {
                TransportMapping tm = this.notificationListeners.remove(listenAddress);
                if (tm == null) {
                    return false;
                }
                tm.removeTransportListener(Snmp.this.messageDispatcher);
                this.notificationTransports.remove(tm);
                try {
                    tm.close();
                }
                catch (IOException ex) {
                    logger.error(ex);
                    if (!logger.isDebugEnabled()) break block3;
                    ex.printStackTrace();
                }
            }
            return true;
        }

        public synchronized void closeAll() {
            this.notificationTransports.clear();
            for (TransportMapping tm : this.notificationListeners.values()) {
                try {
                    tm.close();
                }
                catch (IOException ex) {
                    logger.error(ex);
                    if (!logger.isDebugEnabled()) continue;
                    ex.printStackTrace();
                }
            }
            this.notificationListeners.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processPdu(CommandResponderEvent event) {
            CommandResponder listener;
            block7: {
                NotificationDispatcher notificationDispatcher = this;
                synchronized (notificationDispatcher) {
                    listener = this.notificationTransports.get(event.getTransportMapping());
                }
                if (event.getPDU() != null && event.getPDU().getType() == -90) {
                    try {
                        this.sendInformResponse(event);
                    }
                    catch (MessageException mex) {
                        if (!logger.isWarnEnabled()) break block7;
                        logger.warn((Serializable)((Object)("Failed to send response on INFORM PDU event (" + event + "): " + mex.getMessage())));
                    }
                }
            }
            if (listener != null) {
                listener.processPdu(event);
            }
        }

        protected void sendInformResponse(CommandResponderEvent event) throws MessageException {
            PDU responsePDU = (PDU)event.getPDU().clone();
            responsePDU.setType(-94);
            responsePDU.setErrorStatus(0);
            responsePDU.setErrorIndex(0);
            Snmp.this.messageDispatcher.returnResponsePdu(event.getMessageProcessingModel(), event.getSecurityModel(), event.getSecurityName(), event.getSecurityLevel(), responsePDU, event.getMaxSizeResponsePDU(), event.getStateReference(), new StatusInformation());
        }
    }

    static class SyncResponseListener
    implements ResponseListener {
        private ResponseEvent response = null;

        SyncResponseListener() {
        }

        @Override
        public synchronized void onResponse(ResponseEvent event) {
            this.response = event;
            this.notify();
        }

        public ResponseEvent getResponse() {
            return this.response;
        }
    }

    static class AsyncRequestKey {
        private PDU request;
        private ResponseListener listener;

        public AsyncRequestKey(PDU request, ResponseListener listener) {
            this.request = request;
            this.listener = listener;
        }

        public boolean equals(Object obj) {
            if (obj instanceof AsyncRequestKey) {
                AsyncRequestKey other = (AsyncRequestKey)obj;
                return this.request.equals(other.request) && this.listener.equals(other.listener);
            }
            return false;
        }

        public int hashCode() {
            return this.request.hashCode();
        }
    }

    class AsyncPendingRequest
    extends PendingRequest {
        public AsyncPendingRequest(ResponseListener listener, Object userObject, PDU pdu, Target target, TransportMapping transport) {
            super(listener, userObject, pdu, target, transport);
        }

        @Override
        protected void registerRequest(PduHandle handle) {
            AsyncRequestKey key = new AsyncRequestKey(this.pdu, this.listener);
            Snmp.this.asyncRequests.put(key, handle);
        }
    }

    class PendingRequest
    extends TimerTask
    implements PduHandleCallback<PDU>,
    Cloneable {
        private PduHandle key;
        protected int retryCount;
        protected ResponseListener listener;
        protected Object userObject;
        protected PDU pdu;
        protected Target target;
        protected TransportMapping transport;
        private int requestStatus = 0;
        private int maxRequestStatus = 2;
        private volatile boolean finished = false;
        private volatile boolean responseReceived = false;
        private volatile boolean pendingRetry = false;
        private volatile boolean cancelled = false;
        private PDU nextPDU;

        public PendingRequest(ResponseListener listener, Object userObject, PDU pdu, Target target, TransportMapping transport) {
            this.userObject = userObject;
            this.listener = listener;
            this.retryCount = target.getRetries();
            this.pdu = pdu;
            this.target = (Target)target.clone();
            this.transport = transport;
            if (Snmp.this.isEmptyContextEngineID(pdu)) {
                OctetString contextEngineID = (OctetString)Snmp.this.contextEngineIDs.get(target.getAddress());
                if (contextEngineID != null) {
                    ((ScopedPDU)pdu).setContextEngineID(contextEngineID);
                } else if (!Snmp.this.contextEngineIdDiscoveryDisabled) {
                    this.discoverContextEngineID();
                }
            }
        }

        private PendingRequest(PendingRequest other) {
            this.userObject = other.userObject;
            this.listener = other.listener;
            this.retryCount = other.retryCount - 1;
            this.pdu = other.pdu;
            this.target = other.target;
            this.requestStatus = other.requestStatus;
            this.responseReceived = other.responseReceived;
            this.transport = other.transport;
            this.nextPDU = other.nextPDU;
        }

        private void discoverContextEngineID() {
            SecureTarget st;
            MPv3 mpv3;
            SecurityModel sm;
            MessageProcessingModel mp = Snmp.this.messageDispatcher.getMessageProcessingModel(this.target.getVersion());
            if (mp instanceof MPv3 && this.target instanceof SecureTarget && (sm = (mpv3 = (MPv3)mp).getSecurityModel((st = (SecureTarget)this.target).getSecurityModel())) != null && !sm.supportsEngineIdDiscovery()) {
                if (logger.isInfoEnabled()) {
                    logger.info("Performing RFC 5343 contextEngineID discovery on " + this.target);
                }
                ScopedPDU discoverPDU = new ScopedPDU();
                discoverPDU.setContextEngineID(MPv3.LOCAL_ENGINE_ID);
                discoverPDU.add(new VariableBinding(SnmpConstants.snmpEngineID));
                this.insertFirstPDU(discoverPDU);
            }
        }

        protected void registerRequest(PduHandle handle) {
        }

        public boolean useNextPDU() {
            if (this.nextPDU != null) {
                this.pdu = this.nextPDU;
                this.nextPDU = null;
                return true;
            }
            return false;
        }

        public void insertFirstPDU(PDU firstPDU) {
            this.nextPDU = this.pdu;
            this.pdu = firstPDU;
        }

        public void responseReceived() {
            this.responseReceived = true;
        }

        public PDU getNextPDU() {
            return this.nextPDU;
        }

        public void setNextPDU(PDU nextPDU) {
            this.nextPDU = nextPDU;
        }

        public Object clone() throws CloneNotSupportedException {
            return super.clone();
        }

        @Override
        public synchronized void pduHandleAssigned(PduHandle handle, PDU pdu) {
            if (this.key == null) {
                this.key = handle;
                Target t = this.target;
                if (t != null && !this.cancelled) {
                    Snmp.this.pendingRequests.put(handle, this);
                    this.registerRequest(handle);
                    if (logger.isDebugEnabled()) {
                        logger.debug((Serializable)((Object)("Running pending " + (this.listener instanceof SyncResponseListener ? "sync" : "async") + " request with handle " + handle + " and retry count left " + this.retryCount)));
                    }
                    long delay = Snmp.this.timeoutModel.getRetryTimeout(t.getRetries() - this.retryCount, t.getRetries(), t.getTimeout());
                    if (!(this.finished || this.responseReceived || this.cancelled)) {
                        try {
                            Snmp.this.timer.schedule(this, delay);
                        }
                        catch (IllegalStateException isex) {}
                    } else {
                        Snmp.this.pendingRequests.remove(handle);
                    }
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public synchronized void run() {
            PduHandle m_key = this.key;
            PDU m_pdu = this.pdu;
            Target m_target = this.target;
            TransportMapping m_transport = this.transport;
            ResponseListener m_listener = this.listener;
            Object m_userObject = this.userObject;
            if (m_key == null || m_pdu == null || m_target == null || m_listener == null) {
                if (logger.isDebugEnabled()) {
                    logger.debug((Serializable)((Object)("PendingRequest canceled key=" + m_key + ", pdu=" + m_pdu + ", target=" + m_target + ", transport=" + m_transport + ", listener=" + m_listener)));
                }
                return;
            }
            try {
                Map map = Snmp.this.pendingRequests;
                synchronized (map) {
                    this.pendingRetry = !this.finished && this.retryCount > 0 && !this.responseReceived;
                }
                if (this.pendingRetry) {
                    try {
                        PendingRequest nextRetry = new PendingRequest(this);
                        Snmp.this.sendMessage(m_pdu, m_target, m_transport, nextRetry);
                        this.pendingRetry = false;
                    }
                    catch (IOException ex) {
                        ResponseListener l = this.listener;
                        this.finished = true;
                        logger.error((Serializable)((Object)("Failed to send SNMP message to " + m_target + ": " + ex.getMessage())));
                        Snmp.this.messageDispatcher.releaseStateReference(m_target.getVersion(), m_key);
                        if (l != null) {
                            this.listener.onResponse(new ResponseEvent(Snmp.this, null, m_pdu, null, m_userObject, ex));
                        }
                    }
                } else if (!this.finished) {
                    this.finished = true;
                    Snmp.this.pendingRequests.remove(m_key);
                    if (!this.cancelled) {
                        if (logger.isDebugEnabled()) {
                            logger.debug((Serializable)((Object)("Request timed out: " + m_key.getTransactionID())));
                        }
                        Snmp.this.messageDispatcher.releaseStateReference(m_target.getVersion(), m_key);
                        m_listener.onResponse(new ResponseEvent(Snmp.this, null, m_pdu, null, m_userObject));
                    }
                } else {
                    Snmp.this.pendingRequests.remove(m_key);
                }
            }
            catch (RuntimeException ex) {
                logger.error("Failed to process pending request " + m_key + " because " + ex.getMessage(), ex);
                throw ex;
            }
            catch (Error er) {
                logger.fatal("Failed to process pending request " + m_key + " because " + er.getMessage(), er);
                throw er;
            }
        }

        public boolean setFinished() {
            boolean currentState = this.finished;
            this.finished = true;
            return currentState;
        }

        public void setMaxRequestStatus(int maxRequestStatus) {
            this.maxRequestStatus = maxRequestStatus;
        }

        public int getMaxRequestStatus() {
            return this.maxRequestStatus;
        }

        public boolean isResponseReceived() {
            return this.responseReceived;
        }

        @Override
        public boolean cancel() {
            this.cancelled = true;
            boolean result = super.cancel();
            if (!this.pendingRetry) {
                this.key = null;
                this.pdu = null;
                this.target = null;
                this.transport = null;
                this.listener = null;
                this.userObject = null;
            }
            return result;
        }
    }

    class ReportProcessor
    implements ReportHandler {
        ReportProcessor() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void processReport(PduHandle handle, CommandResponderEvent e) {
            boolean intime;
            PDU pdu = e.getPDU();
            logger.debug((Serializable)((Object)("Searching pending request with handle" + handle)));
            PendingRequest request = (PendingRequest)Snmp.this.pendingRequests.get(handle);
            VariableBinding vb = this.checkReport(e, pdu, request);
            if (vb == null) {
                return;
            }
            OID firstOID = vb.getOid();
            boolean resend = false;
            if (request.requestStatus < request.maxRequestStatus) {
                switch (request.requestStatus) {
                    case 0: {
                        if (SnmpConstants.usmStatsUnknownEngineIDs.equals(firstOID)) {
                            resend = true;
                            break;
                        }
                        if (!SnmpConstants.usmStatsNotInTimeWindows.equals(firstOID)) break;
                        request.requestStatus++;
                        resend = true;
                        break;
                    }
                    case 1: {
                        if (!SnmpConstants.usmStatsNotInTimeWindows.equals(firstOID)) break;
                        resend = true;
                    }
                }
            }
            if (resend) {
                logger.debug((Serializable)((Object)"Send new request after report."));
                request.requestStatus++;
                try {
                    PduHandle resentHandle = Snmp.this.sendMessage(request.pdu, request.target, e.getTransportMapping(), null);
                    request.key = resentHandle;
                }
                catch (IOException iox) {
                    logger.error((Serializable)((Object)("Failed to send message to " + request.target + ": " + iox.getMessage())));
                    return;
                }
            }
            ResponseListener reqListener = request.listener;
            PDU reqPDU = request.pdu;
            Object reqUserObject = request.userObject;
            PendingRequest pendingRequest = request;
            synchronized (pendingRequest) {
                intime = request.cancel();
            }
            Snmp.this.pendingRequests.remove(handle);
            if (intime && reqListener != null) {
                reqListener.onResponse(new ResponseEvent(this, e.getPeerAddress(), reqPDU, pdu, reqUserObject));
            } else if (logger.isInfoEnabled()) {
                logger.info("Received late report from " + e.getPeerAddress() + " with request ID " + pdu.getRequestID());
            }
        }

        protected VariableBinding checkReport(CommandResponderEvent e, PDU pdu, PendingRequest request) {
            if (request == null) {
                logger.warn((Serializable)((Object)("Unmatched report PDU received from " + e.getPeerAddress())));
                return null;
            }
            if (pdu.size() == 0) {
                logger.error((Serializable)((Object)("Illegal report PDU received from " + e.getPeerAddress() + " missing report variable binding")));
                return null;
            }
            VariableBinding vb = pdu.get(0);
            if (vb == null) {
                logger.error((Serializable)((Object)("Received illegal REPORT PDU from " + e.getPeerAddress())));
                return null;
            }
            if (e.getSecurityModel() != request.target.getSecurityModel()) {
                logger.warn((Serializable)((Object)("RFC3412 \u00a77.2.11.b: Received REPORT PDU with different security model than cached one: " + e)));
                return null;
            }
            if (e.getSecurityLevel() == 1 && SNMP4JSettings.getReportSecurityLevelStrategy() != SNMP4JSettings.ReportSecurityLevelStrategy.noAuthNoPrivIfNeeded && e.getSecurityLevel() != request.target.getSecurityLevel() && !SnmpConstants.usmStatsUnknownUserNames.equals(vb.getOid()) && !SnmpConstants.usmStatsUnknownEngineIDs.equals(vb.getOid())) {
                logger.warn((Serializable)((Object)("RFC3412 \u00a77.2.11.b:Received REPORT PDU with security level noAuthNoPriv from '" + e + "'. " + "Ignoring it, because report strategy is set to " + (Object)((Object)SNMP4JSettings.getReportSecurityLevelStrategy()))));
                return null;
            }
            return vb;
        }
    }

    public static interface ReportHandler {
        public void processReport(PduHandle var1, CommandResponderEvent var2);
    }
}

