/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.soap;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBIntrospector;
import javax.xml.namespace.QName;
import javax.xml.ws.WebFault;
import org.apache.camel.Exchange;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.dataformat.soap.SoapDataFormatAdapter;
import org.apache.camel.dataformat.soap.SoapJaxbDataFormat;
import org.xmlsoap.schemas.soap.envelope.Body;
import org.xmlsoap.schemas.soap.envelope.Detail;
import org.xmlsoap.schemas.soap.envelope.Envelope;
import org.xmlsoap.schemas.soap.envelope.Fault;
import org.xmlsoap.schemas.soap.envelope.Header;
import org.xmlsoap.schemas.soap.envelope.ObjectFactory;

public class Soap11DataFormatAdapter
implements SoapDataFormatAdapter {
    private static final String SOAP_PACKAGE_NAME = Envelope.class.getPackage().getName();
    private static final QName FAULT_CODE_SERVER = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Receiver");
    private final SoapJaxbDataFormat dataFormat;
    private final ObjectFactory objectFactory;

    public Soap11DataFormatAdapter(SoapJaxbDataFormat dataFormat) {
        this.dataFormat = dataFormat;
        this.objectFactory = new ObjectFactory();
    }

    @Override
    public SoapJaxbDataFormat getDataFormat() {
        return this.dataFormat;
    }

    @Override
    public Object doMarshal(Exchange exchange, Object inputObject, OutputStream stream, String soapAction) throws IOException {
        List<Object> bodyContent;
        Body body = this.objectFactory.createBody();
        Header header = this.objectFactory.createHeader();
        Throwable exception = (Throwable)exchange.getProperty("CamelExceptionCaught", Throwable.class);
        if (exception == null) {
            exception = (Throwable)exchange.getIn().getHeader("CamelExceptionCaught", Throwable.class);
        }
        ArrayList headerContent = new ArrayList();
        if (exception != null) {
            bodyContent = new ArrayList<JAXBElement<Fault>>();
            bodyContent.add(this.createFaultFromException(exception));
        } else {
            bodyContent = this.getDataFormat().createContentFromObject(inputObject, soapAction, headerContent);
        }
        for (JAXBElement jAXBElement : bodyContent) {
            body.getAny().add(jAXBElement);
        }
        for (JAXBElement jAXBElement : headerContent) {
            header.getAny().add(jAXBElement);
        }
        Envelope envelope = new Envelope();
        if (headerContent.size() > 0) {
            envelope.setHeader(header);
        }
        envelope.setBody(body);
        JAXBElement<Envelope> jAXBElement = this.objectFactory.createEnvelope(envelope);
        return jAXBElement;
    }

    private JAXBElement<Fault> createFaultFromException(Throwable exception) {
        Object faultObject;
        WebFault webFault = exception.getClass().getAnnotation(WebFault.class);
        if (webFault == null || webFault.targetNamespace() == null) {
            throw new RuntimeException("The exception " + exception.getClass().getName() + " needs to have an WebFault annotation with name and targetNamespace", exception);
        }
        QName name = new QName(webFault.targetNamespace(), webFault.name());
        try {
            Method method = exception.getClass().getMethod("getFaultInfo", new Class[0]);
            faultObject = method.invoke((Object)exception, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeCamelException("Exception while trying to get fault details", (Throwable)e);
        }
        Fault fault = new Fault();
        fault.setFaultcode(FAULT_CODE_SERVER);
        fault.setFaultstring(exception.getMessage());
        Detail detailEl = new ObjectFactory().createDetail();
        JAXBElement<Object> faultDetailContent = new JAXBElement<Object>(name, faultObject.getClass(), faultObject);
        detailEl.getAny().add(faultDetailContent);
        fault.setDetail(detailEl);
        return new ObjectFactory().createFault(fault);
    }

    @Override
    public Object doUnmarshal(Exchange exchange, InputStream stream, Object rootObject) throws IOException {
        List<Object> anyElement;
        List<Object> anyHeaderElements;
        if (rootObject.getClass() != Envelope.class) {
            throw new RuntimeCamelException("Expected Soap Envelope but got " + rootObject.getClass());
        }
        Envelope envelope = (Envelope)rootObject;
        Header header = envelope.getHeader();
        if (header != null && null != (anyHeaderElements = envelope.getHeader().getAny()) && !this.getDataFormat().isIgnoreUnmarshalledHeaders()) {
            List<Object> returnHeaders;
            if (this.getDataFormat().isIgnoreJAXBElement()) {
                returnHeaders = new ArrayList<Object>();
                for (Object headerEl : anyHeaderElements) {
                    returnHeaders.add(JAXBIntrospector.getValue(headerEl));
                }
            } else {
                returnHeaders = anyHeaderElements;
            }
            exchange.getOut().setHeader("org.apache.camel.dataformat.soap.UNMARSHALLED_HEADER_LIST", returnHeaders);
        }
        if ((anyElement = envelope.getBody().getAny()).size() == 0) {
            return null;
        }
        Object payloadEl = anyElement.get(0);
        Object payload = JAXBIntrospector.getValue(payloadEl);
        if (payload instanceof Fault) {
            Exception exception = this.createExceptionFromFault((Fault)payload);
            exchange.setException((Throwable)exception);
            return null;
        }
        return this.getDataFormat().isIgnoreJAXBElement() ? payload : payloadEl;
    }

    private Exception createExceptionFromFault(Fault fault) {
        List<Object> detailList = fault.getDetail().getAny();
        String message = fault.getFaultstring();
        if (detailList.size() == 0) {
            return new RuntimeCamelException(message);
        }
        JAXBElement detailEl = (JAXBElement)detailList.get(0);
        Class<? extends Exception> exceptionClass = this.getDataFormat().getElementNameStrategy().findExceptionForFaultName(detailEl.getName());
        try {
            Constructor<? extends Exception> messageConstructor = exceptionClass.getConstructor(String.class);
            Object detail = JAXBIntrospector.getValue(detailEl);
            try {
                Constructor<? extends Exception> constructor = exceptionClass.getConstructor(String.class, detail.getClass());
                return constructor.newInstance(message, detail);
            }
            catch (NoSuchMethodException e) {
                return messageConstructor.newInstance(message);
            }
        }
        catch (Exception e) {
            throw new RuntimeCamelException((Throwable)e);
        }
    }

    @Override
    public String getSoapPackageName() {
        return SOAP_PACKAGE_NAME;
    }
}

