/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.dataformat.soap.name;

import java.util.HashMap;
import java.util.Map;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.dataformat.soap.name.TypeInfo;

public final class MethodInfo {
    private String name;
    private String soapAction;
    private TypeInfo[] in;
    private TypeInfo out;
    private Map<String, TypeInfo> inTypeMap;

    public MethodInfo(String name, String soapAction, TypeInfo[] in, TypeInfo out) {
        this.name = name;
        this.soapAction = soapAction;
        this.in = in;
        this.out = out;
        this.inTypeMap = new HashMap<String, TypeInfo>();
        for (TypeInfo typeInfo : in) {
            if (this.inTypeMap.containsKey(typeInfo.getTypeName()) && !typeInfo.getTypeName().equals("javax.xml.ws.Holder") && !this.inTypeMap.get(typeInfo.getTypeName()).equals(typeInfo.getElName())) {
                throw new RuntimeCamelException("Ambiguous QName mapping. The type [ " + typeInfo.getTypeName() + " ] is already mapped to a QName in this method. This is not supported.");
            }
            this.inTypeMap.put(typeInfo.getTypeName(), typeInfo);
        }
    }

    public String getName() {
        return this.name;
    }

    public String getSoapAction() {
        return this.soapAction;
    }

    public TypeInfo[] getIn() {
        return this.in;
    }

    public TypeInfo getOut() {
        return this.out;
    }

    public TypeInfo getIn(String typeName) {
        return this.inTypeMap.get(typeName);
    }
}

