/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.solr;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.camel.Endpoint;
import org.apache.camel.component.solr.SolrEndpoint;
import org.apache.camel.impl.UriEndpointComponent;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.impl.CloudSolrClient;
import org.apache.solr.client.solrj.impl.ConcurrentUpdateSolrClient;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolrComponent
extends UriEndpointComponent {
    private static final Logger LOG = LoggerFactory.getLogger(SolrComponent.class);
    private final Map<SolrEndpoint, SolrServerReference> servers = new HashMap<SolrEndpoint, SolrServerReference>();

    public SolrComponent() {
        super(SolrEndpoint.class);
    }

    protected Endpoint createEndpoint(String uri, String remaining, Map<String, Object> parameters) throws Exception {
        SolrEndpoint endpoint = new SolrEndpoint(uri, this, remaining);
        this.setProperties((Object)endpoint, parameters);
        return endpoint;
    }

    public SolrServerReference getSolrServers(SolrEndpoint endpoint) {
        return this.servers.get((Object)endpoint);
    }

    public void addSolrServers(SolrEndpoint endpoint, SolrServerReference servers) {
        this.servers.put(endpoint, servers);
    }

    protected void doShutdown() throws Exception {
        for (SolrServerReference server : this.servers.values()) {
            this.shutdownServers(server);
        }
        this.servers.clear();
    }

    void shutdownServers(SolrServerReference ref) {
        this.shutdownServers(ref, false);
    }

    private void shutdownServer(SolrClient server) throws IOException {
        if (server != null) {
            LOG.info("Shutting down solr server: {}", (Object)server);
            server.close();
        }
    }

    void shutdownServers(SolrServerReference ref, boolean remove) {
        try {
            this.shutdownServer(ref.getSolrServer());
        }
        catch (Exception e) {
            LOG.warn("Error shutting down solr server. This exception is ignored.", (Throwable)e);
        }
        try {
            this.shutdownServer(ref.getUpdateSolrServer());
        }
        catch (Exception e) {
            LOG.warn("Error shutting down streaming solr server. This exception is ignored.", (Throwable)e);
        }
        try {
            this.shutdownServer(ref.getCloudSolrServer());
        }
        catch (Exception e) {
            LOG.warn("Error shutting down streaming solr server. This exception is ignored.", (Throwable)e);
        }
        if (remove) {
            SolrEndpoint key = null;
            for (Map.Entry<SolrEndpoint, SolrServerReference> entry : this.servers.entrySet()) {
                if (entry.getValue() != ref) continue;
                key = entry.getKey();
                break;
            }
            if (key != null) {
                this.servers.remove((Object)key);
            }
        }
    }

    protected static final class SolrServerReference {
        private final AtomicInteger referenceCounter = new AtomicInteger();
        private HttpSolrClient solrServer;
        private ConcurrentUpdateSolrClient updateSolrServer;
        private CloudSolrClient cloudSolrServer;

        protected SolrServerReference() {
        }

        public HttpSolrClient getSolrServer() {
            return this.solrServer;
        }

        public void setSolrServer(HttpSolrClient solrServer) {
            this.solrServer = solrServer;
        }

        public ConcurrentUpdateSolrClient getUpdateSolrServer() {
            return this.updateSolrServer;
        }

        public void setUpdateSolrServer(ConcurrentUpdateSolrClient updateSolrServer) {
            this.updateSolrServer = updateSolrServer;
        }

        public CloudSolrClient getCloudSolrServer() {
            return this.cloudSolrServer;
        }

        public void setCloudSolrServer(CloudSolrClient cloudServer) {
            this.cloudSolrServer = cloudServer;
        }

        public int addReference() {
            return this.referenceCounter.incrementAndGet();
        }

        public int decReference() {
            return this.referenceCounter.decrementAndGet();
        }
    }
}

