/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.client.solrj.io.eval;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.commons.math3.stat.Frequency;
import org.apache.solr.client.solrj.io.Tuple;
import org.apache.solr.client.solrj.io.eval.ManyValueWorker;
import org.apache.solr.client.solrj.io.eval.RecursiveNumericEvaluator;
import org.apache.solr.client.solrj.io.stream.expr.StreamExpression;
import org.apache.solr.client.solrj.io.stream.expr.StreamFactory;

public class FrequencyTableEvaluator
extends RecursiveNumericEvaluator
implements ManyValueWorker {
    protected static final long serialVersionUID = 1L;

    public FrequencyTableEvaluator(StreamExpression expression, StreamFactory factory) throws IOException {
        super(expression, factory);
        if (this.containedEvaluators.size() < 1) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting at least one value but found %d", expression, this.containedEvaluators.size()));
        }
    }

    @Override
    public Object doWork(Object ... values) throws IOException {
        if (Arrays.stream(values).anyMatch(item -> null == item)) {
            return null;
        }
        if (values.length != 1) {
            throw new IOException(String.format(Locale.ROOT, "Invalid expression %s - expecting at least one value but found %d", this.toExpression(this.constructingFactory), this.containedEvaluators.size()));
        }
        List<Object> sourceValues = values[0] instanceof List ? (List<Object>)values[0] : Arrays.asList(values[0]);
        Frequency frequency = new Frequency();
        for (Object o : sourceValues) {
            Number number = (Number)o;
            frequency.addValue(number.longValue());
        }
        ArrayList<Tuple> histogramBins = new ArrayList<Tuple>();
        Iterator<Comparable<?>> iterator = frequency.valuesIterator();
        while (iterator.hasNext()) {
            Long value = (Long)iterator.next();
            HashMap<String, Number> map = new HashMap<String, Number>();
            map.put("value", value);
            map.put("count", frequency.getCount(value));
            map.put("cumFreq", frequency.getCumFreq(value));
            map.put("cumPct", frequency.getCumPct(value));
            map.put("pct", frequency.getPct(value));
            histogramBins.add(new Tuple(map));
        }
        return histogramBins;
    }
}

