/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.noggit.JSONUtil;

public class Replica
extends ZkNodeProps {
    private final String name;
    private final String nodeName;
    private final State state;
    private final Type type;

    public Replica(String name, Map<String, Object> propMap) {
        super(propMap);
        this.name = name;
        this.nodeName = (String)propMap.get("node_name");
        if (propMap.get("state") != null) {
            this.state = State.getState((String)propMap.get("state"));
        } else {
            this.state = State.ACTIVE;
            propMap.put("state", this.state.toString());
        }
        this.type = Type.get((String)propMap.get("type"));
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Replica replica = (Replica)o;
        return this.name.equals(replica.name);
    }

    public String getName() {
        return this.name;
    }

    public String getCoreUrl() {
        return ZkCoreNodeProps.getCoreUrl(this.getStr("base_url"), this.getStr("core"));
    }

    public String getBaseUrl() {
        return this.getStr("base_url");
    }

    public String getCoreName() {
        return this.getStr("core");
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public State getState() {
        return this.state;
    }

    public boolean isActive(Set<String> liveNodes) {
        return liveNodes.contains(this.nodeName) && this.state == State.ACTIVE;
    }

    public Type getType() {
        return this.type;
    }

    public String getProperty(String propertyName) {
        String propertyKey = !propertyName.startsWith("property.") ? "property." + propertyName : propertyName;
        String propertyValue = this.getStr(propertyKey);
        return propertyValue;
    }

    @Override
    public String toString() {
        return this.name + ':' + JSONUtil.toJSON(this.propMap, -1);
    }

    public static enum Type {
        NRT,
        TLOG,
        PULL;


        public static Type get(String name) {
            return name == null ? NRT : Type.valueOf(name);
        }
    }

    public static enum State {
        ACTIVE,
        DOWN,
        RECOVERING,
        RECOVERY_FAILED;


        public String toString() {
            return super.toString().toLowerCase(Locale.ROOT);
        }

        public static State getState(String stateStr) {
            return stateStr == null ? null : State.valueOf(stateStr.toUpperCase(Locale.ROOT));
        }
    }
}

