/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.common.cloud;

import java.io.Closeable;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.apache.solr.client.solrj.cloud.autoscaling.AutoScalingConfig;
import org.apache.solr.common.Callable;
import org.apache.solr.common.SolrException;
import org.apache.solr.common.cloud.Aliases;
import org.apache.solr.common.cloud.CloudCollectionsListener;
import org.apache.solr.common.cloud.ClusterState;
import org.apache.solr.common.cloud.CollectionPropsWatcher;
import org.apache.solr.common.cloud.CollectionStatePredicate;
import org.apache.solr.common.cloud.CollectionStateWatcher;
import org.apache.solr.common.cloud.DocCollection;
import org.apache.solr.common.cloud.LiveNodesListener;
import org.apache.solr.common.cloud.OnReconnect;
import org.apache.solr.common.cloud.Replica;
import org.apache.solr.common.cloud.Slice;
import org.apache.solr.common.cloud.SolrZkClient;
import org.apache.solr.common.cloud.ZkConfigManager;
import org.apache.solr.common.cloud.ZkCoreNodeProps;
import org.apache.solr.common.cloud.ZkNodeProps;
import org.apache.solr.common.cloud.ZooKeeperException;
import org.apache.solr.common.util.ExecutorUtil;
import org.apache.solr.common.util.Pair;
import org.apache.solr.common.util.SolrjNamedThreadFactory;
import org.apache.solr.common.util.Utils;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.data.Stat;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ZkStateReader
implements Closeable {
    public static final int STATE_UPDATE_DELAY = Integer.getInteger("solr.OverseerStateUpdateDelay", 2000);
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String BASE_URL_PROP = "base_url";
    public static final String NODE_NAME_PROP = "node_name";
    public static final String CORE_NODE_NAME_PROP = "core_node_name";
    public static final String ROLES_PROP = "roles";
    public static final String STATE_PROP = "state";
    public static final String FORCE_SET_STATE_PROP = "force_set_state";
    public static final String CORE_NAME_PROP = "core";
    public static final String COLLECTION_PROP = "collection";
    public static final String ELECTION_NODE_PROP = "election_node";
    public static final String SHARD_ID_PROP = "shard";
    public static final String REPLICA_PROP = "replica";
    public static final String SHARD_RANGE_PROP = "shard_range";
    public static final String SHARD_STATE_PROP = "shard_state";
    public static final String SHARD_PARENT_PROP = "shard_parent";
    public static final String NUM_SHARDS_PROP = "numShards";
    public static final String LEADER_PROP = "leader";
    public static final String SHARED_STORAGE_PROP = "shared_storage";
    public static final String PROPERTY_PROP = "property";
    public static final String PROPERTY_PROP_PREFIX = "property.";
    public static final String PROPERTY_VALUE_PROP = "property.value";
    public static final String MAX_AT_ONCE_PROP = "maxAtOnce";
    public static final String MAX_WAIT_SECONDS_PROP = "maxWaitSeconds";
    public static final String STATE_TIMESTAMP_PROP = "stateTimestamp";
    public static final String COLLECTIONS_ZKNODE = "/collections";
    public static final String LIVE_NODES_ZKNODE = "/live_nodes";
    public static final String ALIASES = "/aliases.json";
    public static final String CLUSTER_STATE = "/clusterstate.json";
    public static final String CLUSTER_PROPS = "/clusterprops.json";
    public static final String COLLECTION_PROPS_ZKNODE = "collectionprops.json";
    public static final String REJOIN_AT_HEAD_PROP = "rejoinAtHead";
    public static final String SOLR_SECURITY_CONF_PATH = "/security.json";
    public static final String SOLR_AUTOSCALING_CONF_PATH = "/autoscaling.json";
    public static final String SOLR_AUTOSCALING_EVENTS_PATH = "/autoscaling/events";
    public static final String SOLR_AUTOSCALING_TRIGGER_STATE_PATH = "/autoscaling/triggerState";
    public static final String SOLR_AUTOSCALING_NODE_ADDED_PATH = "/autoscaling/nodeAdded";
    public static final String SOLR_AUTOSCALING_NODE_LOST_PATH = "/autoscaling/nodeLost";
    public static final String REPLICATION_FACTOR = "replicationFactor";
    public static final String MAX_SHARDS_PER_NODE = "maxShardsPerNode";
    public static final String AUTO_ADD_REPLICAS = "autoAddReplicas";
    public static final String MAX_CORES_PER_NODE = "maxCoresPerNode";
    public static final String PULL_REPLICAS = "pullReplicas";
    public static final String NRT_REPLICAS = "nrtReplicas";
    public static final String TLOG_REPLICAS = "tlogReplicas";
    public static final String ROLES = "/roles.json";
    public static final String CONFIGS_ZKNODE = "/configs";
    public static final String CONFIGNAME_PROP = "configName";
    public static final String LEGACY_CLOUD = "legacyCloud";
    public static final String COLLECTION_DEF = "collectionDefaults";
    public static final String URL_SCHEME = "urlScheme";
    public static final String REPLICA_TYPE = "type";
    protected volatile ClusterState clusterState;
    private static final int GET_LEADER_RETRY_INTERVAL_MS = 50;
    private static final int GET_LEADER_RETRY_DEFAULT_TIMEOUT = 4000;
    public static final String LEADER_ELECT_ZKNODE = "leader_elect";
    public static final String SHARD_LEADERS_ZKNODE = "leaders";
    public static final String ELECTION_NODE = "election";
    private Map<String, ClusterState.CollectionRef> legacyCollectionStates = Collections.emptyMap();
    private int legacyClusterStateVersion = 0;
    private final ConcurrentHashMap<String, DocCollection> watchedCollectionStates = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, LazyCollectionRef> lazyCollectionStates = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, Map<String, String>> watchedCollectionProps = new ConcurrentHashMap();
    private volatile SortedSet<String> liveNodes = Collections.emptySortedSet();
    private volatile Map<String, Object> clusterProperties = Collections.emptyMap();
    private final ZkConfigManager configManager;
    private ConfigData securityData;
    private final Runnable securityNodeListener;
    private ConcurrentHashMap<String, CollectionWatch<CollectionStateWatcher>> collectionWatches = new ConcurrentHashMap();
    private ConcurrentHashMap<String, CollectionWatch<CollectionPropsWatcher>> collectionPropsWatches = new ConcurrentHashMap();
    private Set<CloudCollectionsListener> cloudCollectionsListeners = ConcurrentHashMap.newKeySet();
    private final ExecutorService notifications = ExecutorUtil.newMDCAwareCachedThreadPool("watches");
    private final ExecutorService collectionPropsNotifications = ExecutorUtil.newMDCAwareSingleThreadExecutor(new SolrjNamedThreadFactory("collectionPropsNotifications"));
    private static final long LAZY_CACHE_TIME = TimeUnit.NANOSECONDS.convert(STATE_UPDATE_DELAY, TimeUnit.MILLISECONDS);
    private Set<LiveNodesListener> liveNodesListeners = ConcurrentHashMap.newKeySet();
    public static final Set<String> KNOWN_CLUSTER_PROPS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("legacyCloud", "urlScheme", "autoAddReplicas", "location", "maxCoresPerNode")));
    private final SolrZkClient zkClient;
    private final boolean closeClient;
    private volatile boolean closed = false;
    private final Object refreshCollectionListLock = new Object();
    private final Object refreshCollectionsSetLock = new Object();
    private final AtomicReference<Set<String>> lastFetchedCollectionSet = new AtomicReference();
    private final Object refreshLiveNodesLock = new Object();
    private final AtomicReference<SortedSet<String>> lastFetchedLiveNodes = new AtomicReference();
    private final Watcher clusterPropertiesWatcher = event -> {
        if (Watcher.Event.EventType.None.equals((Object)event.getType())) {
            return;
        }
        this.loadClusterProperties();
    };
    public final AliasesManager aliasesManager = new AliasesManager();

    public AutoScalingConfig getAutoScalingConfig() throws KeeperException, InterruptedException {
        return this.getAutoScalingConfig(null);
    }

    public AutoScalingConfig getAutoScalingConfig(Watcher watcher) throws KeeperException, InterruptedException {
        Stat stat = new Stat();
        Map<String, Object> map = new HashMap<String, Object>();
        try {
            byte[] bytes = this.zkClient.getData(SOLR_AUTOSCALING_CONF_PATH, watcher, stat, true);
            if (bytes != null && bytes.length > 0) {
                map = (Map)Utils.fromJSON(bytes);
            }
        }
        catch (KeeperException.NoNodeException noNodeException) {
            // empty catch block
        }
        map.put("zkVersion", stat.getVersion());
        return new AutoScalingConfig(map);
    }

    public String readConfigName(String collection) {
        String configName = null;
        String path = "/collections/" + collection;
        log.debug("Loading collection config from: [{}]", (Object)path);
        try {
            String configPath;
            byte[] data = this.zkClient.getData(path, null, null, true);
            if (data != null) {
                ZkNodeProps props = ZkNodeProps.load(data);
                configName = props.getStr(CONFIGNAME_PROP);
            }
            if (configName != null) {
                configPath = "/configs/" + configName;
                if (!this.zkClient.exists(configPath, true).booleanValue()) {
                    log.error("Specified config=[{}] does not exist in ZooKeeper at location=[{}]", (Object)configName, (Object)configPath);
                    throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "Specified config does not exist in ZooKeeper: " + configName);
                }
            } else {
                throw new ZooKeeperException(SolrException.ErrorCode.INVALID_STATE, "No config data found at path: " + path);
            }
            log.debug("path=[{}] [{}]=[{}] specified config exists in ZooKeeper", new Object[]{configPath, CONFIGNAME_PROP, configName});
        }
        catch (InterruptedException | KeeperException e) {
            SolrZkClient.checkInterrupted(e);
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error loading config name for collection " + collection, (Throwable)e);
        }
        return configName;
    }

    public ZkStateReader(SolrZkClient zkClient) {
        this(zkClient, null);
    }

    public ZkStateReader(SolrZkClient zkClient, Runnable securityNodeListener) {
        this.zkClient = zkClient;
        this.configManager = new ZkConfigManager(zkClient);
        this.closeClient = false;
        this.securityNodeListener = securityNodeListener;
    }

    public ZkStateReader(String zkServerAddress, int zkClientTimeout, int zkClientConnectTimeout) {
        this.zkClient = new SolrZkClient(zkServerAddress, zkClientTimeout, zkClientConnectTimeout, new OnReconnect(){

            @Override
            public void command() {
                try {
                    ZkStateReader.this.createClusterStateWatchersAndUpdate();
                }
                catch (KeeperException e) {
                    log.error("A ZK error has occurred", (Throwable)e);
                    throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "A ZK error has occurred", (Throwable)e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    log.error("Interrupted", (Throwable)e);
                    throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "Interrupted", (Throwable)e);
                }
            }
        });
        this.configManager = new ZkConfigManager(this.zkClient);
        this.closeClient = true;
        this.securityNodeListener = null;
    }

    public ZkConfigManager getConfigManager() {
        return this.configManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forciblyRefreshAllClusterStateSlow() throws KeeperException, InterruptedException {
        Object object = this.getUpdateLock();
        synchronized (object) {
            if (this.clusterState == null) {
                this.createClusterStateWatchersAndUpdate();
                return;
            }
            this.refreshCollectionList(null);
            this.refreshLiveNodes(null);
            this.refreshLegacyClusterState(null);
            ArrayList safeCopy = new ArrayList(this.watchedCollectionStates.keySet());
            HashSet<String> updatedCollections = new HashSet<String>();
            for (String coll : safeCopy) {
                DocCollection newState;
                if (!this.updateWatchedCollection(coll, newState = this.fetchCollectionState(coll, null))) continue;
                updatedCollections.add(coll);
            }
            this.constructState(updatedCollections);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void forceUpdateCollection(String collection) throws KeeperException, InterruptedException {
        Object object = this.getUpdateLock();
        synchronized (object) {
            if (this.clusterState == null) {
                log.warn("ClusterState watchers have not been initialized");
                return;
            }
            ClusterState.CollectionRef ref = this.clusterState.getCollectionRef(collection);
            if (ref == null || this.legacyCollectionStates.containsKey(collection)) {
                LazyCollectionRef tryLazyCollection;
                log.debug("Checking legacy cluster state for collection {}", (Object)collection);
                this.refreshLegacyClusterState(null);
                if (!this.legacyCollectionStates.containsKey(collection) && (tryLazyCollection = new LazyCollectionRef(collection)).get() != null) {
                    log.debug("Adding lazily-loaded reference for collection {}", (Object)collection);
                    this.lazyCollectionStates.putIfAbsent(collection, tryLazyCollection);
                    this.constructState(Collections.singleton(collection));
                }
            } else if (ref.isLazilyLoaded()) {
                log.debug("Refreshing lazily-loaded state for collection {}", (Object)collection);
                if (ref.get() != null) {
                    return;
                }
                this.refreshLegacyClusterState(null);
            } else if (this.watchedCollectionStates.containsKey(collection)) {
                log.debug("Forcing refresh of watched collection state for {}", (Object)collection);
                DocCollection newState = this.fetchCollectionState(collection, null);
                if (this.updateWatchedCollection(collection, newState)) {
                    this.constructState(Collections.singleton(collection));
                }
            } else {
                log.error("Collection {} is not lazy or watched!", (Object)collection);
            }
        }
    }

    public void updateLiveNodes() throws KeeperException, InterruptedException {
        this.refreshLiveNodes(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer compareStateVersions(String coll, int version) {
        DocCollection collection = this.clusterState.getCollectionOrNull(coll);
        if (collection == null) {
            return null;
        }
        if (collection.getZNodeVersion() < version) {
            log.debug("Server older than client {}<{}", (Object)collection.getZNodeVersion(), (Object)version);
            DocCollection nu = ZkStateReader.getCollectionLive(this, coll);
            if (nu == null) {
                return -1;
            }
            if (nu.getZNodeVersion() > collection.getZNodeVersion()) {
                if (this.updateWatchedCollection(coll, nu)) {
                    Object object = this.getUpdateLock();
                    synchronized (object) {
                        this.constructState(Collections.singleton(coll));
                    }
                }
                collection = nu;
            }
        }
        if (collection.getZNodeVersion() == version) {
            return null;
        }
        log.debug("Wrong version from client [{}]!=[{}]", (Object)version, (Object)collection.getZNodeVersion());
        return collection.getZNodeVersion();
    }

    public synchronized void createClusterStateWatchersAndUpdate() throws KeeperException, InterruptedException {
        log.debug("Updating cluster state from ZooKeeper... ");
        if (!this.zkClient.exists(CLUSTER_STATE, true).booleanValue()) {
            throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Cannot connect to cluster at " + this.zkClient.getZkServerAddress() + ": cluster not found/not ready");
        }
        this.loadClusterProperties();
        this.refreshLiveNodes(new LiveNodeWatcher());
        this.refreshLegacyClusterState(new LegacyClusterStateWatcher());
        this.refreshStateFormat2Collections();
        this.refreshCollectionList(new CollectionsChildWatcher());
        this.refreshAliases(this.aliasesManager);
        if (this.securityNodeListener != null) {
            this.addSecurityNodeWatcher(pair -> {
                ConfigData cd = new ConfigData();
                cd.data = pair.first() == null || ((byte[])pair.first()).length == 0 ? Collections.EMPTY_MAP : Utils.getDeepCopy((Map)Utils.fromJSON((byte[])pair.first()), 4, false);
                cd.version = pair.second() == null ? -1 : ((Stat)pair.second()).getVersion();
                this.securityData = cd;
                this.securityNodeListener.run();
            });
            this.securityData = this.getSecurityProps(true);
        }
        this.collectionPropsWatches.forEach((k, v) -> new PropsWatcher((String)k).refreshAndWatch(true));
    }

    private void addSecurityNodeWatcher(final Callable<Pair<byte[], Stat>> callback) throws KeeperException, InterruptedException {
        this.zkClient.exists(SOLR_SECURITY_CONF_PATH, new Watcher(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void process(WatchedEvent event) {
                if (Watcher.Event.EventType.None.equals((Object)event.getType())) {
                    return;
                }
                try {
                    Object object = ZkStateReader.this.getUpdateLock();
                    synchronized (object) {
                        log.debug("Updating [{}] ... ", (Object)ZkStateReader.SOLR_SECURITY_CONF_PATH);
                        2 thisWatch = this;
                        Stat stat = new Stat();
                        byte[] data = ZkStateReader.this.getZkClient().getData(ZkStateReader.SOLR_SECURITY_CONF_PATH, thisWatch, stat, true);
                        try {
                            callback.call(new Pair<byte[], Stat>(data, stat));
                        }
                        catch (Exception e) {
                            log.error("Error running collections node listener", (Throwable)e);
                        }
                    }
                }
                catch (KeeperException.ConnectionLossException | KeeperException.SessionExpiredException e) {
                    log.warn("ZooKeeper watch triggered, but Solr cannot talk to ZK: [{}]", (Object)e.getMessage());
                }
                catch (KeeperException e) {
                    log.error("A ZK error has occurred", (Throwable)e);
                    throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "", (Throwable)e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    log.warn("Interrupted", (Throwable)e);
                }
            }
        }, true);
    }

    private void constructState(Set<String> changedCollections) {
        SortedSet<String> liveNodes = this.liveNodes;
        LinkedHashMap<String, ClusterState.CollectionRef> result = new LinkedHashMap<String, ClusterState.CollectionRef>(this.legacyCollectionStates);
        for (Map.Entry<String, DocCollection> entry : this.watchedCollectionStates.entrySet()) {
            result.putIfAbsent(entry.getKey(), new ClusterState.CollectionRef(entry.getValue()));
        }
        for (Map.Entry<String, Object> entry : this.lazyCollectionStates.entrySet()) {
            result.putIfAbsent(entry.getKey(), (ClusterState.CollectionRef)entry.getValue());
        }
        this.clusterState = new ClusterState(liveNodes, result, this.legacyClusterStateVersion);
        log.debug("clusterStateSet: legacy [{}] interesting [{}] watched [{}] lazy [{}] total [{}]", new Object[]{this.legacyCollectionStates.keySet().size(), ((ConcurrentHashMap.CollectionView)((Object)this.collectionWatches.keySet())).size(), ((ConcurrentHashMap.CollectionView)((Object)this.watchedCollectionStates.keySet())).size(), ((ConcurrentHashMap.CollectionView)((Object)this.lazyCollectionStates.keySet())).size(), this.clusterState.getCollectionStates().size()});
        if (log.isTraceEnabled()) {
            log.trace("clusterStateSet: legacy [{}] interesting [{}] watched [{}] lazy [{}] total [{}]", new Object[]{this.legacyCollectionStates.keySet(), this.collectionWatches.keySet(), this.watchedCollectionStates.keySet(), this.lazyCollectionStates.keySet(), this.clusterState.getCollectionStates()});
        }
        this.notifyCloudCollectionsListeners();
        for (String string : changedCollections) {
            this.notifyStateWatchers(liveNodes, string, this.clusterState.getCollectionOrNull(string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshLegacyClusterState(Watcher watcher) throws KeeperException, InterruptedException {
        try {
            Stat stat = new Stat();
            byte[] data = this.zkClient.getData(CLUSTER_STATE, watcher, stat, true);
            ClusterState loadedData = ClusterState.load((Integer)stat.getVersion(), data, Collections.emptySet(), CLUSTER_STATE);
            Object object = this.getUpdateLock();
            synchronized (object) {
                if (this.legacyClusterStateVersion >= stat.getVersion()) {
                    return;
                }
                HashSet<String> updatedCollections = new HashSet<String>();
                for (String coll : this.collectionWatches.keySet()) {
                    DocCollection newState;
                    ClusterState.CollectionRef ref = this.legacyCollectionStates.get(coll);
                    DocCollection oldState = ref == null ? null : ref.get();
                    ClusterState.CollectionRef newRef = loadedData.getCollectionStates().get(coll);
                    DocCollection docCollection = newState = newRef == null ? null : newRef.get();
                    if (newState == null) {
                        newState = this.watchedCollectionStates.get(coll);
                    }
                    if (Objects.equals(oldState, newState)) continue;
                    updatedCollections.add(coll);
                }
                this.legacyCollectionStates = loadedData.getCollectionStates();
                this.legacyClusterStateVersion = stat.getVersion();
                this.constructState(updatedCollections);
            }
        }
        catch (KeeperException.NoNodeException e) {
            Object object = this.getUpdateLock();
            synchronized (object) {
                this.legacyCollectionStates = Collections.emptyMap();
                this.legacyClusterStateVersion = 0;
                this.constructState(Collections.emptySet());
            }
        }
    }

    private void refreshStateFormat2Collections() {
        for (String coll : this.collectionWatches.keySet()) {
            new StateWatcher(coll).refreshAndWatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshCollectionList(Watcher watcher) throws KeeperException, InterruptedException {
        Object object = this.refreshCollectionListLock;
        synchronized (object) {
            List<String> children = null;
            try {
                children = this.zkClient.getChildren(COLLECTIONS_ZKNODE, watcher, true);
            }
            catch (KeeperException.NoNodeException e) {
                log.warn("Error fetching collection names: [{}]", (Object)e.getMessage());
            }
            if (children == null || children.isEmpty()) {
                this.lazyCollectionStates.clear();
                return;
            }
            ((ConcurrentHashMap.CollectionView)((Object)this.lazyCollectionStates.keySet())).retainAll(children);
            for (String coll : children) {
                LazyCollectionRef existing;
                if (this.collectionWatches.containsKey(coll) || (existing = this.lazyCollectionStates.get(coll)) != null) continue;
                this.lazyCollectionStates.putIfAbsent(coll, new LazyCollectionRef(coll));
            }
        }
    }

    public void registerCloudCollectionsListener(CloudCollectionsListener cloudCollectionsListener) {
        this.cloudCollectionsListeners.add(cloudCollectionsListener);
        this.notifyNewCloudCollectionsListener(cloudCollectionsListener);
    }

    public void removeCloudCollectionsListener(CloudCollectionsListener cloudCollectionsListener) {
        this.cloudCollectionsListeners.remove(cloudCollectionsListener);
    }

    private void notifyNewCloudCollectionsListener(CloudCollectionsListener listener) {
        listener.onChange(Collections.emptySet(), this.lastFetchedCollectionSet.get());
    }

    private void notifyCloudCollectionsListeners() {
        this.notifyCloudCollectionsListeners(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyCloudCollectionsListeners(boolean notifyIfSame) {
        Object object = this.refreshCollectionsSetLock;
        synchronized (object) {
            Set<String> newCollections = this.getCurrentCollections();
            Set<String> oldCollections = this.lastFetchedCollectionSet.getAndSet(newCollections);
            if (!newCollections.equals(oldCollections) || notifyIfSame) {
                this.cloudCollectionsListeners.forEach(listener -> listener.onChange(oldCollections, newCollections));
            }
        }
    }

    private Set<String> getCurrentCollections() {
        HashSet<String> collections = new HashSet<String>();
        collections.addAll(this.legacyCollectionStates.keySet());
        collections.addAll(this.watchedCollectionStates.keySet());
        collections.addAll(this.lazyCollectionStates.keySet());
        return collections;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshLiveNodes(Watcher watcher) throws KeeperException, InterruptedException {
        SortedSet<String> oldLiveNodes;
        SortedSet newLiveNodes;
        Object object = this.refreshLiveNodesLock;
        synchronized (object) {
            try {
                List<String> nodeList = this.zkClient.getChildren(LIVE_NODES_ZKNODE, watcher, true);
                newLiveNodes = new TreeSet<String>(nodeList);
            }
            catch (KeeperException.NoNodeException e) {
                newLiveNodes = Collections.emptySortedSet();
            }
            this.lastFetchedLiveNodes.set(newLiveNodes);
        }
        Object object2 = this.getUpdateLock();
        synchronized (object2) {
            newLiveNodes = this.lastFetchedLiveNodes.getAndSet(null);
            if (newLiveNodes == null) {
                return;
            }
            oldLiveNodes = this.liveNodes;
            this.liveNodes = newLiveNodes;
            if (this.clusterState != null) {
                this.clusterState.setLiveNodes(newLiveNodes);
            }
        }
        if (oldLiveNodes.size() != newLiveNodes.size()) {
            log.info("Updated live nodes from ZooKeeper... ({}) -> ({})", (Object)oldLiveNodes.size(), (Object)newLiveNodes.size());
        }
        if (log.isDebugEnabled()) {
            log.debug("Updated live nodes from ZooKeeper... {} -> {}", oldLiveNodes, (Object)newLiveNodes);
        }
        if (!oldLiveNodes.equals(newLiveNodes)) {
            this.liveNodesListeners.forEach(listener -> listener.onChange(new TreeSet<String>(oldLiveNodes), new TreeSet<String>(newLiveNodes)));
        }
    }

    public void registerLiveNodesListener(LiveNodesListener listener) {
        this.liveNodesListeners.add(listener);
    }

    public void removeLiveNodesListener(LiveNodesListener listener) {
        this.liveNodesListeners.remove(listener);
    }

    public ClusterState getClusterState() {
        return this.clusterState;
    }

    public Object getUpdateLock() {
        return this;
    }

    @Override
    public void close() {
        this.closed = true;
        this.notifications.shutdown();
        ExecutorUtil.shutdownAndAwaitTermination(this.collectionPropsNotifications);
        if (this.closeClient) {
            this.zkClient.close();
        }
    }

    public String getLeaderUrl(String collection, String shard, int timeout) throws InterruptedException {
        ZkCoreNodeProps props = new ZkCoreNodeProps(this.getLeaderRetry(collection, shard, timeout));
        return props.getCoreUrl();
    }

    public Replica getLeader(String collection, String shard) {
        if (this.clusterState != null) {
            Replica replica;
            DocCollection docCollection = this.clusterState.getCollectionOrNull(collection);
            Replica replica2 = replica = docCollection != null ? docCollection.getLeader(shard) : null;
            if (replica != null && this.getClusterState().liveNodesContain(replica.getNodeName())) {
                return replica;
            }
        }
        return null;
    }

    public Replica getLeaderRetry(String collection, String shard) throws InterruptedException {
        return this.getLeaderRetry(collection, shard, 4000);
    }

    public Replica getLeaderRetry(String collection, String shard, int timeout) throws InterruptedException {
        long timeoutAt = System.nanoTime() + TimeUnit.NANOSECONDS.convert(timeout, TimeUnit.MILLISECONDS);
        while (true) {
            Replica leader;
            if ((leader = this.getLeader(collection, shard)) != null) {
                return leader;
            }
            if (System.nanoTime() >= timeoutAt || this.closed) break;
            Thread.sleep(50L);
        }
        throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "No registered leader was found after waiting for " + timeout + "ms , collection: " + collection + " slice: " + shard + " saw state=" + this.clusterState.getCollectionOrNull(collection) + " with live_nodes=" + this.clusterState.getLiveNodes());
    }

    public static String getShardLeadersPath(String collection, String shardId) {
        return "/collections/" + collection + "/" + SHARD_LEADERS_ZKNODE + (shardId != null ? "/" + shardId : "") + "/leader";
    }

    public static String getShardLeadersElectPath(String collection, String shardId) {
        return "/collections/" + collection + "/" + LEADER_ELECT_ZKNODE + (shardId != null ? "/" + shardId + "/" + ELECTION_NODE : "");
    }

    public List<ZkCoreNodeProps> getReplicaProps(String collection, String shardId, String thisCoreNodeName) {
        return this.getReplicaProps(collection, shardId, thisCoreNodeName, null);
    }

    public List<ZkCoreNodeProps> getReplicaProps(String collection, String shardId, String thisCoreNodeName, Replica.State mustMatchStateFilter) {
        return this.getReplicaProps(collection, shardId, thisCoreNodeName, mustMatchStateFilter, null);
    }

    public List<ZkCoreNodeProps> getReplicaProps(String collection, String shardId, String thisCoreNodeName, Replica.State mustMatchStateFilter, Replica.State mustNotMatchStateFilter) {
        return this.getReplicaProps(collection, shardId, thisCoreNodeName, mustMatchStateFilter, null, EnumSet.of(Replica.Type.TLOG, Replica.Type.NRT));
    }

    public List<ZkCoreNodeProps> getReplicaProps(String collection, String shardId, String thisCoreNodeName, Replica.State mustMatchStateFilter, Replica.State mustNotMatchStateFilter, EnumSet<Replica.Type> acceptReplicaType) {
        assert (thisCoreNodeName != null);
        ClusterState clusterState = this.clusterState;
        if (clusterState == null) {
            return null;
        }
        DocCollection docCollection = clusterState.getCollectionOrNull(collection);
        if (docCollection == null || docCollection.getSlicesMap() == null) {
            throw new ZooKeeperException(SolrException.ErrorCode.BAD_REQUEST, "Could not find collection in zk: " + collection);
        }
        Map<String, Slice> slices = docCollection.getSlicesMap();
        Slice replicas = slices.get(shardId);
        if (replicas == null) {
            throw new ZooKeeperException(SolrException.ErrorCode.BAD_REQUEST, "Could not find shardId in zk: " + shardId);
        }
        Map<String, Replica> shardMap = replicas.getReplicasMap();
        ArrayList<ZkCoreNodeProps> nodes = new ArrayList<ZkCoreNodeProps>(shardMap.size());
        for (Map.Entry entry : shardMap.entrySet().stream().filter(e -> acceptReplicaType.contains((Object)((Replica)e.getValue()).getType())).collect(Collectors.toList())) {
            ZkCoreNodeProps nodeProps = new ZkCoreNodeProps((ZkNodeProps)entry.getValue());
            String coreNodeName = ((Replica)entry.getValue()).getName();
            if (!clusterState.liveNodesContain(nodeProps.getNodeName()) || coreNodeName.equals(thisCoreNodeName) || mustMatchStateFilter != null && mustMatchStateFilter != Replica.State.getState(nodeProps.getState()) || mustNotMatchStateFilter != null && mustNotMatchStateFilter == Replica.State.getState(nodeProps.getState())) continue;
            nodes.add(nodeProps);
        }
        if (nodes.size() == 0) {
            return null;
        }
        return nodes;
    }

    public SolrZkClient getZkClient() {
        return this.zkClient;
    }

    public <T> T getClusterProperty(String key, T defaultValue) {
        Object value = Utils.getObjectByPath(this.clusterProperties, false, key);
        if (value == null) {
            return defaultValue;
        }
        return (T)value;
    }

    public <T> T getClusterProperty(List<String> keyPath, T defaultValue) {
        Object value = Utils.getObjectByPath(this.clusterProperties, false, keyPath);
        if (value == null) {
            return defaultValue;
        }
        return (T)value;
    }

    public Map<String, Object> getClusterProperties() {
        return Collections.unmodifiableMap(this.clusterProperties);
    }

    private void loadClusterProperties() {
        try {
            while (true) {
                try {
                    byte[] data = this.zkClient.getData(CLUSTER_PROPS, this.clusterPropertiesWatcher, new Stat(), true);
                    this.clusterProperties = (Map)Utils.fromJSON(data);
                    log.debug("Loaded cluster properties: {}", this.clusterProperties);
                    return;
                }
                catch (KeeperException.NoNodeException e) {
                    this.clusterProperties = Collections.emptyMap();
                    log.debug("Loaded empty cluster properties");
                    if (this.zkClient.exists(CLUSTER_PROPS, this.clusterPropertiesWatcher, true) != null) continue;
                    return;
                }
                break;
            }
        }
        catch (InterruptedException | KeeperException e) {
            log.error("Error reading cluster properties from zookeeper", SolrZkClient.checkInterrupted(e));
            return;
        }
    }

    public Map<String, String> getCollectionProperties(String collection) {
        Map<String, String> properties = this.watchedCollectionProps.get(collection);
        if (properties == null) {
            try {
                properties = this.fetchCollectionProperties(collection, null);
            }
            catch (Exception e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error reading collection properties", SolrZkClient.checkInterrupted(e));
            }
        }
        return properties;
    }

    static String getCollectionPropsPath(String collection) {
        return "/collections/" + collection + '/' + COLLECTION_PROPS_ZKNODE;
    }

    private Map<String, String> fetchCollectionProperties(String collection, Watcher watcher) throws KeeperException, InterruptedException {
        String znodePath = ZkStateReader.getCollectionPropsPath(collection);
        while (true) {
            try {
                byte[] data = this.zkClient.getData(znodePath, watcher, null, true);
                return (Map)Utils.fromJSON(data);
            }
            catch (ClassCastException e) {
                throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Unable to parse collection properties for collection " + collection, (Throwable)e);
            }
            catch (KeeperException.NoNodeException e) {
                Stat exists;
                if (watcher != null && (exists = this.zkClient.exists(znodePath, watcher, true)) != null) continue;
                return Collections.emptyMap();
            }
            break;
        }
    }

    public ConfigData getSecurityProps(boolean getFresh) {
        if (!getFresh) {
            if (this.securityData == null) {
                return new ConfigData(Collections.EMPTY_MAP, -1);
            }
            return new ConfigData(this.securityData.data, this.securityData.version);
        }
        try {
            Stat stat = new Stat();
            if (this.getZkClient().exists(SOLR_SECURITY_CONF_PATH, true).booleanValue()) {
                byte[] data = this.getZkClient().getData(SOLR_SECURITY_CONF_PATH, null, stat, true);
                return data != null && data.length > 0 ? new ConfigData((Map)Utils.fromJSON(data), stat.getVersion()) : null;
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error reading security properties", (Throwable)e);
        }
        catch (KeeperException e) {
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Error reading security properties", (Throwable)e);
        }
        return null;
    }

    public String getBaseUrlForNodeName(String nodeName) {
        return Utils.getBaseUrlForNodeName(nodeName, this.getClusterProperty(URL_SCHEME, "http"));
    }

    public static DocCollection getCollectionLive(ZkStateReader zkStateReader, String coll) {
        try {
            return zkStateReader.fetchCollectionState(coll, null);
        }
        catch (KeeperException e) {
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Could not load collection from ZK: " + coll, (Throwable)e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SolrException(SolrException.ErrorCode.BAD_REQUEST, "Could not load collection from ZK: " + coll, (Throwable)e);
        }
    }

    private DocCollection fetchCollectionState(String coll, Watcher watcher) throws KeeperException, InterruptedException {
        String collectionPath = ZkStateReader.getCollectionPath(coll);
        while (true) {
            try {
                Stat stat = new Stat();
                byte[] data = this.zkClient.getData(collectionPath, watcher, stat, true);
                ClusterState state = ClusterState.load((Integer)stat.getVersion(), data, Collections.emptySet(), collectionPath);
                ClusterState.CollectionRef collectionRef = state.getCollectionStates().get(coll);
                return collectionRef == null ? null : collectionRef.get();
            }
            catch (KeeperException.NoNodeException e) {
                Stat exists;
                if (watcher != null && (exists = this.zkClient.exists(collectionPath, watcher, true)) != null) continue;
                return null;
            }
            break;
        }
    }

    public static String getCollectionPathRoot(String coll) {
        return "/collections/" + coll;
    }

    public static String getCollectionPath(String coll) {
        return ZkStateReader.getCollectionPathRoot(coll) + "/state.json";
    }

    public void registerCore(String collection) {
        AtomicBoolean reconstructState = new AtomicBoolean(false);
        this.collectionWatches.compute(collection, (k, v) -> {
            if (v == null) {
                reconstructState.set(true);
                v = new CollectionWatch();
            }
            ++v.coreRefCount;
            return v;
        });
        if (reconstructState.get()) {
            new StateWatcher(collection).refreshAndWatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterCore(String collection) {
        AtomicBoolean reconstructState = new AtomicBoolean(false);
        this.collectionWatches.compute(collection, (k, v) -> {
            if (v == null) {
                return null;
            }
            if (v.coreRefCount > 0) {
                --v.coreRefCount;
            }
            if (v.canBeRemoved()) {
                this.watchedCollectionStates.remove(collection);
                this.lazyCollectionStates.put(collection, new LazyCollectionRef(collection));
                reconstructState.set(true);
                return null;
            }
            return v;
        });
        if (reconstructState.get()) {
            Object object = this.getUpdateLock();
            synchronized (object) {
                this.constructState(Collections.emptySet());
            }
        }
    }

    public void registerCollectionStateWatcher(String collection, CollectionStateWatcher stateWatcher) {
        DocCollection state;
        AtomicBoolean watchSet = new AtomicBoolean(false);
        this.collectionWatches.compute(collection, (k, v) -> {
            if (v == null) {
                v = new CollectionWatch();
                watchSet.set(true);
            }
            v.stateWatchers.add(stateWatcher);
            return v;
        });
        if (watchSet.get()) {
            new StateWatcher(collection).refreshAndWatch();
        }
        if (stateWatcher.onStateChanged(this.liveNodes, state = this.clusterState.getCollectionOrNull(collection))) {
            this.removeCollectionStateWatcher(collection, stateWatcher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForState(String collection, long wait, TimeUnit unit, CollectionStatePredicate predicate) throws InterruptedException, TimeoutException {
        CountDownLatch latch = new CountDownLatch(1);
        CollectionStateWatcher watcher = (n, c) -> {
            boolean matches = predicate.matches(n, c);
            if (matches) {
                latch.countDown();
            }
            return matches;
        };
        this.registerCollectionStateWatcher(collection, watcher);
        try {
            if (!latch.await(wait, unit)) {
                throw new TimeoutException();
            }
        }
        finally {
            this.removeCollectionStateWatcher(collection, watcher);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeCollectionStateWatcher(String collection, CollectionStateWatcher watcher) {
        AtomicBoolean reconstructState = new AtomicBoolean(false);
        this.collectionWatches.compute(collection, (k, v) -> {
            if (v == null) {
                return null;
            }
            v.stateWatchers.remove(watcher);
            if (v.canBeRemoved()) {
                this.watchedCollectionStates.remove(collection);
                this.lazyCollectionStates.put(collection, new LazyCollectionRef(collection));
                reconstructState.set(true);
                return null;
            }
            return v;
        });
        if (reconstructState.get()) {
            Object object = this.getUpdateLock();
            synchronized (object) {
                this.constructState(Collections.emptySet());
            }
        }
    }

    Set<CollectionStateWatcher> getStateWatchers(String collection) {
        HashSet<CollectionStateWatcher> watchers = new HashSet<CollectionStateWatcher>();
        this.collectionWatches.compute(collection, (k, v) -> {
            if (v != null) {
                watchers.addAll(v.stateWatchers);
            }
            return v;
        });
        return watchers;
    }

    private boolean updateWatchedCollection(String coll, DocCollection newState) {
        if (newState == null) {
            log.debug("Removing cached collection state for [{}]", (Object)coll);
            this.watchedCollectionStates.remove(coll);
            return true;
        }
        boolean updated = false;
        while (this.collectionWatches.containsKey(coll)) {
            DocCollection oldState = this.watchedCollectionStates.get(coll);
            if (oldState == null) {
                if (this.watchedCollectionStates.putIfAbsent(coll, newState) != null) continue;
                log.debug("Add data for [{}] ver [{}]", (Object)coll, (Object)newState.getZNodeVersion());
                updated = true;
                break;
            }
            if (oldState.getZNodeVersion() >= newState.getZNodeVersion()) {
                updated = true;
                break;
            }
            if (!this.watchedCollectionStates.replace(coll, oldState, newState)) continue;
            log.debug("Updating data for [{}] from [{}] to [{}]", new Object[]{coll, oldState.getZNodeVersion(), newState.getZNodeVersion()});
            updated = true;
            break;
        }
        if (!this.collectionWatches.containsKey(coll)) {
            this.watchedCollectionStates.remove(coll);
            log.debug("Removing uninteresting collection [{}]", (Object)coll);
        }
        return updated;
    }

    public void registerCollectionPropsWatcher(String collection, CollectionPropsWatcher propsWatcher) {
        AtomicBoolean watchSet = new AtomicBoolean(false);
        this.collectionPropsWatches.compute(collection, (k, v) -> {
            if (v == null) {
                v = new CollectionWatch();
                watchSet.set(true);
            }
            v.stateWatchers.add(propsWatcher);
            return v;
        });
        if (watchSet.get()) {
            new PropsWatcher(collection).refreshAndWatch(false);
        }
    }

    public void removeCollectionPropsWatcher(String collection, CollectionPropsWatcher watcher) {
        this.collectionPropsWatches.compute(collection, (k, v) -> {
            if (v == null) {
                return null;
            }
            v.stateWatchers.remove(watcher);
            if (v.canBeRemoved()) {
                this.watchedCollectionProps.remove(collection);
                return null;
            }
            return v;
        });
    }

    private void notifyStateWatchers(Set<String> liveNodes, String collection, DocCollection collectionState) {
        block2: {
            try {
                this.notifications.submit(new Notification(liveNodes, collection, collectionState));
            }
            catch (RejectedExecutionException e) {
                if (this.closed) break block2;
                log.error("Couldn't run collection notifications for {}", (Object)collection, (Object)e);
            }
        }
    }

    public Aliases getAliases() {
        return this.aliasesManager.getAliases();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshAliases(AliasesManager watcher) throws KeeperException, InterruptedException {
        Object object = this.getUpdateLock();
        synchronized (object) {
            this.constructState(Collections.emptySet());
            this.zkClient.exists(ALIASES, watcher, true);
        }
        this.aliasesManager.update();
    }

    private void notifyPropsWatchers(String collection, Map<String, String> properties) {
        block2: {
            try {
                this.collectionPropsNotifications.submit(new PropsNotification(collection, properties));
            }
            catch (RejectedExecutionException e) {
                if (this.closed) break block2;
                log.error("Couldn't run collection properties notifications for {}", (Object)collection, (Object)e);
            }
        }
    }

    private class PropsNotification
    implements Runnable {
        final String collection;
        final Map<String, String> collectionProperties;

        private PropsNotification(String collection, Map<String, String> collectionProperties) {
            this.collection = collection;
            this.collectionProperties = collectionProperties;
        }

        @Override
        public void run() {
            ArrayList watchers = new ArrayList();
            ZkStateReader.this.collectionPropsWatches.compute(this.collection, (k, v) -> {
                if (v == null) {
                    return null;
                }
                watchers.addAll(v.stateWatchers);
                return v;
            });
            for (CollectionPropsWatcher watcher : watchers) {
                if (!watcher.onStateChanged(this.collectionProperties)) continue;
                ZkStateReader.this.removeCollectionPropsWatcher(this.collection, watcher);
            }
        }
    }

    public class AliasesManager
    implements Watcher {
        private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
        private volatile Aliases aliases = Aliases.EMPTY;

        public Aliases getAliases() {
            return this.aliases;
        }

        public void applyModificationAndExportToZk(UnaryOperator<Aliases> op) {
            if (this.aliases.getZNodeVersion() == -1) {
                try {
                    boolean updated = this.update();
                    assert (updated);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, e.toString(), (Throwable)e);
                }
                catch (KeeperException e) {
                    throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, e.toString(), (Throwable)e);
                }
            }
            long deadlineNanos = System.nanoTime() + TimeUnit.SECONDS.toNanos(30L);
            for (int triesLeft = 30; triesLeft > 0; --triesLeft) {
                Aliases curAliases = this.getAliases();
                Aliases modAliases = (Aliases)op.apply(curAliases);
                byte[] modAliasesJson = modAliases.toJSON();
                if (curAliases == modAliases) {
                    this.log.debug("Current aliases has the desired modification; no further ZK interaction needed.");
                    return;
                }
                try {
                    try {
                        Stat stat = ZkStateReader.this.getZkClient().setData(ZkStateReader.ALIASES, modAliasesJson, curAliases.getZNodeVersion(), true);
                        this.setIfNewer(Aliases.fromJSON(modAliasesJson, stat.getVersion()));
                        return;
                    }
                    catch (KeeperException.BadVersionException e) {
                        this.log.debug(e.toString(), (Throwable)e);
                        this.log.warn("Couldn't save aliases due to race with another modification; will update and retry until timeout");
                        this.update();
                        if (deadlineNanos >= System.nanoTime()) continue;
                        throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Timed out trying to update aliases! Either zookeeper or this node may be overloaded.");
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, e.toString(), (Throwable)e);
                }
                catch (KeeperException e) {
                    throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, e.toString(), (Throwable)e);
                }
            }
            throw new SolrException(SolrException.ErrorCode.SERVER_ERROR, "Too many successive version failures trying to update aliases");
        }

        public boolean update() throws KeeperException, InterruptedException {
            this.log.debug("Checking ZK for most up to date Aliases {}", (Object)ZkStateReader.ALIASES);
            ZkStateReader.this.zkClient.getSolrZooKeeper().sync(ZkStateReader.ALIASES, null, null);
            Stat stat = new Stat();
            byte[] data = ZkStateReader.this.zkClient.getData(ZkStateReader.ALIASES, null, stat, true);
            return this.setIfNewer(Aliases.fromJSON(data, stat.getVersion()));
        }

        @Override
        public void process(WatchedEvent event) {
            if (Watcher.Event.EventType.None.equals((Object)event.getType())) {
                return;
            }
            try {
                this.log.debug("Aliases: updating");
                Stat stat = new Stat();
                byte[] data = ZkStateReader.this.zkClient.getData(ZkStateReader.ALIASES, this, stat, true);
                this.setIfNewer(Aliases.fromJSON(data, stat.getVersion()));
            }
            catch (KeeperException.ConnectionLossException | KeeperException.SessionExpiredException e) {
                this.log.warn("ZooKeeper watch triggered, but Solr cannot talk to ZK: [{}]", (Object)e.getMessage());
            }
            catch (KeeperException e) {
                this.log.error("A ZK error has occurred", (Throwable)e);
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "A ZK error has occurred", (Throwable)e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.log.warn("Interrupted", (Throwable)e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean setIfNewer(Aliases newAliases) {
            assert (newAliases.getZNodeVersion() >= 0);
            AliasesManager aliasesManager = this;
            synchronized (aliasesManager) {
                int cmp = Integer.compare(this.aliases.getZNodeVersion(), newAliases.getZNodeVersion());
                if (cmp < 0) {
                    this.log.debug("Aliases: cmp={}, new definition is: {}", (Object)cmp, (Object)newAliases);
                    this.aliases = newAliases;
                    this.notifyAll();
                    return true;
                }
                this.log.debug("Aliases: cmp={}, not overwriting ZK version.", (Object)cmp);
                assert (cmp != 0 || Arrays.equals(this.aliases.toJSON(), newAliases.toJSON())) : this.aliases + " != " + newAliases;
                return false;
            }
        }
    }

    private class Notification
    implements Runnable {
        final Set<String> liveNodes;
        final String collection;
        final DocCollection collectionState;

        private Notification(Set<String> liveNodes, String collection, DocCollection collectionState) {
            this.liveNodes = liveNodes;
            this.collection = collection;
            this.collectionState = collectionState;
        }

        @Override
        public void run() {
            ArrayList watchers = new ArrayList();
            ZkStateReader.this.collectionWatches.compute(this.collection, (k, v) -> {
                if (v == null) {
                    return null;
                }
                watchers.addAll(v.stateWatchers);
                return v;
            });
            for (CollectionStateWatcher watcher : watchers) {
                try {
                    if (!watcher.onStateChanged(this.liveNodes, this.collectionState)) continue;
                    ZkStateReader.this.removeCollectionStateWatcher(this.collection, watcher);
                }
                catch (Exception exception) {
                    log.warn("Error on calling watcher", (Throwable)exception);
                }
            }
        }
    }

    public static class ConfigData {
        public Map<String, Object> data;
        public int version;

        public ConfigData() {
        }

        public ConfigData(Map<String, Object> data, int version) {
            this.data = data;
            this.version = version;
        }
    }

    class LiveNodeWatcher
    implements Watcher {
        LiveNodeWatcher() {
        }

        @Override
        public void process(WatchedEvent event) {
            if (Watcher.Event.EventType.None.equals((Object)event.getType())) {
                return;
            }
            log.debug("A live node change: [{}], has occurred - updating... (live nodes size: [{}])", (Object)event, (Object)ZkStateReader.this.liveNodes.size());
            this.refreshAndWatch();
        }

        public void refreshAndWatch() {
            try {
                ZkStateReader.this.refreshLiveNodes(this);
            }
            catch (KeeperException.ConnectionLossException | KeeperException.SessionExpiredException e) {
                log.warn("ZooKeeper watch triggered, but Solr cannot talk to ZK: [{}]", (Object)e.getMessage());
            }
            catch (KeeperException e) {
                log.error("A ZK error has occurred", (Throwable)e);
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "A ZK error has occurred", (Throwable)e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.warn("Interrupted", (Throwable)e);
            }
        }
    }

    class CollectionsChildWatcher
    implements Watcher {
        CollectionsChildWatcher() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void process(WatchedEvent event) {
            if (Watcher.Event.EventType.None.equals((Object)event.getType())) {
                return;
            }
            log.debug("A collections change: [{}], has occurred - updating...", (Object)event);
            this.refreshAndWatch();
            Object object = ZkStateReader.this.getUpdateLock();
            synchronized (object) {
                ZkStateReader.this.constructState(Collections.emptySet());
            }
        }

        public void refreshAndWatch() {
            try {
                ZkStateReader.this.refreshCollectionList(this);
            }
            catch (KeeperException.ConnectionLossException | KeeperException.SessionExpiredException e) {
                log.warn("ZooKeeper watch triggered, but Solr cannot talk to ZK: [{}]", (Object)e.getMessage());
            }
            catch (KeeperException e) {
                log.error("A ZK error has occurred", (Throwable)e);
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "A ZK error has occurred", (Throwable)e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.warn("Interrupted", (Throwable)e);
            }
        }
    }

    class PropsWatcher
    implements Watcher {
        private final String coll;

        PropsWatcher(String coll) {
            this.coll = coll;
        }

        @Override
        public void process(WatchedEvent event) {
            if (Watcher.Event.EventType.None.equals((Object)event.getType())) {
                return;
            }
            if (!ZkStateReader.this.collectionPropsWatches.containsKey(this.coll)) {
                log.debug("Ignoring property change for collection {}", (Object)this.coll);
                return;
            }
            log.info("A collection property change: [{}] for collection [{}] has occurred - updating...", (Object)event, (Object)this.coll);
            this.refreshAndWatch(true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void refreshAndWatch(boolean notifyWatchers) {
            try {
                String string = this.coll;
                synchronized (string) {
                    Map properties = ZkStateReader.this.fetchCollectionProperties(this.coll, this);
                    ZkStateReader.this.watchedCollectionProps.put(this.coll, properties);
                    if (notifyWatchers) {
                        ZkStateReader.this.notifyPropsWatchers(this.coll, properties);
                    }
                }
            }
            catch (KeeperException.ConnectionLossException | KeeperException.SessionExpiredException e) {
                log.warn("ZooKeeper watch triggered, but Solr cannot talk to ZK: [{}]", (Object)e.getMessage());
            }
            catch (KeeperException e) {
                log.error("Lost collection property watcher for {} due to ZK error", (Object)this.coll, (Object)e);
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "A ZK error has occurred", (Throwable)e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.error("Lost collection property watcher for {} due to the thread being interrupted", (Object)this.coll, (Object)e);
            }
        }
    }

    class LegacyClusterStateWatcher
    implements Watcher {
        LegacyClusterStateWatcher() {
        }

        @Override
        public void process(WatchedEvent event) {
            if (Watcher.Event.EventType.None.equals((Object)event.getType())) {
                return;
            }
            int liveNodesSize = ZkStateReader.this.clusterState == null ? 0 : ZkStateReader.this.clusterState.getLiveNodes().size();
            log.debug("A cluster state change: [{}], has occurred - updating... (live nodes size: [{}])", (Object)event, (Object)liveNodesSize);
            this.refreshAndWatch();
        }

        public void refreshAndWatch() {
            try {
                ZkStateReader.this.refreshLegacyClusterState(this);
            }
            catch (KeeperException.NoNodeException e) {
                throw new SolrException(SolrException.ErrorCode.SERVICE_UNAVAILABLE, "Cannot connect to cluster at " + ZkStateReader.this.zkClient.getZkServerAddress() + ": cluster not found/not ready");
            }
            catch (KeeperException.ConnectionLossException | KeeperException.SessionExpiredException e) {
                log.warn("ZooKeeper watch triggered, but Solr cannot talk to ZK: [{}]", (Object)e.getMessage());
            }
            catch (KeeperException e) {
                log.error("A ZK error has occurred", (Throwable)e);
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "A ZK error has occurred", (Throwable)e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.warn("Interrupted", (Throwable)e);
            }
        }
    }

    class StateWatcher
    implements Watcher {
        private final String coll;

        StateWatcher(String coll) {
            this.coll = coll;
        }

        @Override
        public void process(WatchedEvent event) {
            if (Watcher.Event.EventType.None.equals((Object)event.getType())) {
                return;
            }
            if (!ZkStateReader.this.collectionWatches.containsKey(this.coll)) {
                log.debug("Uninteresting collection {}", (Object)this.coll);
                return;
            }
            SortedSet liveNodes = ZkStateReader.this.liveNodes;
            log.info("A cluster state change: [{}] for collection [{}] has occurred - updating... (live nodes size: [{}])", new Object[]{event, this.coll, liveNodes.size()});
            this.refreshAndWatch();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void refreshAndWatch() {
            try {
                DocCollection newState = ZkStateReader.this.fetchCollectionState(this.coll, this);
                ZkStateReader.this.updateWatchedCollection(this.coll, newState);
                Object object = ZkStateReader.this.getUpdateLock();
                synchronized (object) {
                    ZkStateReader.this.constructState(Collections.singleton(this.coll));
                }
            }
            catch (KeeperException.ConnectionLossException | KeeperException.SessionExpiredException e) {
                log.warn("ZooKeeper watch triggered, but Solr cannot talk to ZK: [{}]", (Object)e.getMessage());
            }
            catch (KeeperException e) {
                log.error("Unwatched collection: [{}]", (Object)this.coll, (Object)e);
                throw new ZooKeeperException(SolrException.ErrorCode.SERVER_ERROR, "A ZK error has occurred", (Throwable)e);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                log.error("Unwatched collection: [{}]", (Object)this.coll, (Object)e);
            }
        }
    }

    private class LazyCollectionRef
    extends ClusterState.CollectionRef {
        private final String collName;
        private long lastUpdateTime;
        private DocCollection cachedDocCollection;

        public LazyCollectionRef(String collName) {
            super(null);
            this.collName = collName;
            this.lastUpdateTime = -1L;
        }

        @Override
        public synchronized DocCollection get(boolean allowCached) {
            this.gets.incrementAndGet();
            if (!allowCached || this.lastUpdateTime < 0L || System.nanoTime() - this.lastUpdateTime > LAZY_CACHE_TIME) {
                boolean shouldFetch = true;
                if (this.cachedDocCollection != null) {
                    Stat exists = null;
                    try {
                        exists = ZkStateReader.this.zkClient.exists(ZkStateReader.getCollectionPath(this.collName), null, true);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (exists != null && exists.getVersion() == this.cachedDocCollection.getZNodeVersion()) {
                        shouldFetch = false;
                    }
                }
                if (shouldFetch) {
                    this.cachedDocCollection = ZkStateReader.getCollectionLive(ZkStateReader.this, this.collName);
                    this.lastUpdateTime = System.nanoTime();
                }
            }
            return this.cachedDocCollection;
        }

        @Override
        public boolean isLazilyLoaded() {
            return true;
        }

        @Override
        public String toString() {
            return "LazyCollectionRef(" + this.collName + ")";
        }
    }

    private static class CollectionWatch<T> {
        int coreRefCount = 0;
        Set<T> stateWatchers = ConcurrentHashMap.newKeySet();

        private CollectionWatch() {
        }

        public boolean canBeRemoved() {
            return this.coreRefCount + this.stateWatchers.size() == 0;
        }
    }
}

