/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.sparkrest;

import spark.Route;
import spark.Spark;

public final class CamelSpark {
    private CamelSpark() {
    }

    public static void stop() {
        Spark.stop();
    }

    public static void port(int port) {
        Spark.port(port);
    }

    public static void ipAddress(String ip) {
        Spark.ipAddress(ip);
    }

    public static void threadPool(int minThreads, int maxThreads, int timeOutMillis) {
        int min = minThreads > 0 ? minThreads : -1;
        int max = maxThreads > 0 ? maxThreads : -1;
        int idle = timeOutMillis > 0 ? timeOutMillis : -1;
        Spark.threadPool(max, min, idle);
    }

    public static void security(String keystoreFile, String keystorePassword, String truststoreFile, String truststorePassword) {
        Spark.secure(keystoreFile, keystorePassword, truststoreFile, truststorePassword);
    }

    public static void spark(String verb, String path, String accept, Route route) {
        if ("get".equals(verb)) {
            if (accept != null) {
                Spark.get(path, accept, route);
            } else {
                Spark.get(path, route);
            }
        } else if ("post".equals(verb)) {
            if (accept != null) {
                Spark.post(path, accept, route);
            } else {
                Spark.post(path, route);
            }
        } else if ("put".equals(verb)) {
            if (accept != null) {
                Spark.put(path, accept, route);
            } else {
                Spark.put(path, route);
            }
        } else if ("patch".equals(verb)) {
            if (accept != null) {
                Spark.patch(path, accept, route);
            } else {
                Spark.patch(path, route);
            }
        } else if ("delete".equals(verb)) {
            if (accept != null) {
                Spark.delete(path, accept, route);
            } else {
                Spark.delete(path, route);
            }
        } else if ("head".equals(verb)) {
            if (accept != null) {
                Spark.head(path, accept, route);
            } else {
                Spark.head(path, route);
            }
        } else if ("trace".equals(verb)) {
            if (accept != null) {
                Spark.trace(path, accept, route);
            } else {
                Spark.trace(path, route);
            }
        } else if ("connect".equals(verb)) {
            if (accept != null) {
                Spark.connect(path, accept, route);
            } else {
                Spark.connect(path, route);
            }
        } else if ("options".equals(verb)) {
            if (accept != null) {
                Spark.options(path, accept, route);
            } else {
                Spark.options(path, route);
            }
        }
    }
}

