/*
 * Decompiled with CFR 0.152.
 */
package com.splunk;

import com.splunk.Args;
import com.splunk.HttpException;
import com.splunk.RequestMessage;
import com.splunk.ResponseMessage;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ProtocolException;
import java.net.Socket;
import java.net.URL;
import java.net.URLStreamHandler;
import java.net.UnknownHostException;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.HttpsURLConnection;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;

public class HttpService {
    private static final boolean VERBOSE_REQUESTS = false;
    private static final SSLSocketFactory SSL_SOCKET_FACTORY = HttpService.createSSLFactory();
    private static String HTTPS_SCHEME = "https";
    private static String HTTP_SCHEME = "http";
    private static final HostnameVerifier HOSTNAME_VERIFIER = new HostnameVerifier(){

        @Override
        public boolean verify(String s, SSLSession sslSession) {
            return true;
        }
    };
    protected URLStreamHandler httpsHandler = null;
    protected String scheme = "https";
    protected String host = "localhost";
    protected int port = 8089;
    private String prefix = null;
    static Map<String, String> defaultHeader = new HashMap<String, String>(){
        {
            this.put("User-Agent", "splunk-sdk-java/1.3.2");
            this.put("Accept", "*/*");
        }
    };

    public HttpService() {
    }

    public HttpService(String host) {
        this.host = host;
    }

    public HttpService(String host, int port) {
        this.host = host;
        this.port = port;
    }

    public HttpService(String host, int port, String scheme) {
        this.host = host;
        this.port = port;
        this.scheme = scheme;
    }

    public HttpService(String host, int port, String scheme, URLStreamHandler httpsHandler) {
        this.host = host;
        this.port = port;
        this.scheme = scheme;
        this.httpsHandler = httpsHandler;
    }

    private static int count(Map<String, Object> args) {
        if (args == null) {
            return 0;
        }
        return args.size();
    }

    public ResponseMessage get(String path) {
        return this.send(path, new RequestMessage("GET"));
    }

    public ResponseMessage get(String path, Map<String, Object> args) {
        if (HttpService.count(args) > 0) {
            path = path + "?" + Args.encode(args);
        }
        RequestMessage request = new RequestMessage("GET");
        return this.send(path, request);
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public String getPrefix() {
        if (this.prefix == null) {
            this.prefix = String.format("%s://%s:%s", this.scheme, this.host, this.port);
        }
        return this.prefix;
    }

    public String getScheme() {
        return this.scheme;
    }

    public URL getUrl(String path) {
        try {
            if (HTTPS_SCHEME.equals(this.getScheme()) && this.httpsHandler != null) {
                return new URL(this.getScheme(), this.getHost(), this.getPort(), path, this.httpsHandler);
            }
            return new URL(this.getScheme(), this.getHost(), this.getPort(), path);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public ResponseMessage post(String path) {
        return this.post(path, null);
    }

    public ResponseMessage post(String path, Map<String, Object> args) {
        RequestMessage request = new RequestMessage("POST");
        request.getHeader().put("Content-Type", "application/x-www-form-urlencoded");
        if (HttpService.count(args) > 0) {
            request.setContent(Args.encode(args));
        }
        return this.send(path, request);
    }

    public ResponseMessage delete(String path) {
        RequestMessage request = new RequestMessage("DELETE");
        return this.send(path, request);
    }

    public ResponseMessage delete(String path, Map<String, Object> args) {
        if (HttpService.count(args) > 0) {
            path = path + "?" + Args.encode(args);
        }
        RequestMessage request = new RequestMessage("DELETE");
        return this.send(path, request);
    }

    Socket open() throws IOException {
        if (this.scheme.equals("https")) {
            return SSL_SOCKET_FACTORY.createSocket(this.host, this.port);
        }
        return new Socket(this.host, this.port);
    }

    public ResponseMessage send(String path, RequestMessage request) {
        InputStream input;
        int status;
        block17: {
            HttpURLConnection cn;
            URL url = this.getUrl(path);
            try {
                cn = (HttpURLConnection)url.openConnection();
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            if (cn instanceof HttpsURLConnection) {
                ((HttpsURLConnection)cn).setSSLSocketFactory(SSL_SOCKET_FACTORY);
                ((HttpsURLConnection)cn).setHostnameVerifier(HOSTNAME_VERIFIER);
            }
            cn.setUseCaches(false);
            cn.setAllowUserInteraction(false);
            String method = request.getMethod();
            try {
                cn.setRequestMethod(method);
            }
            catch (ProtocolException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            Map<String, String> header = request.getHeader();
            for (Map.Entry<String, String> entry : header.entrySet()) {
                cn.setRequestProperty(entry.getKey(), entry.getValue());
            }
            for (Map.Entry<String, String> entry : defaultHeader.entrySet()) {
                String key = entry.getKey();
                if (header.containsKey(key)) continue;
                cn.setRequestProperty(key, entry.getValue());
            }
            try {
                Object content = request.getContent();
                if (content != null) {
                    cn.setDoOutput(true);
                    OutputStream stream = cn.getOutputStream();
                    OutputStreamWriter writer = new OutputStreamWriter(stream, "UTF-8");
                    writer.write((String)content);
                    writer.close();
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            try {
                cn.connect();
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            try {
                status = cn.getResponseCode();
            }
            catch (IOException e) {
                throw new RuntimeException(e.getMessage(), e);
            }
            input = null;
            try {
                input = status >= 400 ? cn.getErrorStream() : cn.getInputStream();
            }
            catch (IOException e) {
                if ($assertionsDisabled) break block17;
                throw new AssertionError();
            }
        }
        ResponseMessage response = new ResponseMessage(status, input);
        if (status >= 400) {
            throw HttpException.create(response);
        }
        return response;
    }

    private static SSLSocketFactory createSSLFactory() {
        TrustManager[] trustAll = new TrustManager[]{new X509TrustManager(){

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }

            @Override
            public void checkClientTrusted(X509Certificate[] certs, String authType) {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] certs, String authType) {
            }
        }};
        try {
            SSLContext context = SSLContext.getInstance("SSL");
            context.init(null, trustAll, new SecureRandom());
            return new SSLv3SocketFactory(context.getSocketFactory());
        }
        catch (Exception e) {
            throw new RuntimeException("Error setting up SSL socket factory: " + e, e);
        }
    }

    private static final class SSLv3SocketFactory
    extends SSLSocketFactory {
        private final SSLSocketFactory delegate;
        public static final String[] PROTOCOLS = new String[]{"SSLv3"};

        private SSLv3SocketFactory(SSLSocketFactory delegate) {
            this.delegate = delegate;
        }

        private Socket configure(Socket socket) {
            if (socket instanceof SSLSocket) {
                ((SSLSocket)socket).setEnabledProtocols(PROTOCOLS);
            }
            return socket;
        }

        @Override
        public String[] getDefaultCipherSuites() {
            return this.delegate.getDefaultCipherSuites();
        }

        @Override
        public String[] getSupportedCipherSuites() {
            return this.delegate.getSupportedCipherSuites();
        }

        @Override
        public Socket createSocket(Socket socket, String s, int i, boolean b) throws IOException {
            return this.configure(this.delegate.createSocket(socket, s, i, b));
        }

        @Override
        public Socket createSocket() throws IOException {
            return this.configure(this.delegate.createSocket());
        }

        @Override
        public Socket createSocket(String s, int i) throws IOException, UnknownHostException {
            return this.configure(this.delegate.createSocket(s, i));
        }

        @Override
        public Socket createSocket(String s, int i, InetAddress inetAddress, int i1) throws IOException, UnknownHostException {
            return this.configure(this.delegate.createSocket(s, i, inetAddress, i1));
        }

        @Override
        public Socket createSocket(InetAddress inetAddress, int i) throws IOException {
            return this.configure(this.delegate.createSocket(inetAddress, i));
        }

        @Override
        public Socket createSocket(InetAddress inetAddress, int i, InetAddress inetAddress1, int i1) throws IOException {
            return this.configure(this.delegate.createSocket(inetAddress, i, inetAddress1, i1));
        }
    }
}

