/*
 * Decompiled with CFR 0.152.
 */
package com.splunk;

import com.splunk.Args;
import com.splunk.AtomEntry;
import com.splunk.Entity;
import com.splunk.HttpException;
import com.splunk.JobEventsArgs;
import com.splunk.JobResultsArgs;
import com.splunk.JobResultsPreviewArgs;
import com.splunk.JobSummaryArgs;
import com.splunk.ResponseMessage;
import com.splunk.Service;
import com.splunk.SplunkException;
import com.splunk.Xml;
import java.io.InputStream;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class Job
extends Entity {
    private boolean isReady = false;

    Job(Service service, String path) {
        super(service, path);
    }

    @Override
    protected String actionPath(String action) {
        if (action.equals("control")) {
            return this.path + "/control";
        }
        return super.actionPath(action);
    }

    public Job control(String action) {
        return this.control(action, null);
    }

    public Job control(String action, Map args) {
        args = Args.create(args).add("action", action);
        this.service.post(this.actionPath("control"), args);
        this.invalidate();
        return this;
    }

    public Job cancel() {
        try {
            return this.control("cancel");
        }
        catch (HttpException e) {
            if (e.getStatus() != 404) {
                throw e;
            }
            return this;
        }
    }

    private void checkReady() {
        if (!this.isReady()) {
            throw new SplunkException(1, "Job not yet scheduled by server");
        }
    }

    public Job disablePreview() {
        return this.control("disablepreview");
    }

    public Job enablePreview() {
        return this.control("enablepreview");
    }

    public Job finish() {
        return this.control("finalize");
    }

    public Job pause() {
        return this.control("pause");
    }

    public Date getCursorTime() {
        this.checkReady();
        return this.getDate("cursorTime");
    }

    public String getDelegate() {
        this.checkReady();
        return this.getString("delegate", null);
    }

    public int getDiskUsage() {
        this.checkReady();
        return this.getInteger("diskUsage");
    }

    public String getDispatchState() {
        this.checkReady();
        return this.getString("dispatchState");
    }

    public float getDoneProgress() {
        this.checkReady();
        return this.getFloat("doneProgress");
    }

    public int getDropCount() {
        this.checkReady();
        return this.getInteger("dropCount", 0);
    }

    public Date getEarliestTime() {
        this.checkReady();
        return this.getDate("earliestTime");
    }

    public int getEventAvailableCount() {
        this.checkReady();
        return this.getInteger("eventAvailableCount");
    }

    public int getEventCount() {
        this.checkReady();
        return this.getInteger("eventCount");
    }

    public int getEventFieldCount() {
        this.checkReady();
        return this.getInteger("eventFieldCount");
    }

    public boolean getEventIsStreaming() {
        this.checkReady();
        return this.getBoolean("eventIsStreaming");
    }

    public boolean getEventIsTruncated() {
        this.checkReady();
        return this.getBoolean("eventIsTruncated");
    }

    public InputStream getEvents() {
        this.checkReady();
        return this.getEvents(null);
    }

    public InputStream getEvents(Map args) {
        return this.getEventsMethod("/events", args);
    }

    public InputStream getEvents(JobEventsArgs args) {
        this.checkReady();
        return this.getEvents((Map)args);
    }

    public String getEventSearch() {
        this.checkReady();
        return this.getString("eventSearch", null);
    }

    public String getEventSorting() {
        this.checkReady();
        return this.getString("eventSorting");
    }

    private InputStream getEventsMethod(String methodPath, Map args) {
        this.checkReady();
        if (args == null) {
            args = new HashMap<String, Object>();
        }
        if (!args.containsKey("segmentation")) {
            args.put("segmentation", "none");
        }
        ResponseMessage response = this.service.get(this.path + methodPath, args);
        return response.getContent();
    }

    public String getKeywords() {
        this.checkReady();
        return this.getString("keywords", null);
    }

    public String getLabel() {
        this.checkReady();
        return this.getString("label", null);
    }

    public Date getLatestTime() {
        this.checkReady();
        return this.getDate("latestTime");
    }

    @Override
    public String getName() {
        this.checkReady();
        return this.getSid();
    }

    public int getNumPreviews() {
        this.checkReady();
        return this.getInteger("numPreviews");
    }

    public int getPriority() {
        this.checkReady();
        return this.getInteger("priority");
    }

    public void setPriority(int value) {
        this.checkReady();
        this.control("setpriority", new Args("priority", (Object)value));
    }

    public String getRemoteSearch() {
        this.checkReady();
        return this.getString("remoteSearch", null);
    }

    public String getReportSearch() {
        this.checkReady();
        return this.getString("reportSearch", null);
    }

    public int getResultCount() {
        this.checkReady();
        return this.getInteger("resultCount");
    }

    public boolean getResultIsStreaming() {
        this.checkReady();
        return this.getBoolean("resultIsStreaming");
    }

    public int getResultPreviewCount() {
        this.checkReady();
        return this.getInteger("resultPreviewCount");
    }

    public InputStream getResults() {
        this.checkReady();
        return this.getResults(null);
    }

    public InputStream getResults(Map args) {
        return this.getEventsMethod("/results", args);
    }

    public InputStream getResults(JobResultsArgs args) {
        this.checkReady();
        return this.getResults((Map)args);
    }

    public InputStream getResultsPreview() {
        this.checkReady();
        return this.getResultsPreview(null);
    }

    public InputStream getResultsPreview(Map args) {
        return this.getEventsMethod("/results_preview", args);
    }

    public InputStream getResultsPreview(JobResultsPreviewArgs args) {
        this.checkReady();
        return this.getResultsPreview((Map)args);
    }

    public float getRunDuration() {
        this.checkReady();
        return this.getFloat("runDuration");
    }

    public int getScanCount() {
        this.checkReady();
        return this.getInteger("scanCount");
    }

    public String getSearch() {
        this.checkReady();
        return this.getTitle();
    }

    public String getSearchEarliestTime() {
        this.checkReady();
        return this.getString("searchEarliestTime", null);
    }

    public String getSearchLatestTime() {
        this.checkReady();
        return this.getString("searchLatestTime", null);
    }

    public InputStream getSearchLog() {
        this.checkReady();
        return this.getSearchLog(null);
    }

    public InputStream getSearchLog(Map args) {
        this.checkReady();
        ResponseMessage response = this.service.get(this.path + "/search.log", args);
        return response.getContent();
    }

    public String[] getSearchProviders() {
        this.checkReady();
        return this.getStringArray("searchProviders", null);
    }

    public String getSid() {
        return this.getString("sid");
    }

    static String getSid(ResponseMessage response) {
        return Xml.parse(response.getContent()).getElementsByTagName("sid").item(0).getTextContent();
    }

    public InputStream getSummary() {
        this.checkReady();
        return this.getSummary(null);
    }

    public InputStream getSummary(Map args) {
        this.checkReady();
        ResponseMessage response = this.service.get(this.path + "/summary", args);
        return response.getContent();
    }

    public InputStream getSummary(JobSummaryArgs args) {
        this.checkReady();
        return this.getSummary((Map)args);
    }

    public int getStatusBuckets() {
        this.checkReady();
        return this.getInteger("statusBuckets");
    }

    public InputStream getTimeline() {
        this.checkReady();
        return this.getTimeline(null);
    }

    public InputStream getTimeline(Map args) {
        this.checkReady();
        ResponseMessage response = this.service.get(this.path + "/timeline", args);
        return response.getContent();
    }

    public int getTtl() {
        this.checkReady();
        return this.getInteger("ttl");
    }

    public boolean isDone() {
        if (!this.isReady()) {
            return false;
        }
        return this.getBoolean("isDone");
    }

    public boolean isFailed() {
        this.checkReady();
        return this.getBoolean("isFailed");
    }

    public boolean isFinalized() {
        this.checkReady();
        return this.getBoolean("isFinalized");
    }

    public boolean isPaused() {
        this.checkReady();
        return this.getBoolean("isPaused");
    }

    public boolean isPreviewEnabled() {
        this.checkReady();
        return this.getBoolean("isPreviewEnabled");
    }

    public boolean isReady() {
        if (!this.isReady) {
            this.refresh();
        }
        return this.isReady;
    }

    public boolean isRealTimeSearch() {
        this.checkReady();
        return this.getBoolean("isRealTimeSearch");
    }

    public boolean isRemoteTimeline() {
        this.checkReady();
        return this.getBoolean("isRemoteTimeline");
    }

    public boolean isSaved() {
        this.checkReady();
        return this.getBoolean("isSaved");
    }

    public boolean isSavedSearch() {
        this.checkReady();
        return this.getBoolean("isSavedSearch");
    }

    public boolean isZombie() {
        this.checkReady();
        return this.getBoolean("isZombie");
    }

    @Override
    public Job refresh() {
        AtomEntry entry;
        this.update();
        ResponseMessage response = this.service.get(this.path);
        if (response.getStatus() == 204) {
            this.isReady = false;
            return this;
        }
        try {
            entry = AtomEntry.parseStream(response.getContent());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.load(entry);
        this.isReady = !this.getString("dispatchState").equals("QUEUED") && !this.getString("dispatchState").equals("PARSING");
        return this;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

