/*
 * Decompiled with CFR 0.152.
 */
package com.splunk;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.splunk.DataModelObject;
import com.splunk.FieldType;
import com.splunk.PivotFilter;
import com.splunk.SortDirection;
import com.splunk.StatsFunction;
import com.splunk.Util;

public class LimitPivotFilter
extends PivotFilter {
    private final StatsFunction statsFunction;
    private final String sortAttribute;
    private final int limit;
    private final SortDirection sortDirection;

    LimitPivotFilter(DataModelObject dataModelObject, String fieldName, String sortAttribute, SortDirection sortDirection, int limit, StatsFunction statsFunction) {
        super(dataModelObject, fieldName);
        FieldType type = dataModelObject.getField(fieldName).getType();
        if (type != FieldType.NUMBER && type != FieldType.STRING && type != FieldType.OBJECTCOUNT) {
            throw new IllegalArgumentException("Field " + fieldName + " on the data model object was of type " + dataModelObject.getField(fieldName).getType().toString() + ", expected number, string, " + "or object count.");
        }
        this.sortAttribute = sortAttribute;
        this.sortDirection = sortDirection;
        this.limit = limit;
        if (type == FieldType.STRING && statsFunction != StatsFunction.COUNT && statsFunction != StatsFunction.DISTINCT_COUNT) {
            throw new IllegalArgumentException("Stats function for fields of type string must be COUNT or DISTINCT_COUNT; found " + statsFunction.toString());
        }
        if (type == FieldType.NUMBER && statsFunction != StatsFunction.COUNT && statsFunction != StatsFunction.DISTINCT_COUNT && statsFunction != StatsFunction.SUM && statsFunction != StatsFunction.AVERAGE) {
            throw new IllegalArgumentException("Stats function for fields of type number must be one of COUNT, DISTINCT_COUNT, SUM, or AVERAGE; found " + statsFunction.toString());
        }
        if (type == FieldType.OBJECTCOUNT && statsFunction != StatsFunction.COUNT) {
            throw new IllegalArgumentException("Stats function for fields of type object count must be COUNT; found " + statsFunction.toString());
        }
        this.statsFunction = statsFunction;
    }

    public String getAttributeName() {
        return this.sortAttribute;
    }

    public String[] getAttributeOwnerLineage() {
        return this.dataModelObject.getField(this.sortAttribute).getOwnerLineage();
    }

    public SortDirection getSortDirection() {
        return this.sortDirection;
    }

    public int getLimit() {
        return this.limit;
    }

    public StatsFunction getStatsFunction() {
        return this.statsFunction;
    }

    @Override
    JsonElement toJson() {
        JsonObject root = new JsonObject();
        this.addCommonFields(root);
        root.add("attributeName", new JsonPrimitive(this.getAttributeName()));
        root.add("attributeOwner", new JsonPrimitive(Util.join(".", this.getAttributeOwnerLineage())));
        if (this.sortDirection == SortDirection.ASCENDING) {
            root.add("limitType", new JsonPrimitive("lowest"));
        } else if (this.sortDirection == SortDirection.DESCENDING) {
            root.add("limitType", new JsonPrimitive("highest"));
        }
        root.add("limitAmount", new JsonPrimitive(this.limit));
        root.add("statsFn", new JsonPrimitive(this.statsFunction.toString()));
        return root;
    }
}

