/*
 * Decompiled with CFR 0.152.
 */
package com.splunk;

import com.splunk.Entity;
import com.splunk.ModularInputKindArgument;
import com.splunk.Service;
import java.util.HashMap;
import java.util.Map;

public class ModularInputKind
extends Entity {
    protected Map<String, Map<String, String>> args;

    ModularInputKind(Service service, String path) {
        super(service, path);
        Map endpoint = (Map)this.get("endpoint");
        this.args = (Map)endpoint.get("args");
    }

    public Map<String, ModularInputKindArgument> getArguments() {
        HashMap<String, ModularInputKindArgument> arguments = new HashMap<String, ModularInputKindArgument>();
        for (String argumentName : this.args.keySet()) {
            arguments.put(argumentName, this.getArgument(argumentName));
        }
        return arguments;
    }

    public String getStreamingMode() {
        String mode = this.getString("streaming_mode");
        return mode;
    }

    public ModularInputKindArgument getArgument(String argumentName) {
        if (this.args.get(argumentName) != null) {
            return new ModularInputKindArgument(this.args.get(argumentName));
        }
        return null;
    }

    public String getDescription() {
        return this.getString("description", null);
    }

    @Override
    public String getTitle() {
        return this.getString("title", null);
    }

    public boolean hasArgument(String argumentName) {
        return this.args.containsKey(argumentName);
    }
}

