/*
 * Decompiled with CFR 0.152.
 */
package com.splunk;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.splunk.DataModelObject;
import com.splunk.FieldType;
import com.splunk.NumberComparison;
import com.splunk.PivotFilter;

public class NumberPivotFilter
extends PivotFilter {
    private final NumberComparison comparison;
    private final double comparisonValue;

    NumberPivotFilter(DataModelObject dataModelObject, String field, NumberComparison comparison, double comparisonValue) {
        super(dataModelObject, field);
        if (dataModelObject.getField(field).getType() != FieldType.NUMBER) {
            throw new IllegalArgumentException("Field " + field + " on the data model object was of type " + dataModelObject.getField(field).getType().toString() + ", expected number.");
        }
        this.comparison = comparison;
        this.comparisonValue = comparisonValue;
    }

    @Override
    JsonElement toJson() {
        JsonObject root = new JsonObject();
        this.addCommonFields(root);
        root.add("comparator", new JsonPrimitive(this.comparison.toString()));
        root.add("compareTo", new JsonPrimitive(this.comparisonValue));
        return root;
    }
}

