/*
 * Decompiled with CFR 0.152.
 */
package com.splunk;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.splunk.DataModelField;
import com.splunk.DataModelObject;
import com.splunk.Util;

public abstract class PivotRowSplit {
    private final String fieldName;
    private final DataModelObject dataModelObject;
    private final String label;

    PivotRowSplit(DataModelObject dataModelObject, String fieldName, String label) {
        this.fieldName = fieldName;
        this.dataModelObject = dataModelObject;
        this.label = label;
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public String getOwnerName() {
        return this.dataModelObject.getField(this.fieldName).getOwnerName();
    }

    public String[] getOwnerLineage() {
        return this.dataModelObject.getField(this.fieldName).getOwnerLineage();
    }

    public String getLabel() {
        return this.label;
    }

    protected void addCommonFields(JsonObject obj) {
        DataModelField field = this.dataModelObject.getField(this.fieldName);
        obj.addProperty("fieldName", this.fieldName);
        obj.addProperty("owner", Util.join(".", field.getOwnerLineage()));
        obj.addProperty("type", field.getType().toString());
        obj.addProperty("label", this.label);
    }

    abstract JsonElement toJson();
}

