/*
 * Decompiled with CFR 0.152.
 */
package com.splunk;

import com.splunk.Application;
import com.splunk.Args;
import com.splunk.BaseService;
import com.splunk.CollectionArgs;
import com.splunk.ConfCollection;
import com.splunk.DataModelCollection;
import com.splunk.DeploymentClient;
import com.splunk.DeploymentServer;
import com.splunk.DeploymentServerClass;
import com.splunk.DeploymentTenant;
import com.splunk.DistributedConfiguration;
import com.splunk.DistributedPeer;
import com.splunk.Entity;
import com.splunk.EntityCollection;
import com.splunk.EventTypeCollection;
import com.splunk.ExportResultsStream;
import com.splunk.FiredAlertGroupCollection;
import com.splunk.IndexCollection;
import com.splunk.IndexCollectionArgs;
import com.splunk.InputCollection;
import com.splunk.Job;
import com.splunk.JobCollection;
import com.splunk.JobExportArgs;
import com.splunk.License;
import com.splunk.LicenseGroup;
import com.splunk.LicenseMessage;
import com.splunk.LicensePoolCollection;
import com.splunk.LicenseSlave;
import com.splunk.LicenseStack;
import com.splunk.Logger;
import com.splunk.MessageCollection;
import com.splunk.ModularInputKind;
import com.splunk.OutputDefault;
import com.splunk.OutputGroup;
import com.splunk.OutputServer;
import com.splunk.OutputSyslog;
import com.splunk.PasswordCollection;
import com.splunk.Receiver;
import com.splunk.RequestMessage;
import com.splunk.ResourceCollection;
import com.splunk.ResponseMessage;
import com.splunk.Role;
import com.splunk.SavedSearchCollection;
import com.splunk.SavedSearchCollectionArgs;
import com.splunk.ServiceArgs;
import com.splunk.ServiceInfo;
import com.splunk.Settings;
import com.splunk.Upload;
import com.splunk.UserCollection;
import com.splunk.Xml;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;
import java.net.URLEncoder;
import java.net.URLStreamHandler;
import java.util.Map;

public class Service
extends BaseService {
    protected String app = null;
    protected String token = null;
    protected String owner = null;
    protected String username = null;
    protected String password = null;
    protected String simpleReceiverEndPoint = "receivers/simple";
    protected String passwordEndPoint = "admin/passwords";
    public String version = null;
    public static String DEFAULT_HOST = "localhost";
    public static int DEFAULT_PORT = 8089;
    public static String DEFAULT_SCHEME = "https";

    public Service(String host) {
        super(host);
    }

    public Service(String host, int port) {
        super(host, port);
    }

    public Service(String host, int port, String scheme) {
        super(host, port, scheme);
    }

    public Service(String host, int port, String scheme, URLStreamHandler httpsHandler) {
        this.host = host;
        this.port = port;
        this.scheme = scheme;
        this.httpsHandler = httpsHandler;
    }

    public Service(ServiceArgs args) {
        this.app = Args.get(args, "app", args.app != null ? args.app : null);
        this.host = Args.get(args, "host", args.host != null ? args.host : DEFAULT_HOST);
        this.owner = Args.get(args, "owner", args.owner != null ? args.owner : null);
        this.port = Args.get(args, "port", args.port != null ? args.port : DEFAULT_PORT);
        this.scheme = Args.get(args, "scheme", args.scheme != null ? args.scheme : DEFAULT_SCHEME);
        this.token = Args.get(args, "token", args.token != null ? args.token : null);
        this.username = (String)args.get("username");
        this.password = (String)args.get("password");
        this.httpsHandler = Args.get(args, "httpsHandler", null);
    }

    public Service(Map<String, Object> args) {
        this.app = Args.get(args, "app", null);
        this.host = Args.get(args, "host", DEFAULT_HOST);
        this.owner = Args.get(args, "owner", null);
        this.port = Args.get(args, "port", DEFAULT_PORT);
        this.scheme = Args.get(args, "scheme", DEFAULT_SCHEME);
        this.token = Args.get(args, "token", null);
        this.username = (String)args.get("username");
        this.password = (String)args.get("password");
        this.httpsHandler = Args.get(args, "httpsHandler", null);
    }

    public static Service connect(Map<String, Object> args) {
        Service service = new Service(args);
        if (args.containsKey("username")) {
            service.login();
        }
        return service;
    }

    public InputStream export(String search) {
        return this.export(search, null);
    }

    public InputStream export(String search, Map args) {
        if (!(args = Args.create(args).add("search", search)).containsKey("segmentation")) {
            args.put("segmentation", "none");
        }
        ResponseMessage response = this.get("search/jobs/export", args);
        return new ExportResultsStream(response.getContent());
    }

    public InputStream export(String search, JobExportArgs args) {
        return this.export(search, (Map)args);
    }

    String fullpath(String path) {
        return this.fullpath(path, null);
    }

    public String fullpath(String path, Args namespace) {
        if (path.startsWith("/")) {
            return path;
        }
        if (namespace == null && this.app == null) {
            return "/services/" + path;
        }
        String localApp = this.app;
        String localOwner = this.owner;
        String localSharing = "";
        if (namespace != null) {
            block14: {
                block13: {
                    if (namespace.containsKey("app")) {
                        try {
                            localApp = URLEncoder.encode((String)namespace.get("app"), "UTF-8");
                        }
                        catch (UnsupportedEncodingException e) {
                            if ($assertionsDisabled) break block13;
                            throw new AssertionError();
                        }
                    }
                }
                if (namespace.containsKey("owner")) {
                    try {
                        localOwner = URLEncoder.encode((String)namespace.get("owner"), "UTF-8");
                    }
                    catch (UnsupportedEncodingException e) {
                        if ($assertionsDisabled) break block14;
                        throw new AssertionError();
                    }
                }
            }
            if (namespace.containsKey("sharing")) {
                localSharing = (String)namespace.get("sharing");
            }
        }
        if (localSharing.equals("app") || localSharing.equals("global")) {
            localOwner = "nobody";
        } else if (localSharing.equals("system")) {
            localApp = "system";
            localOwner = "nobody";
        }
        return String.format("/servicesNS/%s/%s/%s", localOwner == null ? "-" : localOwner, localApp == null ? "-" : localApp, path);
    }

    public String getApp() {
        return this.app;
    }

    public EntityCollection<Application> getApplications() {
        return new EntityCollection<Application>(this, "/services/apps/local", Application.class);
    }

    public ConfCollection getConfs() {
        return this.getConfs(null);
    }

    public ConfCollection getConfs(Args args) {
        return new ConfCollection(this, args);
    }

    public String[] getCapabilities() {
        Entity caps = new Entity(this, "authorization/capabilities");
        return caps.getStringArray("capabilities");
    }

    public DataModelCollection getDataModels() {
        return new DataModelCollection(this);
    }

    public DeploymentClient getDeploymentClient() {
        return new DeploymentClient(this);
    }

    public EntityCollection<DeploymentServer> getDeploymentServers() {
        return this.getDeploymentServers(null);
    }

    public EntityCollection<DeploymentServer> getDeploymentServers(Args args) {
        if (this.versionIsEarlierThan("6.0.0")) {
            String path = "deployment/server";
        } else {
            String path = "";
        }
        return new EntityCollection<DeploymentServer>(this, "deployment/server", DeploymentServer.class, args);
    }

    public EntityCollection<DeploymentServerClass> getDeploymentServerClasses() {
        return this.getDeploymentServerClasses(null);
    }

    public EntityCollection<DeploymentServerClass> getDeploymentServerClasses(Args args) {
        String path = this.versionIsEarlierThan("6.0.0") ? "deployment/serverclass" : "deployment/server/serverclasses";
        return new EntityCollection<DeploymentServerClass>(this, path, DeploymentServerClass.class, args);
    }

    public EntityCollection<DeploymentTenant> getDeploymentTenants() {
        return this.getDeploymentTenants(null);
    }

    public EntityCollection<DeploymentTenant> getDeploymentTenants(Args args) {
        return new EntityCollection<DeploymentTenant>(this, "deployment/tenants", DeploymentTenant.class, args);
    }

    public DistributedConfiguration getDistributedConfiguration() {
        return new DistributedConfiguration(this);
    }

    public EntityCollection<DistributedPeer> getDistributedPeers() {
        return this.getDistributedPeers(null);
    }

    public EntityCollection<DistributedPeer> getDistributedPeers(Args args) {
        return new EntityCollection<DistributedPeer>(this, "search/distributed/peers", DistributedPeer.class, args);
    }

    public EventTypeCollection getEventTypes() {
        return this.getEventTypes(null);
    }

    public EventTypeCollection getEventTypes(Args args) {
        return new EventTypeCollection(this, args);
    }

    public FiredAlertGroupCollection getFiredAlertGroups() {
        return this.getFiredAlertsGroups(null);
    }

    public FiredAlertGroupCollection getFiredAlertsGroups(Args args) {
        return new FiredAlertGroupCollection(this, args);
    }

    public IndexCollection getIndexes() {
        return this.getIndexes((IndexCollectionArgs)null);
    }

    public IndexCollection getIndexes(IndexCollectionArgs args) {
        return this.getIndexes((Args)args);
    }

    public IndexCollection getIndexes(Args args) {
        return new IndexCollection(this, args);
    }

    public ServiceInfo getInfo() {
        return new ServiceInfo(this);
    }

    public InputCollection getInputs() {
        return this.getInputs(null);
    }

    public InputCollection getInputs(Args args) {
        return new InputCollection(this, args);
    }

    public JobCollection getJobs() {
        return this.getJobs((CollectionArgs)null);
    }

    public JobCollection getJobs(CollectionArgs args) {
        return this.getJobs((Args)args);
    }

    public JobCollection getJobs(Args args) {
        return new JobCollection(this, args);
    }

    public Job getJob(String sid) {
        return new Job(this, "search/jobs/" + sid);
    }

    public EntityCollection<LicenseGroup> getLicenseGroups() {
        return this.getLicenseGroups(null);
    }

    public EntityCollection<LicenseGroup> getLicenseGroups(Args args) {
        return new EntityCollection<LicenseGroup>(this, "licenser/groups", LicenseGroup.class, args);
    }

    public EntityCollection<LicenseMessage> getLicenseMessages() {
        return this.getLicenseMessages(null);
    }

    public EntityCollection<LicenseMessage> getLicenseMessages(Args args) {
        return new EntityCollection<LicenseMessage>(this, "licenser/messages", LicenseMessage.class, args);
    }

    public String getOwner() {
        return this.owner;
    }

    public LicensePoolCollection getLicensePools() {
        return this.getLicensePools(null);
    }

    public LicensePoolCollection getLicensePools(Args args) {
        return new LicensePoolCollection(this, args);
    }

    public EntityCollection<LicenseSlave> getLicenseSlaves() {
        return this.getLicenseSlaves(null);
    }

    public EntityCollection<LicenseSlave> getLicenseSlaves(Args args) {
        return new EntityCollection<LicenseSlave>(this, "licenser/slaves", LicenseSlave.class, args);
    }

    public EntityCollection<LicenseStack> getLicenseStacks() {
        return this.getLicenseStacks(null);
    }

    public EntityCollection<LicenseStack> getLicenseStacks(Args args) {
        return new EntityCollection<LicenseStack>(this, "licenser/stacks", LicenseStack.class, args);
    }

    public EntityCollection<License> getLicenses() {
        return this.getLicenses(null);
    }

    public EntityCollection<License> getLicenses(Args args) {
        return new EntityCollection<License>(this, "licenser/licenses", License.class, args);
    }

    public EntityCollection<Logger> getLoggers() {
        return this.getLoggers(null);
    }

    public EntityCollection<Logger> getLoggers(Args args) {
        return new EntityCollection<Logger>(this, "server/logger", Logger.class, args);
    }

    public MessageCollection getMessages() {
        return this.getMessages(null);
    }

    public MessageCollection getMessages(Args args) {
        return new MessageCollection(this, args);
    }

    public ResourceCollection<ModularInputKind> getModularInputKinds() {
        return this.getModularInputKinds(null);
    }

    public ResourceCollection<ModularInputKind> getModularInputKinds(Args args) {
        return new ResourceCollection<ModularInputKind>(this, "data/modular-inputs", ModularInputKind.class, args);
    }

    public OutputDefault getOutputDefault() {
        return new OutputDefault(this);
    }

    public EntityCollection<OutputGroup> getOutputGroups() {
        return this.getOutputGroups(null);
    }

    public EntityCollection<OutputGroup> getOutputGroups(Args args) {
        return new EntityCollection<OutputGroup>(this, "data/outputs/tcp/group", OutputGroup.class, args);
    }

    public EntityCollection<OutputServer> getOutputServers() {
        return this.getOutputServers(null);
    }

    public EntityCollection<OutputServer> getOutputServers(Args args) {
        return new EntityCollection<OutputServer>(this, "data/outputs/tcp/server", OutputServer.class, args);
    }

    public EntityCollection<OutputSyslog> getOutputSyslogs() {
        return this.getOutputSyslogs(null);
    }

    public EntityCollection<OutputSyslog> getOutputSyslogs(Args args) {
        return new EntityCollection<OutputSyslog>(this, "data/outputs/tcp/syslog", OutputSyslog.class, args);
    }

    public String getPassword() {
        return this.password;
    }

    public PasswordCollection getPasswords() {
        return this.getPasswords(null);
    }

    public PasswordCollection getPasswords(Args args) {
        return new PasswordCollection(this, args);
    }

    public Receiver getReceiver() {
        return new Receiver(this);
    }

    public EntityCollection<Role> getRoles() {
        return this.getRoles(null);
    }

    public EntityCollection<Role> getRoles(Args args) {
        return new EntityCollection<Role>(this, "authorization/roles", Role.class, args);
    }

    public SavedSearchCollection getSavedSearches() {
        return this.getSavedSearches((SavedSearchCollectionArgs)null);
    }

    public SavedSearchCollection getSavedSearches(SavedSearchCollectionArgs args) {
        return this.getSavedSearches((Args)args);
    }

    public SavedSearchCollection getSavedSearches(Args args) {
        return new SavedSearchCollection(this, args);
    }

    public Settings getSettings() {
        return new Settings(this);
    }

    public String getToken() {
        return this.token;
    }

    public EntityCollection<Upload> getUploads() {
        return this.getUploads(null);
    }

    public EntityCollection<Upload> getUploads(Args namespace) {
        return new EntityCollection<Upload>(this, "data/inputs/oneshot", Upload.class, namespace);
    }

    public String getUsername() {
        return this.username;
    }

    public UserCollection getUsers() {
        return this.getUsers(null);
    }

    public UserCollection getUsers(Args args) {
        return new UserCollection(this, args);
    }

    public Service login() {
        if (this.username == null || this.password == null) {
            throw new IllegalStateException("Missing username or password.");
        }
        return this.login(this.username, this.password);
    }

    public Service login(String username, String password) {
        this.username = username;
        this.password = password;
        Args args = new Args();
        args.put("username", username);
        args.put("password", password);
        ResponseMessage response = this.post("/services/auth/login", args);
        String sessionKey = Xml.parse(response.getContent()).getElementsByTagName("sessionKey").item(0).getTextContent();
        this.token = "Splunk " + sessionKey;
        this.version = this.getInfo().getVersion();
        if (this.versionCompare("4.3") >= 0) {
            this.passwordEndPoint = "storage/passwords";
        }
        return this;
    }

    public Service logout() {
        this.token = null;
        return this;
    }

    public InputStream oneshotSearch(String query) {
        return this.oneshotSearch(query, null);
    }

    public InputStream oneshotSearch(String query, Map args) {
        args = Args.create(args);
        args.put("search", query);
        args.put("exec_mode", "oneshot");
        if (!args.containsKey("segmentation")) {
            args.put("segmentation", "none");
        }
        ResponseMessage response = this.post("search/jobs", args);
        return response.getContent();
    }

    public InputStream oneshotSearch(String query, Args args) {
        return this.oneshotSearch(query, (Map)args);
    }

    public Socket open(int port) throws IOException {
        return new Socket(this.host, port);
    }

    public ResponseMessage parse(String query) {
        return this.parse(query, null);
    }

    public ResponseMessage parse(String query, Map args) {
        args = Args.create(args).add("q", query);
        return this.get("search/parser", args);
    }

    public ResponseMessage restart() {
        return this.post("server/control/restart");
    }

    public Job search(String query) {
        return this.search(query, null);
    }

    public Job search(String query, Map<String, Object> args) {
        args = Args.create(args);
        return this.getJobs().create(query, args);
    }

    @Override
    public ResponseMessage send(String path, RequestMessage request) {
        if (this.token != null) {
            request.getHeader().put("Authorization", this.token);
        }
        return super.send(this.fullpath(path), request);
    }

    public void setToken(String value) {
        this.token = value;
    }

    boolean versionIsAtLeast(String version) {
        return this.versionCompare(version) >= 0;
    }

    boolean versionIsEarlierThan(String version) {
        return this.versionCompare(version) < 0;
    }

    public int versionCompare(String otherVersion) {
        String[] components1 = this.version.split("\\.");
        String[] components2 = otherVersion.split("\\.");
        int numComponents = Math.max(components1.length, components2.length);
        for (int i = 0; i < numComponents; ++i) {
            int c2;
            int c1 = i < components1.length ? Integer.parseInt(components1[i], 10) : 0;
            int n = c2 = i < components2.length ? Integer.parseInt(components2[i], 10) : 0;
            if (c1 < c2) {
                return -1;
            }
            if (c1 <= c2) continue;
            return 1;
        }
        return 0;
    }
}

