/*
 * Decompiled with CFR 0.152.
 */
package com.splunk;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

class Value {
    private static SimpleDateFormat[] dateFormat = null;
    private static Pattern datePattern = null;

    Value() {
    }

    static boolean toBoolean(String value) {
        if (value == null) {
            return false;
        }
        if (value.equals("0")) {
            return false;
        }
        if (value.equals("1")) {
            return true;
        }
        if (value.toLowerCase().equals("false")) {
            return false;
        }
        if (value.toLowerCase().equals("true")) {
            return true;
        }
        String message = String.format("Value error: '%s'", value);
        throw new RuntimeException(message);
    }

    static long toByteCount(String value) {
        long multiplier = 1L;
        if (value.endsWith("B")) {
            if (value.endsWith("KB")) {
                multiplier = 1024L;
            } else if (value.endsWith("MB")) {
                multiplier = 0x100000L;
            } else if (value.endsWith("GB")) {
                multiplier = 0x40000000L;
            } else {
                String message = String.format("Value error: '%s'", value);
                throw new RuntimeException(message);
            }
            value = value.substring(0, value.length() - 2);
        }
        return Long.parseLong(value) * multiplier;
    }

    static Date toDate(String value) {
        if (dateFormat == null) {
            dateFormat = new SimpleDateFormat[4];
            Value.dateFormat[0] = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
            dateFormat[0].setLenient(true);
            Value.dateFormat[1] = new SimpleDateFormat("E MMM d HH:mm:ss z y");
            dateFormat[1].setLenient(true);
            Value.dateFormat[2] = new SimpleDateFormat("EEE MMM dd HH:mm:ss y");
            dateFormat[2].setLenient(true);
            Value.dateFormat[3] = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss Z");
            dateFormat[3].setLenient(true);
        }
        if (datePattern == null) {
            String pattern = "(.*)\\.\\d+([\\-+]\\d+):(\\d+)";
            datePattern = Pattern.compile(pattern);
        }
        for (SimpleDateFormat simpleDateFormat : dateFormat) {
            try {
                Matcher matcher = datePattern.matcher(value);
                value = matcher.replaceAll("$1$2$3");
                return simpleDateFormat.parse(value);
            }
            catch (ParseException e) {
            }
        }
        try {
            return new Date(Long.parseLong(value) * 1000L);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    static float toFloat(String value) {
        return Float.parseFloat(value);
    }

    static int toInteger(String value) {
        return Integer.parseInt(value);
    }

    static long toLong(String value) {
        return Long.parseLong(value);
    }
}

