/*
 * Decompiled with CFR 0.152.
 */
package com.splunk;

import com.google.gson.JsonElement;
import com.splunk.FieldType;
import java.util.Map;

public class DataModelField {
    private String[] ownerLineage;
    private String name;
    private FieldType type;
    private boolean required;
    private boolean multivalued;
    private boolean hidden;
    private String displayName;
    private String comment;
    private boolean editable;
    private String fieldSearch;

    private DataModelField() {
    }

    public String getFieldSearch() {
        return this.fieldSearch;
    }

    public String getName() {
        return this.name;
    }

    public String getOwnerName() {
        return this.ownerLineage[this.ownerLineage.length - 1];
    }

    public String[] getOwnerLineage() {
        return this.ownerLineage;
    }

    public FieldType getType() {
        return this.type;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public boolean isRequired() {
        return this.required;
    }

    public boolean isMultivalued() {
        return this.multivalued;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getComment() {
        return this.comment;
    }

    public static DataModelField parse(JsonElement fieldJson) {
        DataModelField field = new DataModelField();
        for (Map.Entry<String, JsonElement> entry : fieldJson.getAsJsonObject().entrySet()) {
            if (entry.getKey().equals("fieldName")) {
                field.name = entry.getValue().getAsString();
                continue;
            }
            if (entry.getKey().equals("owner")) {
                field.ownerLineage = entry.getValue().getAsString().split("\\.");
                continue;
            }
            if (entry.getKey().equals("type")) {
                field.type = FieldType.parseType(entry.getValue().getAsString());
                continue;
            }
            if (entry.getKey().equals("required")) {
                field.required = entry.getValue().getAsBoolean();
                continue;
            }
            if (entry.getKey().equals("multivalue")) {
                field.multivalued = entry.getValue().getAsBoolean();
                continue;
            }
            if (entry.getKey().equals("hidden")) {
                field.hidden = entry.getValue().getAsBoolean();
                continue;
            }
            if (entry.getKey().equals("displayName")) {
                field.displayName = entry.getValue().getAsString();
                continue;
            }
            if (entry.getKey().equals("comment")) {
                field.comment = entry.getValue().getAsString();
                continue;
            }
            if (entry.getKey().equals("editable")) {
                field.editable = entry.getValue().getAsBoolean();
                continue;
            }
            if (!entry.getKey().equals("fieldSearch")) continue;
            field.fieldSearch = entry.getValue().getAsString();
        }
        return field;
    }
}

