/*
 * Decompiled with CFR 0.152.
 */
package com.splunk;

import com.google.gson.JsonObject;
import com.splunk.DataModelField;
import com.splunk.DataModelObject;
import com.splunk.FieldType;
import com.splunk.StatsFunction;
import com.splunk.Util;

public class PivotCellValue {
    private final String fieldName;
    private final DataModelObject dataModelObject;
    private final String label;
    private final StatsFunction statsFunction;

    PivotCellValue(DataModelObject dataModelObject, String fieldName, String label, StatsFunction statsFunction) {
        this.fieldName = fieldName;
        this.dataModelObject = dataModelObject;
        this.label = label;
        this.statsFunction = statsFunction;
        if (!dataModelObject.containsField(fieldName)) {
            throw new IllegalArgumentException("No such field named " + fieldName + " on data model object.");
        }
        FieldType t = dataModelObject.getField(fieldName).getType();
        if ((t == FieldType.STRING || t == FieldType.IPV4) && statsFunction != StatsFunction.LIST && statsFunction != StatsFunction.DISTINCT_VALUES && statsFunction != StatsFunction.FIRST && statsFunction != StatsFunction.LAST && statsFunction != StatsFunction.COUNT && statsFunction != StatsFunction.DISTINCT_COUNT) {
            throw new IllegalArgumentException("Stats function on string and IPv4 field must be one of list, distinct_values, first, last, count, or distinct_count; found " + statsFunction.toString());
        }
        if (t == FieldType.NUMBER && statsFunction != StatsFunction.SUM && statsFunction != StatsFunction.COUNT && statsFunction != StatsFunction.AVERAGE && statsFunction != StatsFunction.MAX && statsFunction != StatsFunction.MIN && statsFunction != StatsFunction.STDEV && statsFunction != StatsFunction.LIST && statsFunction != StatsFunction.DISTINCT_VALUES) {
            throw new IllegalArgumentException("Stats function on number field must be one of sum, count, average, max, min, stdev, list, or distinct_values; found " + statsFunction.toString());
        }
        if (t == FieldType.TIMESTAMP && statsFunction != StatsFunction.DURATION && statsFunction != StatsFunction.EARLIEST && statsFunction != StatsFunction.LATEST && statsFunction != StatsFunction.LIST && statsFunction != StatsFunction.DISTINCT_VALUES) {
            throw new IllegalArgumentException("Stats function on timestamp field must be one of duration, earliest, latest, list, or distinct_values; found " + statsFunction.toString());
        }
        if ((t == FieldType.CHILDCOUNT || t == FieldType.OBJECTCOUNT) && statsFunction != StatsFunction.COUNT) {
            throw new IllegalArgumentException("Stats function on childcount and objectcount fields must be count; ; found " + statsFunction.toString());
        }
        if (t == FieldType.BOOLEAN) {
            throw new IllegalArgumentException("Cannot use boolean valued fields as cell values.");
        }
    }

    public String getFieldName() {
        return this.fieldName;
    }

    public DataModelObject getOwner() {
        return this.dataModelObject;
    }

    public String getLabel() {
        return this.label;
    }

    public StatsFunction getStatsFunction() {
        return this.statsFunction;
    }

    JsonObject toJson() {
        JsonObject root = new JsonObject();
        DataModelField f = this.dataModelObject.getField(this.fieldName);
        root.addProperty("fieldName", this.fieldName);
        root.addProperty("owner", Util.join(".", f.getOwnerLineage()));
        root.addProperty("type", f.getType().toString());
        root.addProperty("label", this.label);
        root.addProperty("sparkline", false);
        root.addProperty("value", this.statsFunction.toString());
        return root;
    }
}

