/*
 * Decompiled with CFR 0.152.
 */
package com.splunk;

import com.splunk.Event;
import com.splunk.InsertRootElementFilterInputStream;
import com.splunk.ResultsReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class ResultsReaderXml
extends ResultsReader {
    private XMLEventReader xmlReader = null;
    private ArrayList<String> fields = new ArrayList();
    private PushbackInputStream pushbackInputStream;

    public ResultsReaderXml(InputStream inputStream) throws IOException {
        this(inputStream, false);
    }

    ResultsReaderXml(InputStream inputStream, boolean isInMultiReader) throws IOException {
        super(inputStream, isInMultiReader);
        this.pushbackInputStream = new PushbackInputStream(inputStream);
        XMLInputFactory inputFactory = XMLInputFactory.newInstance();
        int ch = this.pushbackInputStream.read();
        if (ch == -1) {
            return;
        }
        this.pushbackInputStream.unread(ch);
        inputFactory.setProperty("javax.xml.stream.isCoalescing", true);
        try {
            InsertRootElementFilterInputStream filteredStream = new InsertRootElementFilterInputStream(this.pushbackInputStream);
            this.xmlReader = inputFactory.createXMLEventReader(filteredStream);
            this.finishInitialization();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void close() throws IOException {
        if (this.xmlReader != null) {
            try {
                this.xmlReader.close();
            }
            catch (XMLStreamException e) {
                throw new RuntimeException(e);
            }
        }
        this.xmlReader = null;
        super.close();
    }

    @Override
    public boolean isPreview() {
        return this.isPreview;
    }

    @Override
    public Collection<String> getFields() {
        return this.fields;
    }

    @Override
    Event getNextEventInCurrentSet() throws IOException {
        if (this.xmlReader == null) {
            return null;
        }
        try {
            Event event = null;
            XMLEvent xmlEvent = this.readToStartOfElementAtSameLevelWithName("result");
            if (xmlEvent != null) {
                event = this.getResultKVPairs();
            }
            return event;
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    boolean readIntoNextResultsElement() throws XMLStreamException, IOException {
        XMLEvent xmlEvent = this.readToStartOfElementWithName("results");
        if (xmlEvent == null) {
            return false;
        }
        this.isPreview = xmlEvent == null || !xmlEvent.asStartElement().getAttributeByName(QName.valueOf("preview")).getValue().equals("0");
        String meta = "meta";
        if (this.readToStartOfElementAtSameLevelWithName("meta") != null) {
            this.readFieldOrderElement();
            this.readToEndElementWithName("meta");
        }
        return true;
    }

    XMLEvent readToStartOfElementWithName(String elementName) throws XMLStreamException {
        while (this.xmlReader.hasNext()) {
            StartElement startElement;
            XMLEvent xmlEvent = this.xmlReader.nextEvent();
            int eType = xmlEvent.getEventType();
            if (eType != 1 || !(startElement = xmlEvent.asStartElement()).getName().getLocalPart().equals(elementName)) continue;
            return xmlEvent;
        }
        return null;
    }

    void readToEndElementWithName(String elementName) throws XMLStreamException {
        block4: while (this.xmlReader.hasNext()) {
            XMLEvent xmlEvent = this.xmlReader.nextEvent();
            int eType = xmlEvent.getEventType();
            switch (eType) {
                case 1: {
                    continue block4;
                }
                case 2: {
                    if (!xmlEvent.asEndElement().getName().getLocalPart().equals(elementName)) continue block4;
                    return;
                }
            }
        }
        throw new RuntimeException("End tag of " + elementName + " not found.");
    }

    XMLEvent readToStartOfElementAtSameLevelWithName(String elementName) throws XMLStreamException {
        int level = 0;
        while (this.xmlReader.hasNext()) {
            XMLEvent xmlEvent = this.xmlReader.peek();
            int eType = xmlEvent.getEventType();
            switch (eType) {
                case 1: {
                    StartElement startElement;
                    if (level++ > 0 || !(startElement = xmlEvent.asStartElement()).getName().getLocalPart().equals(elementName)) break;
                    this.xmlReader.nextEvent();
                    return xmlEvent;
                }
                case 2: {
                    if (level-- != 0) break;
                    return null;
                }
            }
            this.xmlReader.nextEvent();
        }
        throw new RuntimeException("Parent end element not found:" + elementName);
    }

    private void readFieldOrderElement() throws IOException, XMLStreamException {
        int level = 0;
        if (this.readToStartOfElementAtSameLevelWithName("fieldOrder") == null) {
            return;
        }
        block5: while (this.xmlReader.hasNext()) {
            XMLEvent xmlEvent = this.xmlReader.nextEvent();
            int eType = xmlEvent.getEventType();
            switch (eType) {
                case 1: {
                    ++level;
                    continue block5;
                }
                case 2: {
                    if (xmlEvent.asEndElement().getName().getLocalPart().equals("fieldOrder")) {
                        return;
                    }
                    --level;
                    continue block5;
                }
                case 4: {
                    if (level != 1) continue block5;
                    this.fields.add(xmlEvent.asCharacters().getData());
                    continue block5;
                }
            }
        }
        throw new RuntimeException("End tag of fieldOrder not found.");
    }

    private Event getResultKVPairs() throws IOException, XMLStreamException {
        Event returnData = new Event();
        String key = null;
        ArrayList<String> values = new ArrayList<String>();
        int level = 0;
        while (this.xmlReader.hasNext()) {
            XMLEvent xmlEvent = this.xmlReader.nextEvent();
            int eType = xmlEvent.getEventType();
            switch (eType) {
                case 1: {
                    StartElement startElement = xmlEvent.asStartElement();
                    Iterator<Attribute> attrIttr = startElement.getAttributes();
                    if (level == 0) {
                        if (attrIttr.hasNext()) {
                            key = attrIttr.next().getValue();
                        }
                    } else if (level == 1 && key.equals("_raw") && startElement.getName().getLocalPart().equals("v")) {
                        StringBuilder asString = new StringBuilder();
                        StringWriter asXml = new StringWriter();
                        this.readSubtree(startElement, asString, asXml);
                        values.add(asString.toString());
                        returnData.putSegmentedRaw(asXml.toString());
                        --level;
                    }
                    ++level;
                    break;
                }
                case 2: {
                    if (xmlEvent.asEndElement().getName().getLocalPart().equals("result")) {
                        return returnData;
                    }
                    if (--level != 0) break;
                    String[] valuesArray = values.toArray(new String[values.size()]);
                    returnData.putArray(key, valuesArray);
                    key = null;
                    values.clear();
                    break;
                }
                case 4: {
                    if (level <= true) break;
                    values.add(xmlEvent.asCharacters().getData());
                    break;
                }
            }
        }
        throw new RuntimeException("End tag of 'result' not found.");
    }

    @Override
    boolean advanceStreamToNextSet() throws IOException {
        if (this.xmlReader == null) {
            return false;
        }
        try {
            return this.readIntoNextResultsElement();
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
        catch (NullPointerException e) {
            return false;
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return false;
        }
    }

    void readSubtree(StartElement startElement, StringBuilder asString, StringWriter asXml) throws IOException, XMLStreamException {
        XMLEventWriter xmlWriter = XMLOutputFactory.newInstance().createXMLEventWriter(asXml);
        XMLEvent xmlEvent = startElement;
        int level = 0;
        do {
            xmlWriter.add(xmlEvent);
            int eType = xmlEvent.getEventType();
            switch (eType) {
                case 1: {
                    ++level;
                    break;
                }
                case 2: {
                    if (--level != 0) break;
                    xmlWriter.close();
                    return;
                }
                case 4: {
                    asString.append(xmlEvent.asCharacters().getData());
                }
            }
            xmlEvent = this.xmlReader.nextEvent();
        } while (this.xmlReader.hasNext());
        throw new RuntimeException("Invalid XML format.");
    }
}

