/*
 * Decompiled with CFR 0.152.
 */
package com.splunk;

import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;

abstract class StreamIterableBase<T>
implements Iterable<T> {
    private T cachedElement;
    private boolean nextElementCached;

    StreamIterableBase() {
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){

            @Override
            public boolean hasNext() {
                StreamIterableBase.this.cacheNextElement();
                return StreamIterableBase.this.cachedElement != null;
            }

            @Override
            public T next() {
                StreamIterableBase.this.cacheNextElement();
                if (StreamIterableBase.this.cachedElement == null) {
                    throw new NoSuchElementException();
                }
                StreamIterableBase.this.nextElementCached = false;
                return StreamIterableBase.this.cachedElement;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    abstract T getNextElement() throws IOException;

    void resetIteration(boolean hasMoreResults) {
        this.cachedElement = null;
        this.nextElementCached = !hasMoreResults;
    }

    private void cacheNextElement() {
        if (!this.nextElementCached) {
            try {
                this.cachedElement = this.getNextElement();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            this.nextElementCached = true;
        }
    }
}

