/*
 * Decompiled with CFR 0.152.
 */
package com.splunk.modularinput;

import com.splunk.modularinput.MalformedDataException;
import com.splunk.modularinput.MultiValueParameter;
import com.splunk.modularinput.SingleValueParameter;
import com.splunk.modularinput.XmlUtil;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Node;

public abstract class Parameter {
    public abstract String getName();

    Parameter() {
    }

    public static List<Parameter> nodeToParameterList(Node node) throws MalformedDataException {
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        for (Node child = node.getFirstChild(); child != null; child = child.getNextSibling()) {
            String name;
            if (child.getNodeType() == 3) continue;
            if (child.getNodeName() == "param") {
                name = child.getAttributes().getNamedItem("name").getNodeValue();
                String value = XmlUtil.textInNode(child, "Element param with name=\"" + name + "\" did not contain text.");
                parameters.add(new SingleValueParameter(name, value));
                continue;
            }
            if (child.getNodeName() == "param_list") {
                name = child.getAttributes().getNamedItem("name").getNodeValue();
                MultiValueParameter parameter = new MultiValueParameter(name);
                for (Node valueNode = child.getFirstChild(); valueNode != null; valueNode = valueNode.getNextSibling()) {
                    if (valueNode.getNodeType() == 3) continue;
                    if (valueNode.getNodeName() != "value") {
                        throw new MalformedDataException("Expected a value element in parameter named " + child.getNodeName() + "; found " + valueNode.getNodeName());
                    }
                    parameter.appendValue(XmlUtil.textInNode(valueNode, "value element in parameter named " + child.getNodeName() + " did not contain text."));
                }
                parameters.add(parameter);
                continue;
            }
            throw new MalformedDataException("Bad parameter element named " + child.getNodeName());
        }
        return parameters;
    }
}

