/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.splunk.support;

import com.splunk.Args;
import com.splunk.Index;
import com.splunk.Receiver;
import com.splunk.Service;
import java.io.IOException;
import java.net.Socket;
import org.apache.camel.RuntimeCamelException;
import org.apache.camel.component.splunk.SplunkEndpoint;
import org.apache.camel.component.splunk.support.SplunkDataWriter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StreamDataWriter
extends SplunkDataWriter {
    private static final Logger LOG = LoggerFactory.getLogger(StreamDataWriter.class);
    private String index;

    public StreamDataWriter(SplunkEndpoint endpoint, Args args) {
        super(endpoint, args);
    }

    public void setIndex(String index) {
        this.index = index;
    }

    @Override
    protected Socket createSocket(Service service) throws IOException {
        Index indexObject = null;
        Receiver receiver = null;
        Socket socket = null;
        if (this.index != null) {
            indexObject = (Index)service.getIndexes().get(this.index);
            if (indexObject == null) {
                throw new RuntimeCamelException(String.format("cannot find index [%s]", this.index));
            }
            socket = indexObject.attach(this.args);
        } else {
            receiver = service.getReceiver();
            socket = receiver.attach(this.args);
        }
        socket.setTcpNoDelay(true);
        LOG.trace(String.format("created a socket on %s", socket.getRemoteSocketAddress()));
        return socket;
    }
}

