/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringJoiner;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import org.apache.camel.CamelContext;
import org.apache.camel.Component;
import org.apache.camel.Exchange;
import org.apache.camel.Expression;
import org.apache.camel.ExtendedCamelContext;
import org.apache.camel.FailedToCreateRouteFromTemplateException;
import org.apache.camel.NoSuchBeanException;
import org.apache.camel.PropertyBindingException;
import org.apache.camel.RouteTemplateContext;
import org.apache.camel.impl.DefaultModelReifierFactory;
import org.apache.camel.impl.PreconditionHelper;
import org.apache.camel.model.BeanFactoryDefinition;
import org.apache.camel.model.DataFormatDefinition;
import org.apache.camel.model.DefaultRouteTemplateContext;
import org.apache.camel.model.FaultToleranceConfigurationDefinition;
import org.apache.camel.model.FromDefinition;
import org.apache.camel.model.Model;
import org.apache.camel.model.ModelCamelContext;
import org.apache.camel.model.ModelLifecycleStrategy;
import org.apache.camel.model.ProcessorDefinition;
import org.apache.camel.model.ProcessorDefinitionHelper;
import org.apache.camel.model.Resilience4jConfigurationDefinition;
import org.apache.camel.model.RouteConfigurationDefinition;
import org.apache.camel.model.RouteDefinition;
import org.apache.camel.model.RouteDefinitionHelper;
import org.apache.camel.model.RouteFilters;
import org.apache.camel.model.RouteTemplateBeanDefinition;
import org.apache.camel.model.RouteTemplateDefinition;
import org.apache.camel.model.RouteTemplateParameterDefinition;
import org.apache.camel.model.RoutesDefinition;
import org.apache.camel.model.TemplatedRouteBeanDefinition;
import org.apache.camel.model.TemplatedRouteDefinition;
import org.apache.camel.model.TemplatedRouteParameterDefinition;
import org.apache.camel.model.ToDefinition;
import org.apache.camel.model.cloud.ServiceCallConfigurationDefinition;
import org.apache.camel.model.rest.RestDefinition;
import org.apache.camel.model.transformer.TransformerDefinition;
import org.apache.camel.model.validator.ValidatorDefinition;
import org.apache.camel.spi.ExchangeFactory;
import org.apache.camel.spi.Language;
import org.apache.camel.spi.ModelReifierFactory;
import org.apache.camel.spi.PropertyConfigurer;
import org.apache.camel.spi.RouteTemplateLoaderListener;
import org.apache.camel.spi.ScriptingLanguage;
import org.apache.camel.support.CamelContextHelper;
import org.apache.camel.support.PatternHelper;
import org.apache.camel.support.PropertyBindingSupport;
import org.apache.camel.support.RouteTemplateHelper;
import org.apache.camel.support.ScriptHelper;
import org.apache.camel.support.service.ServiceHelper;
import org.apache.camel.util.AntPathMatcher;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.StringHelper;
import org.apache.camel.util.function.Suppliers;

public class DefaultModel
implements Model {
    private final CamelContext camelContext;
    private ModelReifierFactory modelReifierFactory = new DefaultModelReifierFactory();
    private final List<ModelLifecycleStrategy> modelLifecycleStrategies = new ArrayList<ModelLifecycleStrategy>();
    private final List<RouteConfigurationDefinition> routesConfigurations = new ArrayList<RouteConfigurationDefinition>();
    private final List<RouteDefinition> routeDefinitions = new ArrayList<RouteDefinition>();
    private final List<RouteTemplateDefinition> routeTemplateDefinitions = new ArrayList<RouteTemplateDefinition>();
    private final List<RestDefinition> restDefinitions = new ArrayList<RestDefinition>();
    private final Map<String, RouteTemplateDefinition.Converter> routeTemplateConverters = new ConcurrentHashMap<String, RouteTemplateDefinition.Converter>();
    private Map<String, DataFormatDefinition> dataFormats = new HashMap<String, DataFormatDefinition>();
    private List<TransformerDefinition> transformers = new ArrayList<TransformerDefinition>();
    private List<ValidatorDefinition> validators = new ArrayList<ValidatorDefinition>();
    private final Map<String, ServiceCallConfigurationDefinition> serviceCallConfigurations = new ConcurrentHashMap<String, ServiceCallConfigurationDefinition>();
    private final Map<String, Resilience4jConfigurationDefinition> resilience4jConfigurations = new ConcurrentHashMap<String, Resilience4jConfigurationDefinition>();
    private final Map<String, FaultToleranceConfigurationDefinition> faultToleranceConfigurations = new ConcurrentHashMap<String, FaultToleranceConfigurationDefinition>();
    private Function<RouteDefinition, Boolean> routeFilter;

    public DefaultModel(CamelContext camelContext) {
        this.camelContext = camelContext;
    }

    public CamelContext getCamelContext() {
        return this.camelContext;
    }

    @Override
    public void addModelLifecycleStrategy(ModelLifecycleStrategy modelLifecycleStrategy) {
        if (!this.modelLifecycleStrategies.contains(modelLifecycleStrategy)) {
            this.modelLifecycleStrategies.add(modelLifecycleStrategy);
        }
    }

    @Override
    public List<ModelLifecycleStrategy> getModelLifecycleStrategies() {
        return this.modelLifecycleStrategies;
    }

    @Override
    public void addRouteConfiguration(RouteConfigurationDefinition routesConfiguration) {
        if (routesConfiguration == null || !this.includedRouteConfiguration(routesConfiguration)) {
            return;
        }
        if (!this.routesConfigurations.contains(routesConfiguration)) {
            boolean clash;
            if (routesConfiguration.getId() != null && (clash = this.routesConfigurations.stream().anyMatch(r -> ObjectHelper.equal(r.getId(), routesConfiguration.getId())))) {
                throw new IllegalArgumentException("Route configuration already exists with id: " + routesConfiguration.getId());
            }
            this.routesConfigurations.add(routesConfiguration);
        }
    }

    @Override
    public void addRouteConfigurations(List<RouteConfigurationDefinition> routesConfigurations) {
        if (routesConfigurations == null || routesConfigurations.isEmpty()) {
            return;
        }
        for (RouteConfigurationDefinition rc : routesConfigurations) {
            this.addRouteConfiguration(rc);
        }
    }

    @Override
    public List<RouteConfigurationDefinition> getRouteConfigurationDefinitions() {
        return this.routesConfigurations;
    }

    @Override
    public synchronized RouteConfigurationDefinition getRouteConfigurationDefinition(String id) {
        for (RouteConfigurationDefinition def : this.routesConfigurations) {
            if (!def.idOrCreate(this.camelContext.adapt(ExtendedCamelContext.class).getNodeIdFactory()).equals(id)) continue;
            return def;
        }
        return this.routesConfigurations.stream().filter(c -> c.getId() == null).findFirst().orElse(null);
    }

    @Override
    public void removeRouteConfiguration(RouteConfigurationDefinition routeConfigurationDefinition) throws Exception {
        RouteConfigurationDefinition toBeRemoved = this.getRouteConfigurationDefinition(routeConfigurationDefinition.getId());
        this.routesConfigurations.remove(toBeRemoved);
    }

    @Override
    public synchronized void addRouteDefinitions(Collection<RouteDefinition> routeDefinitions) throws Exception {
        ArrayList<RouteDefinition> list;
        if (routeDefinitions == null || routeDefinitions.isEmpty()) {
            return;
        }
        if (this.routeFilter == null) {
            list = new ArrayList<RouteDefinition>(routeDefinitions);
        } else {
            list = new ArrayList();
            for (RouteDefinition r : routeDefinitions) {
                if (!this.routeFilter.apply(r).booleanValue()) continue;
                list.add(r);
            }
        }
        this.removeRouteDefinitions(list);
        if (this.camelContext.getRestConfiguration().isInlineRoutes()) {
            String uri;
            FromDefinition from;
            ArrayList<RouteDefinition> allRoutes = new ArrayList<RouteDefinition>();
            allRoutes.addAll(list);
            allRoutes.addAll(this.routeDefinitions);
            ArrayList<RouteDefinition> toBeRemoved = new ArrayList<RouteDefinition>();
            HashMap<String, RouteDefinition> directs = new HashMap<String, RouteDefinition>();
            for (RouteDefinition r : allRoutes) {
                from = r.getInput();
                if (from == null || (uri = from.getEndpointUri()) == null || !uri.startsWith("direct:")) continue;
                directs.put(uri, r);
            }
            for (RouteDefinition r : allRoutes) {
                ToDefinition to;
                String toUri;
                RouteDefinition toBeInlined;
                from = r.getInput();
                if (from == null || (uri = from.getEndpointUri()) == null || !uri.startsWith("rest:") || (toBeInlined = (RouteDefinition)directs.get(toUri = (to = (ToDefinition)r.getOutputs().get(0)).getEndpointUri())) == null) continue;
                toBeRemoved.add(toBeInlined);
                r.getOutputs().clear();
                r.getOutputs().addAll(toBeInlined.getOutputs());
            }
            list.removeAll(toBeRemoved);
            this.routeDefinitions.removeAll(toBeRemoved);
        }
        for (RouteDefinition r : list) {
            for (ModelLifecycleStrategy s : this.modelLifecycleStrategies) {
                s.onAddRouteDefinition(r);
            }
            this.routeDefinitions.add(r);
        }
        if (this.shouldStartRoutes()) {
            this.getCamelContext().adapt(ModelCamelContext.class).startRouteDefinitions(list);
        }
    }

    @Override
    public void addRouteDefinition(RouteDefinition routeDefinition) throws Exception {
        this.addRouteDefinitions(Collections.singletonList(routeDefinition));
    }

    @Override
    public synchronized void removeRouteDefinitions(Collection<RouteDefinition> routeDefinitions) throws Exception {
        for (RouteDefinition routeDefinition : routeDefinitions) {
            this.removeRouteDefinition(routeDefinition);
        }
    }

    @Override
    public synchronized void removeRouteDefinition(RouteDefinition routeDefinition) throws Exception {
        RouteDefinition toBeRemoved = routeDefinition;
        String id = routeDefinition.getId();
        if (id != null) {
            this.camelContext.getRouteController().stopRoute(id);
            this.camelContext.removeRoute(id);
            toBeRemoved = this.getRouteDefinition(id);
        }
        for (ModelLifecycleStrategy s : this.modelLifecycleStrategies) {
            s.onRemoveRouteDefinition(toBeRemoved);
        }
        this.routeDefinitions.remove(toBeRemoved);
    }

    @Override
    public synchronized void removeRouteTemplateDefinitions(String pattern) throws Exception {
        for (RouteTemplateDefinition def : new ArrayList<RouteTemplateDefinition>(this.routeTemplateDefinitions)) {
            if (!PatternHelper.matchPattern(def.getId(), pattern)) continue;
            this.removeRouteTemplateDefinition(def);
        }
    }

    @Override
    public synchronized List<RouteDefinition> getRouteDefinitions() {
        return this.routeDefinitions;
    }

    @Override
    public synchronized RouteDefinition getRouteDefinition(String id) {
        for (RouteDefinition route : this.routeDefinitions) {
            if (!route.idOrCreate(this.camelContext.adapt(ExtendedCamelContext.class).getNodeIdFactory()).equals(id)) continue;
            return route;
        }
        return null;
    }

    @Override
    public List<RouteTemplateDefinition> getRouteTemplateDefinitions() {
        return this.routeTemplateDefinitions;
    }

    @Override
    public RouteTemplateDefinition getRouteTemplateDefinition(String id) {
        for (RouteTemplateDefinition route : this.routeTemplateDefinitions) {
            if (!route.idOrCreate(this.camelContext.adapt(ExtendedCamelContext.class).getNodeIdFactory()).equals(id)) continue;
            return route;
        }
        return null;
    }

    @Override
    public void addRouteTemplateDefinitions(Collection<RouteTemplateDefinition> routeTemplateDefinitions) throws Exception {
        if (routeTemplateDefinitions == null || routeTemplateDefinitions.isEmpty()) {
            return;
        }
        for (RouteTemplateDefinition r : routeTemplateDefinitions) {
            for (ModelLifecycleStrategy s : this.modelLifecycleStrategies) {
                s.onAddRouteTemplateDefinition(r);
            }
            this.routeTemplateDefinitions.add(r);
        }
    }

    @Override
    public void addRouteTemplateDefinition(RouteTemplateDefinition routeTemplateDefinition) throws Exception {
        this.addRouteTemplateDefinitions(Collections.singletonList(routeTemplateDefinition));
    }

    @Override
    public void removeRouteTemplateDefinitions(Collection<RouteTemplateDefinition> routeTemplateDefinitions) throws Exception {
        for (RouteTemplateDefinition r : routeTemplateDefinitions) {
            this.removeRouteTemplateDefinition(r);
        }
    }

    @Override
    public void removeRouteTemplateDefinition(RouteTemplateDefinition routeTemplateDefinition) throws Exception {
        for (ModelLifecycleStrategy s : this.modelLifecycleStrategies) {
            s.onRemoveRouteTemplateDefinition(routeTemplateDefinition);
        }
        this.routeTemplateDefinitions.remove(routeTemplateDefinition);
    }

    @Override
    public void addRouteTemplateDefinitionConverter(String templateIdPattern, RouteTemplateDefinition.Converter converter) {
        this.routeTemplateConverters.put(templateIdPattern, converter);
    }

    @Override
    @Deprecated
    public String addRouteFromTemplate(String routeId, String routeTemplateId, Map<String, Object> parameters) throws Exception {
        DefaultRouteTemplateContext rtc = new DefaultRouteTemplateContext(this.camelContext);
        if (parameters != null) {
            parameters.forEach(rtc::setParameter);
        }
        return this.addRouteFromTemplate(routeId, routeTemplateId, null, rtc);
    }

    @Override
    public String addRouteFromTemplate(String routeId, String routeTemplateId, String prefixId, Map<String, Object> parameters) throws Exception {
        DefaultRouteTemplateContext rtc = new DefaultRouteTemplateContext(this.camelContext);
        if (parameters != null) {
            parameters.forEach(rtc::setParameter);
        }
        return this.addRouteFromTemplate(routeId, routeTemplateId, prefixId, rtc);
    }

    @Override
    public String addRouteFromTemplate(String routeId, String routeTemplateId, RouteTemplateContext routeTemplateContext) throws Exception {
        return this.addRouteFromTemplate(routeId, routeTemplateId, null, routeTemplateContext);
    }

    @Override
    public String addRouteFromTemplate(String routeId, String routeTemplateId, String prefixId, RouteTemplateContext routeTemplateContext) throws Exception {
        String string;
        RouteTemplateDefinition target = null;
        for (RouteTemplateDefinition def : this.routeTemplateDefinitions) {
            if (!routeTemplateId.equals(def.getId())) continue;
            target = def;
            break;
        }
        if (target == null) {
            Object location = routeTemplateContext.getParameters().get("location");
            if (location != null) {
                RouteTemplateLoaderListener listener = CamelContextHelper.findSingleByType(this.getCamelContext(), RouteTemplateLoaderListener.class);
                RouteTemplateHelper.loadRouteTemplateFromLocation(this.getCamelContext(), listener, routeTemplateId, location.toString());
            }
            for (RouteTemplateDefinition def : this.routeTemplateDefinitions) {
                if (!routeTemplateId.equals(def.getId())) continue;
                target = def;
                break;
            }
        }
        if (target == null) {
            throw new IllegalArgumentException("Cannot find RouteTemplate with id " + routeTemplateId);
        }
        HashMap<String, Object> prop = new HashMap<String, Object>();
        HashMap<String, Object> propDefaultValues = new HashMap<String, Object>();
        if (target.getTemplateParameters() != null) {
            StringJoiner templatesBuilder = new StringJoiner(", ");
            for (RouteTemplateParameterDefinition routeTemplateParameterDefinition : target.getTemplateParameters()) {
                if (routeTemplateParameterDefinition.getDefaultValue() != null) {
                    DefaultModel.addProperty(prop, routeTemplateParameterDefinition.getName(), routeTemplateParameterDefinition.getDefaultValue());
                    DefaultModel.addProperty(propDefaultValues, routeTemplateParameterDefinition.getName(), routeTemplateParameterDefinition.getDefaultValue());
                    continue;
                }
                if (!routeTemplateParameterDefinition.isRequired() || routeTemplateContext.hasParameter(routeTemplateParameterDefinition.getName())) continue;
                templatesBuilder.add(routeTemplateParameterDefinition.getName());
            }
            if (templatesBuilder.length() > 0) {
                throw new IllegalArgumentException("Route template " + routeTemplateId + " the following mandatory parameters must be provided: " + (StringJoiner)templatesBuilder);
            }
        }
        if (routeTemplateContext.getParameters() != null) {
            routeTemplateContext.getParameters().forEach((k, v) -> DefaultModel.addProperty(prop, k, v));
        }
        if (target.getTemplateParameters() != null) {
            for (RouteTemplateParameterDefinition routeTemplateParameterDefinition : target.getTemplateParameters()) {
                if (routeTemplateContext.hasParameter(routeTemplateParameterDefinition.getName()) || routeTemplateParameterDefinition.getDefaultValue() == null) continue;
                routeTemplateContext.setParameter(routeTemplateParameterDefinition.getName(), routeTemplateParameterDefinition.getDefaultValue());
            }
        }
        RouteTemplateDefinition.Converter converter = RouteTemplateDefinition.Converter.DEFAULT_CONVERTER;
        for (Map.Entry<String, RouteTemplateDefinition.Converter> entry : this.routeTemplateConverters.entrySet()) {
            String key = entry.getKey();
            String templateId = target.getId();
            if ("*".equals(key) || templateId.equals(key)) {
                converter = entry.getValue();
                break;
            }
            if (AntPathMatcher.INSTANCE.match(key, templateId)) {
                converter = entry.getValue();
                break;
            }
            if (!templateId.matches(key)) continue;
            converter = entry.getValue();
            break;
        }
        RouteDefinition routeDefinition = converter.apply(target, prop);
        if (routeId != null) {
            routeDefinition.setId(routeId);
        }
        if (prefixId != null) {
            routeDefinition.setNodePrefixId(prefixId);
        }
        routeDefinition.setTemplateParameters(prop);
        routeDefinition.setTemplateDefaultParameters(propDefaultValues);
        routeDefinition.setRouteTemplateContext(routeTemplateContext);
        if (target.getTemplateBeans() != null) {
            DefaultModel.addTemplateBeans(routeTemplateContext, target);
        }
        if (target.getConfigurer() != null) {
            routeTemplateContext.setConfigurer(target.getConfigurer());
        }
        if ((string = RouteDefinitionHelper.validateUniqueIds(routeDefinition, this.routeDefinitions, prefixId)) != null) {
            throw new FailedToCreateRouteFromTemplateException(routeId, routeTemplateId, "duplicate id detected: " + string + ". Please correct ids to be unique among all your routes.");
        }
        RoutesDefinition routeCollection = new RoutesDefinition();
        routeCollection.setCamelContext(this.camelContext);
        routeCollection.setRoutes(this.getRouteDefinitions());
        routeCollection.prepareRoute(routeDefinition);
        this.addRouteDefinition(routeDefinition);
        return routeDefinition.getId();
    }

    private static void addProperty(Map<String, Object> prop, String key, Object value) {
        prop.put(key, value);
        key = StringHelper.dashToCamelCase(key);
        prop.put(key, value);
        key = StringHelper.camelCaseToDash(key);
        prop.put(key, value);
    }

    private static void addTemplateBeans(RouteTemplateContext routeTemplateContext, RouteTemplateDefinition target) throws Exception {
        for (RouteTemplateBeanDefinition b : target.getTemplateBeans()) {
            DefaultModel.bind(b, routeTemplateContext);
        }
    }

    private static void bind(BeanFactoryDefinition<?, ?> beanFactory, RouteTemplateContext routeTemplateContext) throws Exception {
        HashMap props = new HashMap();
        if (beanFactory.getProperties() != null) {
            beanFactory.getProperties().forEach(p -> props.put(p.getKey(), p.getValue()));
        }
        if (beanFactory.getBeanSupplier() != null) {
            if (props.isEmpty()) {
                if (beanFactory.getBeanClass() != null) {
                    routeTemplateContext.bind(beanFactory.getName(), beanFactory.getBeanClass(), beanFactory.getBeanSupplier());
                } else {
                    routeTemplateContext.bind(beanFactory.getName(), beanFactory.getBeanSupplier());
                }
            }
        } else if (beanFactory.getScript() != null) {
            ScriptingLanguage slan;
            String script = beanFactory.getScript();
            CamelContext camelContext = routeTemplateContext.getCamelContext();
            Language lan = camelContext.resolveLanguage(beanFactory.getType());
            Class clazz = beanFactory.getBeanType() != null ? camelContext.getClassResolver().resolveMandatoryClass(beanFactory.getBeanType()) : (beanFactory.getBeanClass() != null ? beanFactory.getBeanClass() : Object.class);
            ScriptingLanguage scriptingLanguage = slan = lan instanceof ScriptingLanguage ? (ScriptingLanguage)((Object)lan) : null;
            if (slan != null) {
                routeTemplateContext.bind(beanFactory.getName(), clazz, Suppliers.memorize(() -> {
                    HashMap<String, Object> bindings = new HashMap<String, Object>();
                    bindings.put("rtc", routeTemplateContext);
                    Object local = slan.evaluate(script, bindings, clazz);
                    if (!props.isEmpty()) {
                        DefaultModel.setPropertiesOnTarget(camelContext, local, props);
                    }
                    return local;
                }));
            } else {
                routeTemplateContext.bind(beanFactory.getName(), clazz, Suppliers.memorize(() -> {
                    ExchangeFactory ef = camelContext.adapt(ExtendedCamelContext.class).getExchangeFactory();
                    Exchange dummy = ef.create(false);
                    try {
                        String text = ScriptHelper.resolveOptionalExternalScript(camelContext, dummy, script);
                        if (text != null) {
                            Expression exp = lan.createExpression(text);
                            Object local = exp.evaluate(dummy, clazz);
                            if (!props.isEmpty()) {
                                DefaultModel.setPropertiesOnTarget(camelContext, local, props);
                            }
                            Object t = local;
                            return t;
                        }
                        Object var8_9 = null;
                        return var8_9;
                    }
                    finally {
                        ef.release(dummy);
                    }
                }));
            }
        } else if (beanFactory.getBeanClass() != null || beanFactory.getType() != null && beanFactory.getType().startsWith("#class:")) {
            String className = null;
            String factoryMethod = null;
            String parameters = null;
            if (beanFactory.getType() != null) {
                className = beanFactory.getType().substring(7);
                if (className.endsWith(")") && className.indexOf(40) != -1) {
                    parameters = StringHelper.after(className, "(");
                    parameters = parameters.substring(0, parameters.length() - 1);
                    className = StringHelper.before(className, "(");
                }
                if (className != null && className.indexOf(35) != -1) {
                    factoryMethod = StringHelper.after(className, "#");
                    className = StringHelper.before(className, "#");
                }
            }
            if (className != null && (factoryMethod != null || parameters != null)) {
                CamelContext camelContext = routeTemplateContext.getCamelContext();
                Class<?> clazz = camelContext.getClassResolver().resolveMandatoryClass(className);
                String fqn = className;
                String fm = factoryMethod;
                String fp = parameters;
                routeTemplateContext.bind(beanFactory.getName(), Object.class, Suppliers.memorize(() -> {
                    String params = camelContext.resolvePropertyPlaceholders(fp);
                    try {
                        Object local;
                        if (fm != null) {
                            local = fp != null ? PropertyBindingSupport.newInstanceFactoryParameters(camelContext, clazz, fm, params) : camelContext.getInjector().newInstance(clazz, fm);
                            if (local == null) {
                                throw new IllegalStateException("Cannot create bean instance using factory method: " + fqn + "#" + fm);
                            }
                        } else {
                            local = PropertyBindingSupport.newInstanceConstructorParameters(camelContext, clazz, params);
                        }
                        if (!props.isEmpty()) {
                            DefaultModel.setPropertiesOnTarget(camelContext, local, props);
                        }
                        return local;
                    }
                    catch (Exception e) {
                        throw new IllegalStateException("Cannot create bean: " + beanFactory.getType());
                    }
                }));
            } else {
                CamelContext camelContext = routeTemplateContext.getCamelContext();
                Class<?> clazz = beanFactory.getBeanClass() != null ? beanFactory.getBeanClass() : camelContext.getClassResolver().resolveMandatoryClass(className);
                routeTemplateContext.bind(beanFactory.getName(), clazz, Suppliers.memorize(() -> {
                    Object local = camelContext.getInjector().newInstance(clazz);
                    if (!props.isEmpty()) {
                        DefaultModel.setPropertiesOnTarget(camelContext, local, props);
                    }
                    return local;
                }));
            }
        } else if (beanFactory.getType() != null && beanFactory.getType().startsWith("#type:")) {
            CamelContext camelContext = routeTemplateContext.getCamelContext();
            Class<?> clazz = camelContext.getClassResolver().resolveMandatoryClass(beanFactory.getType().substring(6));
            Set<?> found = camelContext.getRegistry().findByType(clazz);
            if (found == null || found.isEmpty()) {
                throw new NoSuchBeanException(null, clazz.getName());
            }
            if (found.size() > 1) {
                throw new NoSuchBeanException("Found " + found.size() + " beans of type: " + clazz + ". Only one bean expected.");
            }
            routeTemplateContext.bind(beanFactory.getName(), clazz, found.iterator().next());
        } else {
            throw new IllegalArgumentException("Route template local bean: " + beanFactory.getName() + " has invalid type syntax: " + beanFactory.getType() + ". To refer to a class then prefix the value with #class such as: #class:fullyQualifiedClassName");
        }
    }

    private static void setPropertiesOnTarget(CamelContext context, Object target, Map<String, Object> properties) {
        ObjectHelper.notNull(context, "context");
        ObjectHelper.notNull(target, "target");
        ObjectHelper.notNull(properties, "properties");
        if (target instanceof CamelContext) {
            throw new UnsupportedOperationException("Configuring the Camel Context is not supported");
        }
        PropertyConfigurer configurer = null;
        if (target instanceof Component) {
            ServiceHelper.initService(target);
            configurer = ((Component)target).getComponentPropertyConfigurer();
        }
        if (configurer == null) {
            configurer = context.adapt(ExtendedCamelContext.class).getConfigurerResolver().resolvePropertyConfigurer(target.getClass().getSimpleName(), context);
        }
        try {
            PropertyBindingSupport.build().withMandatory(true).withRemoveParameters(false).withConfigurer(configurer).withIgnoreCase(true).withFlattenProperties(true).bind(context, target, properties);
        }
        catch (PropertyBindingException e) {
            String key = e.getOptionKey();
            if (key == null) {
                Object prefix = e.getOptionPrefix();
                if (prefix != null && !((String)prefix).endsWith(".")) {
                    prefix = "." + (String)prefix;
                }
                key = prefix != null ? (String)prefix + "." + e.getPropertyName() : e.getPropertyName();
            }
            throw new PropertyBindingException(e.getTarget(), e.getPropertyName(), e.getValue(), null, key, e.getCause());
        }
    }

    @Override
    public void addRouteFromTemplatedRoute(TemplatedRouteDefinition templatedRouteDefinition) throws Exception {
        List<TemplatedRouteBeanDefinition> beans;
        ObjectHelper.notNull(templatedRouteDefinition, "templatedRouteDefinition");
        DefaultRouteTemplateContext routeTemplateContext = new DefaultRouteTemplateContext(this.camelContext);
        List<TemplatedRouteParameterDefinition> parameters = templatedRouteDefinition.getParameters();
        if (parameters != null) {
            for (TemplatedRouteParameterDefinition parameterDefinition : parameters) {
                routeTemplateContext.setParameter(parameterDefinition.getName(), parameterDefinition.getValue());
            }
        }
        if ((beans = templatedRouteDefinition.getBeans()) != null) {
            for (TemplatedRouteBeanDefinition beanDefinition : beans) {
                DefaultModel.bind(beanDefinition, routeTemplateContext);
            }
        }
        this.addRouteFromTemplate(templatedRouteDefinition.getRouteId(), templatedRouteDefinition.getRouteTemplateRef(), templatedRouteDefinition.getPrefixId(), routeTemplateContext);
    }

    @Override
    public synchronized List<RestDefinition> getRestDefinitions() {
        return this.restDefinitions;
    }

    @Override
    public synchronized void addRestDefinitions(Collection<RestDefinition> restDefinitions, boolean addToRoutes) throws Exception {
        if (restDefinitions == null || restDefinitions.isEmpty()) {
            return;
        }
        this.restDefinitions.addAll(restDefinitions);
        if (addToRoutes) {
            for (RestDefinition restDefinition : restDefinitions) {
                List<RouteDefinition> routeDefinitions = restDefinition.asRouteDefinition(this.camelContext);
                this.addRouteDefinitions(routeDefinitions);
            }
        }
    }

    @Override
    public ServiceCallConfigurationDefinition getServiceCallConfiguration(String serviceName) {
        if (serviceName == null) {
            serviceName = "";
        }
        return this.serviceCallConfigurations.get(serviceName);
    }

    @Override
    public void setServiceCallConfiguration(ServiceCallConfigurationDefinition configuration) {
        this.serviceCallConfigurations.put("", configuration);
    }

    @Override
    public void setServiceCallConfigurations(List<ServiceCallConfigurationDefinition> configurations) {
        if (configurations != null) {
            for (ServiceCallConfigurationDefinition configuration : configurations) {
                this.serviceCallConfigurations.put(configuration.getId(), configuration);
            }
        }
    }

    @Override
    public void addServiceCallConfiguration(String serviceName, ServiceCallConfigurationDefinition configuration) {
        this.serviceCallConfigurations.put(serviceName, configuration);
    }

    @Override
    public Resilience4jConfigurationDefinition getResilience4jConfiguration(String id) {
        if (id == null) {
            id = "";
        }
        return this.resilience4jConfigurations.get(id);
    }

    @Override
    public void setResilience4jConfiguration(Resilience4jConfigurationDefinition configuration) {
        this.resilience4jConfigurations.put("", configuration);
    }

    @Override
    public void setResilience4jConfigurations(List<Resilience4jConfigurationDefinition> configurations) {
        if (configurations != null) {
            for (Resilience4jConfigurationDefinition configuration : configurations) {
                this.resilience4jConfigurations.put(configuration.getId(), configuration);
            }
        }
    }

    @Override
    public void addResilience4jConfiguration(String id, Resilience4jConfigurationDefinition configuration) {
        this.resilience4jConfigurations.put(id, configuration);
    }

    @Override
    public FaultToleranceConfigurationDefinition getFaultToleranceConfiguration(String id) {
        if (id == null) {
            id = "";
        }
        return this.faultToleranceConfigurations.get(id);
    }

    @Override
    public void setFaultToleranceConfiguration(FaultToleranceConfigurationDefinition configuration) {
        this.faultToleranceConfigurations.put("", configuration);
    }

    @Override
    public void setFaultToleranceConfigurations(List<FaultToleranceConfigurationDefinition> configurations) {
        if (configurations != null) {
            for (FaultToleranceConfigurationDefinition configuration : configurations) {
                this.faultToleranceConfigurations.put(configuration.getId(), configuration);
            }
        }
    }

    @Override
    public void addFaultToleranceConfiguration(String id, FaultToleranceConfigurationDefinition configuration) {
        this.faultToleranceConfigurations.put(id, configuration);
    }

    @Override
    public DataFormatDefinition resolveDataFormatDefinition(String name) {
        DataFormatDefinition type = DefaultModel.lookup(this.camelContext, name, DataFormatDefinition.class);
        if (type == null && this.getDataFormats() != null) {
            type = this.getDataFormats().get(name);
        }
        return type;
    }

    @Override
    public ProcessorDefinition<?> getProcessorDefinition(String id) {
        for (RouteDefinition route : this.getRouteDefinitions()) {
            Collection<ProcessorDefinition> col = ProcessorDefinitionHelper.filterTypeInOutputs(route.getOutputs(), ProcessorDefinition.class);
            for (ProcessorDefinition proc : col) {
                if (!id.equals(proc.getId())) continue;
                return proc;
            }
        }
        return null;
    }

    @Override
    public <T extends ProcessorDefinition<T>> T getProcessorDefinition(String id, Class<T> type) {
        ProcessorDefinition<?> answer = this.getProcessorDefinition(id);
        if (answer != null) {
            return (T)((ProcessorDefinition)type.cast(answer));
        }
        return null;
    }

    @Override
    public Map<String, DataFormatDefinition> getDataFormats() {
        return this.dataFormats;
    }

    @Override
    public void setDataFormats(Map<String, DataFormatDefinition> dataFormats) {
        this.dataFormats = dataFormats;
    }

    @Override
    public List<TransformerDefinition> getTransformers() {
        return this.transformers;
    }

    @Override
    public void setTransformers(List<TransformerDefinition> transformers) {
        this.transformers = transformers;
    }

    @Override
    public List<ValidatorDefinition> getValidators() {
        return this.validators;
    }

    @Override
    public void setValidators(List<ValidatorDefinition> validators) {
        this.validators = validators;
    }

    @Override
    public void setRouteFilterPattern(String include, String exclude) {
        this.setRouteFilter(RouteFilters.filterByPattern(include, exclude));
    }

    @Override
    public Function<RouteDefinition, Boolean> getRouteFilter() {
        return this.routeFilter;
    }

    @Override
    public void setRouteFilter(Function<RouteDefinition, Boolean> routeFilter) {
        this.routeFilter = routeFilter;
    }

    @Override
    public ModelReifierFactory getModelReifierFactory() {
        return this.modelReifierFactory;
    }

    @Override
    public void setModelReifierFactory(ModelReifierFactory modelReifierFactory) {
        this.modelReifierFactory = modelReifierFactory;
    }

    protected boolean shouldStartRoutes() {
        return this.camelContext.isStarted() && !this.camelContext.isStarting();
    }

    private static <T> T lookup(CamelContext context, String ref, Class<T> type) {
        try {
            return context.getRegistry().lookupByNameAndType(ref, type);
        }
        catch (Exception e) {
            return null;
        }
    }

    private boolean includedRouteConfiguration(RouteConfigurationDefinition definition) {
        return PreconditionHelper.included(definition, this.camelContext);
    }
}

