/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spring.batch.support;

import org.apache.camel.ProducerTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.ItemProcessor;

public class CamelItemProcessor<I, O>
implements ItemProcessor<I, O> {
    private static final Logger LOG = LoggerFactory.getLogger(CamelItemProcessor.class);
    private final ProducerTemplate producerTemplate;
    private final String endpointUri;

    public CamelItemProcessor(ProducerTemplate producerTemplate, String endpointUri) {
        this.producerTemplate = producerTemplate;
        this.endpointUri = endpointUri;
    }

    @Override
    public O process(I i) throws Exception {
        LOG.debug("processing item [{}]...", i);
        Object result = this.producerTemplate.requestBody(this.endpointUri, i);
        LOG.debug("processed item");
        return (O)result;
    }
}

