/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spring.batch.support;

import org.apache.camel.CamelContext;
import org.apache.camel.ConsumerTemplate;
import org.apache.camel.Service;
import org.apache.camel.support.ServiceSupport;
import org.apache.camel.util.ObjectHelper;
import org.apache.camel.util.ServiceHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.ItemReader;
import org.springframework.beans.factory.InitializingBean;

public class CamelItemReader<I>
extends ServiceSupport
implements ItemReader<I>,
InitializingBean {
    private static final Logger LOG = LoggerFactory.getLogger(CamelItemReader.class);
    private final CamelContext camelContext;
    private final ConsumerTemplate consumerTemplate;
    private final String endpointUri;

    public CamelItemReader(ConsumerTemplate consumerTemplate, String endpointUri) {
        this.consumerTemplate = consumerTemplate;
        this.camelContext = consumerTemplate.getCamelContext();
        this.endpointUri = endpointUri;
    }

    public void afterPropertiesSet() throws Exception {
        ObjectHelper.notNull((Object)this.camelContext, (String)"CamelContext", (Object)this);
        this.camelContext.addService((Object)this);
    }

    @Override
    public I read() throws Exception {
        LOG.debug("reading new item...");
        Object item = this.consumerTemplate.receiveBody(this.endpointUri);
        LOG.debug("read item [{}]", item);
        return (I)item;
    }

    protected void doStart() throws Exception {
        ServiceHelper.startService((Service)this.consumerTemplate);
    }

    protected void doStop() throws Exception {
        ServiceHelper.stopService((Object)this.consumerTemplate);
    }
}

