/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spring.batch.support;

import java.util.List;
import org.apache.camel.ProducerTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.item.ItemWriter;

public class CamelItemWriter<I>
implements ItemWriter<I> {
    private static final Logger LOG = LoggerFactory.getLogger(CamelItemWriter.class);
    private final ProducerTemplate producerTemplate;
    private final String endpointUri;

    public CamelItemWriter(ProducerTemplate producerTemplate, String endpointUri) {
        this.producerTemplate = producerTemplate;
        this.endpointUri = endpointUri;
    }

    @Override
    public void write(List<? extends I> items) throws Exception {
        for (I item : items) {
            LOG.debug("writing item [{}]...", item);
            this.producerTemplate.sendBody(this.endpointUri, item);
            LOG.debug("wrote item");
        }
    }
}

