/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.job.flow.support;

import org.springframework.batch.core.job.flow.State;
import org.springframework.batch.support.PatternMatcher;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

public final class StateTransition
implements Comparable<StateTransition> {
    private final State state;
    private final String pattern;
    private final String next;

    public static StateTransition createEndStateTransition(State state) {
        return StateTransition.createStateTransition(state, null, null);
    }

    public static StateTransition createEndStateTransition(State state, String pattern) {
        return StateTransition.createStateTransition(state, pattern, null);
    }

    public static StateTransition switchOriginAndDestination(StateTransition stateTransition, State state, String next) {
        return StateTransition.createStateTransition(state, stateTransition.pattern, next);
    }

    public static StateTransition createStateTransition(State state, String next) {
        return StateTransition.createStateTransition(state, null, next);
    }

    public static StateTransition createStateTransition(State state, String pattern, String next) {
        return new StateTransition(state, pattern, next);
    }

    private StateTransition(State state, String pattern, String next) {
        this.pattern = !StringUtils.hasText((String)pattern) ? "*" : pattern;
        Assert.notNull((Object)state, (String)"A state is required for a StateTransition");
        if (state.isEndState() && StringUtils.hasText((String)next)) {
            throw new IllegalStateException("End state cannot have next: " + state);
        }
        this.next = next;
        this.state = state;
    }

    public State getState() {
        return this.state;
    }

    public String getNext() {
        return this.next;
    }

    public boolean matches(String status) {
        return PatternMatcher.match(this.pattern, status);
    }

    public boolean isEnd() {
        return this.next == null;
    }

    @Override
    public int compareTo(StateTransition other) {
        int valueCount;
        String value = other.pattern;
        if (this.pattern.equals(value)) {
            return 0;
        }
        int patternCount = StringUtils.countOccurrencesOf((String)this.pattern, (String)"*");
        if (patternCount > (valueCount = StringUtils.countOccurrencesOf((String)value, (String)"*"))) {
            return 1;
        }
        if (patternCount < valueCount) {
            return -1;
        }
        patternCount = StringUtils.countOccurrencesOf((String)this.pattern, (String)"?");
        if (patternCount > (valueCount = StringUtils.countOccurrencesOf((String)value, (String)"?"))) {
            return 1;
        }
        if (patternCount < valueCount) {
            return -1;
        }
        return this.pattern.compareTo(value);
    }

    public String toString() {
        return String.format("StateTransition: [state=%s, pattern=%s, next=%s]", this.state == null ? null : this.state.getName(), this.pattern, this.next);
    }
}

