/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.scope;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.scope.ScopedProxyUtils;
import org.springframework.batch.core.scope.context.StepContext;
import org.springframework.batch.core.scope.context.StepSynchronizationManager;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.ObjectFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.config.BeanDefinitionVisitor;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.Scope;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.core.Ordered;
import org.springframework.util.Assert;
import org.springframework.util.StringValueResolver;

public class StepScope
implements Scope,
BeanFactoryPostProcessor,
Ordered {
    private Log logger = LogFactory.getLog(this.getClass());
    private int order = Integer.MAX_VALUE;
    private boolean autoProxy = true;
    private final Object mutex = new Object();
    public static final String ID_KEY = "STEP_IDENTIFIER";
    private String name = "step";
    private boolean proxyTargetClass = false;

    public void setOrder(int order) {
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void setProxyTargetClass(boolean proxyTargetClass) {
        this.proxyTargetClass = proxyTargetClass;
    }

    public void setAutoProxy(boolean autoProxy) {
        this.autoProxy = autoProxy;
    }

    public Object resolveContextualObject(String key) {
        StepContext context = this.getContext();
        return new BeanWrapperImpl((Object)context).getPropertyValue(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(String name, ObjectFactory objectFactory) {
        StepContext context = this.getContext();
        Object scopedObject = context.getAttribute(name);
        if (scopedObject == null) {
            Object object = this.mutex;
            synchronized (object) {
                scopedObject = context.getAttribute(name);
                if (scopedObject == null) {
                    this.logger.debug((Object)String.format("Creating object in scope=%s, name=%s", this.name, name));
                    scopedObject = objectFactory.getObject();
                    context.setAttribute(name, scopedObject);
                }
            }
        }
        return scopedObject;
    }

    public String getConversationId() {
        StepContext context = this.getContext();
        return context.getId();
    }

    public void registerDestructionCallback(String name, Runnable callback) {
        StepContext context = this.getContext();
        this.logger.debug((Object)String.format("Registered destruction callback in scope=%s, name=%s", this.name, name));
        context.registerDestructionCallback(name, callback);
    }

    public Object remove(String name) {
        StepContext context = this.getContext();
        this.logger.debug((Object)String.format("Removing from scope=%s, name=%s", this.name, name));
        return context.removeAttribute(name);
    }

    private StepContext getContext() {
        StepContext context = StepSynchronizationManager.getContext();
        if (context == null) {
            throw new IllegalStateException("No context holder available for step scope");
        }
        return context;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        beanFactory.registerScope(this.name, (Scope)this);
        if (!this.autoProxy) {
            return;
        }
        Assert.state((boolean)(beanFactory instanceof BeanDefinitionRegistry), (String)"BeanFactory was not a BeanDefinitionRegistry, so StepScope cannot be used.");
        BeanDefinitionRegistry registry = (BeanDefinitionRegistry)beanFactory;
        for (String beanName : beanFactory.getBeanDefinitionNames()) {
            BeanDefinition definition = beanFactory.getBeanDefinition(beanName);
            boolean scoped = this.name.equals(definition.getScope());
            Scopifier scopifier = new Scopifier(registry, this.name, this.proxyTargetClass, scoped);
            scopifier.visitBeanDefinition(definition);
            if (!scoped || definition.isAbstract()) continue;
            StepScope.createScopedProxy(beanName, definition, registry, this.proxyTargetClass);
        }
    }

    public void setName(String name) {
        this.name = name;
    }

    private static BeanDefinitionHolder createScopedProxy(String beanName, BeanDefinition definition, BeanDefinitionRegistry registry, boolean proxyTargetClass) {
        BeanDefinitionHolder proxyHolder = ScopedProxyUtils.createScopedProxy((BeanDefinitionHolder)new BeanDefinitionHolder(definition, beanName), (BeanDefinitionRegistry)registry, (boolean)proxyTargetClass);
        registry.registerBeanDefinition(beanName, proxyHolder.getBeanDefinition());
        return proxyHolder;
    }

    private static class Scopifier
    extends BeanDefinitionVisitor {
        private final boolean proxyTargetClass;
        private final BeanDefinitionRegistry registry;
        private final String scope;
        private final boolean scoped;

        public Scopifier(BeanDefinitionRegistry registry, String scope, boolean proxyTargetClass, boolean scoped) {
            super(new StringValueResolver(){

                public String resolveStringValue(String value) {
                    return value;
                }
            });
            this.registry = registry;
            this.proxyTargetClass = proxyTargetClass;
            this.scope = scope;
            this.scoped = scoped;
        }

        protected Object resolveValue(Object value) {
            BeanDefinition definition = null;
            String beanName = null;
            if (value instanceof BeanDefinition) {
                definition = (BeanDefinition)value;
                beanName = BeanDefinitionReaderUtils.generateBeanName((BeanDefinition)definition, (BeanDefinitionRegistry)this.registry);
            } else if (value instanceof BeanDefinitionHolder) {
                BeanDefinitionHolder holder = (BeanDefinitionHolder)value;
                definition = holder.getBeanDefinition();
                beanName = holder.getBeanName();
            }
            if (definition != null) {
                boolean scopeChangeRequiresProxy;
                boolean nestedScoped = this.scope.equals(definition.getScope());
                boolean bl = scopeChangeRequiresProxy = !this.scoped && nestedScoped;
                if (scopeChangeRequiresProxy) {
                    return StepScope.createScopedProxy(beanName, definition, this.registry, this.proxyTargetClass);
                }
            }
            value = super.resolveValue(value);
            return value;
        }
    }
}

