/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.core.step.item;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.springframework.classify.Classifier;
import org.springframework.retry.ExhaustedRetryException;
import org.springframework.retry.RecoveryCallback;
import org.springframework.retry.RetryCallback;
import org.springframework.retry.RetryContext;
import org.springframework.retry.RetryListener;
import org.springframework.retry.RetryOperations;
import org.springframework.retry.RetryPolicy;
import org.springframework.retry.RetryState;
import org.springframework.retry.backoff.BackOffPolicy;
import org.springframework.retry.context.RetryContextSupport;
import org.springframework.retry.policy.RetryContextCache;
import org.springframework.retry.support.DefaultRetryState;
import org.springframework.retry.support.RetrySynchronizationManager;
import org.springframework.retry.support.RetryTemplate;

public class BatchRetryTemplate
implements RetryOperations {
    private final InnerRetryTemplate delegate = new InnerRetryTemplate();
    private final RetryTemplate regular = new RetryTemplate();
    private RetryPolicy retryPolicy;

    public <T> T execute(RetryCallback<T> retryCallback, Collection<RetryState> states) throws ExhaustedRetryException, Exception {
        BatchRetryState batchState = new BatchRetryState(states);
        return this.delegate.execute(retryCallback, batchState);
    }

    public <T> T execute(RetryCallback<T> retryCallback, RecoveryCallback<T> recoveryCallback, Collection<RetryState> states) throws ExhaustedRetryException, Exception {
        BatchRetryState batchState = new BatchRetryState(states);
        return this.delegate.execute(retryCallback, recoveryCallback, batchState);
    }

    @Override
    public final <T> T execute(RetryCallback<T> retryCallback, RecoveryCallback<T> recoveryCallback, RetryState retryState) throws Exception, ExhaustedRetryException {
        return this.regular.execute(retryCallback, recoveryCallback, retryState);
    }

    @Override
    public final <T> T execute(RetryCallback<T> retryCallback, RecoveryCallback<T> recoveryCallback) throws Exception {
        return this.regular.execute(retryCallback, recoveryCallback);
    }

    @Override
    public final <T> T execute(RetryCallback<T> retryCallback, RetryState retryState) throws Exception, ExhaustedRetryException {
        return this.regular.execute(retryCallback, retryState);
    }

    @Override
    public final <T> T execute(RetryCallback<T> retryCallback) throws Exception {
        return this.regular.execute(retryCallback);
    }

    public static List<RetryState> createState(List<?> keys) {
        ArrayList<RetryState> states = new ArrayList<RetryState>();
        for (Object key : keys) {
            states.add(new DefaultRetryState(key));
        }
        return states;
    }

    public static List<RetryState> createState(List<?> keys, Classifier<? super Throwable, Boolean> classifier) {
        ArrayList<RetryState> states = new ArrayList<RetryState>();
        for (Object key : keys) {
            states.add(new DefaultRetryState(key, classifier));
        }
        return states;
    }

    public void registerListener(RetryListener listener) {
        this.delegate.registerListener(listener);
        this.regular.registerListener(listener);
    }

    public void setBackOffPolicy(BackOffPolicy backOffPolicy) {
        this.delegate.setBackOffPolicy(backOffPolicy);
        this.regular.setBackOffPolicy(backOffPolicy);
    }

    public void setListeners(RetryListener[] listeners) {
        this.delegate.setListeners(listeners);
        this.regular.setListeners(listeners);
    }

    public void setRetryContextCache(RetryContextCache retryContextCache) {
        this.delegate.setRetryContextCache(retryContextCache);
        this.regular.setRetryContextCache(retryContextCache);
    }

    public void setRetryPolicy(RetryPolicy retryPolicy) {
        this.retryPolicy = retryPolicy;
        this.delegate.setRetryPolicy(retryPolicy);
        this.regular.setRetryPolicy(retryPolicy);
    }

    public boolean canRetry(RetryContext context) {
        return context == null ? true : this.retryPolicy.canRetry(context);
    }

    private static class InnerRetryTemplate
    extends RetryTemplate {
        private InnerRetryTemplate() {
        }

        @Override
        protected boolean canRetry(RetryPolicy retryPolicy, RetryContext context) {
            BatchRetryContext batchContext = (BatchRetryContext)context;
            for (RetryContext nextContext : batchContext.contexts) {
                if (super.canRetry(retryPolicy, nextContext)) continue;
                return false;
            }
            return true;
        }

        @Override
        protected RetryContext open(RetryPolicy retryPolicy, RetryState state) {
            BatchRetryState batchState = (BatchRetryState)state;
            ArrayList<RetryContext> contexts = new ArrayList<RetryContext>();
            for (RetryState retryState : batchState.keys) {
                contexts.add(super.open(retryPolicy, retryState));
            }
            return new BatchRetryContext(RetrySynchronizationManager.getContext(), contexts);
        }

        @Override
        protected void registerThrowable(RetryPolicy retryPolicy, RetryState state, RetryContext context, Throwable e) {
            BatchRetryState batchState = (BatchRetryState)state;
            BatchRetryContext batchContext = (BatchRetryContext)context;
            Iterator contextIterator = batchContext.contexts.iterator();
            for (RetryState retryState : batchState.keys) {
                RetryContext nextContext = (RetryContext)contextIterator.next();
                super.registerThrowable(retryPolicy, retryState, nextContext, e);
            }
        }

        @Override
        protected void close(RetryPolicy retryPolicy, RetryContext context, RetryState state, boolean succeeded) {
            BatchRetryState batchState = (BatchRetryState)state;
            BatchRetryContext batchContext = (BatchRetryContext)context;
            Iterator contextIterator = batchContext.contexts.iterator();
            for (RetryState retryState : batchState.keys) {
                RetryContext nextContext = (RetryContext)contextIterator.next();
                super.close(retryPolicy, nextContext, retryState, succeeded);
            }
        }

        @Override
        protected <T> T handleRetryExhausted(RecoveryCallback<T> recoveryCallback, RetryContext context, RetryState state) throws Exception {
            BatchRetryState batchState = (BatchRetryState)state;
            BatchRetryContext batchContext = (BatchRetryContext)context;
            Exception rethrowable = null;
            ExhaustedRetryException exhausted = null;
            Iterator contextIterator = batchContext.contexts.iterator();
            for (RetryState retryState : batchState.keys) {
                RetryContext nextContext = (RetryContext)contextIterator.next();
                try {
                    super.handleRetryExhausted(null, nextContext, retryState);
                }
                catch (ExhaustedRetryException e) {
                    exhausted = e;
                }
                catch (Exception e) {
                    rethrowable = e;
                }
            }
            if (recoveryCallback != null) {
                return recoveryCallback.recover(context);
            }
            if (exhausted != null) {
                throw exhausted;
            }
            throw rethrowable;
        }
    }

    private static class BatchRetryContext
    extends RetryContextSupport {
        private final Collection<RetryContext> contexts;

        public BatchRetryContext(RetryContext parent, Collection<RetryContext> contexts) {
            super(parent);
            this.contexts = contexts;
            int count = 0;
            for (RetryContext context : contexts) {
                int retryCount = context.getRetryCount();
                if (retryCount <= count) continue;
                count = retryCount;
                this.registerThrowable(context.getLastThrowable());
            }
        }
    }

    private class BatchRetryState
    extends DefaultRetryState {
        private final Collection<RetryState> keys;

        public BatchRetryState(Collection<RetryState> keys) {
            super(keys);
            this.keys = new ArrayList<RetryState>(keys);
        }
    }
}

