/*
 * Decompiled with CFR 0.152.
 */
package org.apache.camel.component.spring.integration;

import org.apache.camel.Endpoint;
import org.apache.camel.Exchange;
import org.apache.camel.ExchangePattern;
import org.apache.camel.Message;
import org.apache.camel.Processor;
import org.apache.camel.component.spring.integration.SpringIntegrationBinding;
import org.apache.camel.component.spring.integration.SpringIntegrationEndpoint;
import org.apache.camel.component.spring.integration.SpringIntegrationMessage;
import org.apache.camel.impl.DefaultConsumer;
import org.apache.camel.spring.SpringCamelContext;
import org.apache.camel.util.ObjectHelper;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.integration.MessageChannel;
import org.springframework.integration.core.MessageHandler;
import org.springframework.integration.core.SubscribableChannel;
import org.springframework.integration.support.channel.BeanFactoryChannelResolver;
import org.springframework.integration.support.channel.ChannelResolver;

public class SpringIntegrationConsumer
extends DefaultConsumer
implements MessageHandler {
    private final SpringCamelContext context;
    private final ChannelResolver channelResolver;
    private SubscribableChannel inputChannel;
    private MessageChannel outputChannel;

    public SpringIntegrationConsumer(SpringIntegrationEndpoint endpoint, Processor processor) {
        super((Endpoint)endpoint, processor);
        this.context = (SpringCamelContext)endpoint.getCamelContext();
        this.channelResolver = new BeanFactoryChannelResolver((BeanFactory)this.context.getApplicationContext());
    }

    public SpringIntegrationEndpoint getEndpoint() {
        return (SpringIntegrationEndpoint)super.getEndpoint();
    }

    protected void doStop() throws Exception {
        this.inputChannel.unsubscribe(this);
        super.doStop();
    }

    protected void doStart() throws Exception {
        super.doStart();
        if (this.getEndpoint().getMessageChannel() == null) {
            String inputChannelName = this.getEndpoint().getDefaultChannel();
            if (ObjectHelper.isEmpty((Object)inputChannelName)) {
                inputChannelName = this.getEndpoint().getInputChannel();
            }
            ObjectHelper.notEmpty((String)inputChannelName, (String)"inputChannelName", (Object)((Object)this.getEndpoint()));
            this.inputChannel = (SubscribableChannel)this.channelResolver.resolveChannelName(inputChannelName);
        } else {
            this.inputChannel = (SubscribableChannel)this.getEndpoint().getMessageChannel();
        }
        if (this.inputChannel == null) {
            throw new IllegalArgumentException("Cannot resolve InputChannel on " + (Object)((Object)this.getEndpoint()));
        }
        if (this.getEndpoint().isInOut()) {
            ObjectHelper.notEmpty((String)this.getEndpoint().getOutputChannel(), (String)"OutputChannel", (Object)((Object)this.getEndpoint()));
            this.outputChannel = this.channelResolver.resolveChannelName(this.getEndpoint().getOutputChannel());
            if (this.outputChannel == null) {
                throw new IllegalArgumentException("Cannot resolve OutputChannel on " + (Object)((Object)this.getEndpoint()));
            }
        }
        this.inputChannel.subscribe(this);
    }

    @Override
    public void handleMessage(org.springframework.integration.Message<?> siInMessage) {
        Exchange exchange = this.getEndpoint().createExchange(this.getEndpoint().isInOut() ? ExchangePattern.InOut : ExchangePattern.InOnly);
        exchange.setIn((Message)new SpringIntegrationMessage(siInMessage));
        try {
            this.getProcessor().process(exchange);
        }
        catch (Exception e) {
            this.getExceptionHandler().handleException("Error processing exchange", exchange, (Throwable)e);
            return;
        }
        if (this.getEndpoint().isInOut()) {
            MessageChannel reply = null;
            Object returnAddress = siInMessage.getHeaders().getReplyChannel();
            if (returnAddress != null) {
                if (returnAddress instanceof String) {
                    reply = (MessageChannel)this.context.getApplicationContext().getBean((String)returnAddress, MessageChannel.class);
                } else if (returnAddress instanceof MessageChannel) {
                    reply = (MessageChannel)returnAddress;
                }
            } else {
                reply = this.outputChannel;
                if (reply == null) {
                    throw new IllegalArgumentException("OutputChannel has not been configured on " + (Object)((Object)this.getEndpoint()));
                }
            }
            if (reply == null) {
                throw new IllegalArgumentException("Cannot resolve ReplyChannel from message: " + siInMessage);
            }
            org.springframework.integration.Message<?> siOutMessage = SpringIntegrationBinding.storeToSpringIntegrationMessage(exchange.getOut());
            this.log.debug("Sending {} to ReplyChannel: {}", siOutMessage, (Object)reply);
            reply.send(siOutMessage);
        }
    }
}

