/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.aggregator;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.Message;
import org.springframework.integration.MessageHeaders;
import org.springframework.integration.aggregator.MessageGroupProcessor;
import org.springframework.integration.store.MessageGroup;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAggregatingMessageGroupProcessor
implements MessageGroupProcessor {
    private final Log logger = LogFactory.getLog(this.getClass());

    @Override
    public final Object processMessageGroup(MessageGroup group) {
        Assert.notNull((Object)group, (String)"MessageGroup must not be null");
        Map<String, Object> headers = this.aggregateHeaders(group);
        Object payload = this.aggregatePayloads(group, headers);
        MessageBuilder<Object> builder = payload instanceof Message ? MessageBuilder.fromMessage((Message)payload).copyHeadersIfAbsent(headers) : MessageBuilder.withPayload(payload).copyHeadersIfAbsent(headers);
        return builder.popSequenceDetails().build();
    }

    protected Map<String, Object> aggregateHeaders(MessageGroup group) {
        HashMap<String, Object> aggregatedHeaders = new HashMap<String, Object>();
        HashSet<String> conflictKeys = new HashSet<String>();
        for (Message<?> message : group.getMessages()) {
            MessageHeaders currentHeaders = message.getHeaders();
            for (String key : currentHeaders.keySet()) {
                if ("id".equals(key) || "timestamp".equals(key) || "sequenceSize".equals(key) || "sequenceNumber".equals(key)) continue;
                Object value = currentHeaders.get(key);
                if (!aggregatedHeaders.containsKey(key)) {
                    aggregatedHeaders.put(key, value);
                    continue;
                }
                if (value.equals(aggregatedHeaders.get(key))) continue;
                conflictKeys.add(key);
            }
        }
        for (String keyToRemove : conflictKeys) {
            if (this.logger.isDebugEnabled()) {
                this.logger.debug((Object)("Excluding header '" + keyToRemove + "' upon aggregation due to conflict(s) " + "in MessageGroup with correlation key: " + group.getGroupId()));
            }
            aggregatedHeaders.remove(keyToRemove);
        }
        return aggregatedHeaders;
    }

    protected abstract Object aggregatePayloads(MessageGroup var1, Map<String, Object> var2);
}

