/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.aggregator;

import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.Message;
import org.springframework.integration.aggregator.CorrelationStrategy;
import org.springframework.integration.aggregator.ReleaseStrategy;
import org.springframework.integration.core.MessageSource;
import org.springframework.integration.handler.AbstractMessageHandler;
import org.springframework.integration.store.MessageGroup;
import org.springframework.integration.store.MessageGroupStore;
import org.springframework.integration.store.SimpleMessageStore;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorrelatingMessageBarrier
extends AbstractMessageHandler
implements MessageSource<Object> {
    private static final Log log = LogFactory.getLog(CorrelatingMessageBarrier.class);
    private volatile CorrelationStrategy correlationStrategy;
    private volatile ReleaseStrategy releaseStrategy;
    private final ConcurrentMap<Object, Object> correlationLocks = new ConcurrentHashMap<Object, Object>();
    private final MessageGroupStore store;

    public CorrelatingMessageBarrier(MessageGroupStore store) {
        this.store = store;
    }

    public CorrelatingMessageBarrier() {
        this(new SimpleMessageStore(0));
    }

    public void setCorrelationStrategy(CorrelationStrategy correlationStrategy) {
        this.correlationStrategy = correlationStrategy;
    }

    public void setReleaseStrategy(ReleaseStrategy releaseStrategy) {
        this.releaseStrategy = releaseStrategy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleMessageInternal(Message<?> message) throws Exception {
        Object lock;
        Object correlationKey = this.correlationStrategy.getCorrelationKey(message);
        Object object = lock = this.getLock(correlationKey);
        synchronized (object) {
            this.store.addMessageToGroup(correlationKey, message);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Handled message for key [%s]: %s.", correlationKey, message));
        }
    }

    private Object getLock(Object correlationKey) {
        Object existingLock = this.correlationLocks.putIfAbsent(correlationKey, correlationKey);
        return existingLock == null ? correlationKey : existingLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Message<Object> receive() {
        for (Object key : this.correlationLocks.keySet()) {
            Object lock;
            Object object = lock = this.getLock(key);
            synchronized (object) {
                MessageGroup group = this.store.getMessageGroup(key);
                if (group != null && this.releaseStrategy.canRelease(group)) {
                    Message<Object> nextMessage = null;
                    Iterator<Message<?>> messages = group.getMessages().iterator();
                    if (messages.hasNext()) {
                        nextMessage = messages.next();
                        this.store.removeMessageFromGroup(key, nextMessage);
                        if (log.isDebugEnabled()) {
                            log.debug((Object)String.format("Released message for key [%s]: %s.", key, nextMessage));
                        }
                    } else {
                        this.remove(key);
                    }
                    Message<Object> result = nextMessage;
                    return result;
                }
            }
        }
        return null;
    }

    private void remove(Object key) {
        this.correlationLocks.remove(key);
        this.store.removeMessageGroup(key);
    }
}

