/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.aggregator;

import java.util.Collection;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.ParseException;
import org.springframework.expression.spel.SpelParserConfiguration;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.integration.Message;
import org.springframework.integration.aggregator.MessageListProcessor;
import org.springframework.integration.util.AbstractExpressionEvaluator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExpressionEvaluatingMessageListProcessor
extends AbstractExpressionEvaluator
implements MessageListProcessor {
    private final ExpressionParser parser = new SpelExpressionParser(new SpelParserConfiguration(true, true));
    private final Expression expression;
    private volatile Class<?> expectedType = null;

    public void setExpectedType(Class<?> expectedType) {
        this.expectedType = expectedType;
    }

    public ExpressionEvaluatingMessageListProcessor(String expression) {
        try {
            this.expression = this.parser.parseExpression(expression);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException("Failed to parse expression.", e);
        }
    }

    @Override
    public Object process(Collection<? extends Message<?>> messages) {
        return this.evaluateExpression(this.expression, messages, this.expectedType);
    }
}

