/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.aggregator;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.integration.Message;
import org.springframework.integration.aggregator.ReleaseStrategy;
import org.springframework.integration.aggregator.SequenceNumberComparator;
import org.springframework.integration.store.MessageGroup;

public class SequenceSizeReleaseStrategy
implements ReleaseStrategy {
    private static final Log logger = LogFactory.getLog(SequenceSizeReleaseStrategy.class);
    private volatile Comparator<Message<?>> comparator = new SequenceNumberComparator();
    private volatile boolean releasePartialSequences;

    public SequenceSizeReleaseStrategy() {
        this(false);
    }

    public SequenceSizeReleaseStrategy(boolean releasePartialSequences) {
        this.releasePartialSequences = releasePartialSequences;
    }

    public void setReleasePartialSequences(boolean releasePartialSequences) {
        this.releasePartialSequences = releasePartialSequences;
    }

    public boolean canRelease(MessageGroup messageGroup) {
        boolean canRelease = false;
        Collection<Message<?>> messages = messageGroup.getMessages();
        if (this.releasePartialSequences && !messages.isEmpty()) {
            if (logger.isTraceEnabled()) {
                logger.trace((Object)("Considering partial release of group [" + messageGroup + "]"));
            }
            ArrayList sorted = new ArrayList(messages);
            Collections.sort(sorted, this.comparator);
            int nextSequenceNumber = ((Message)sorted.get(0)).getHeaders().getSequenceNumber();
            int lastReleasedMessageSequence = messageGroup.getLastReleasedMessageSequenceNumber();
            if (nextSequenceNumber - lastReleasedMessageSequence == 1) {
                canRelease = true;
            }
        } else {
            int size = messages.size();
            if (size == 0) {
                canRelease = true;
            } else {
                int sequenceSize = messageGroup.getOne().getHeaders().getSequenceSize();
                if (sequenceSize == size) {
                    canRelease = true;
                }
            }
        }
        return canRelease;
    }
}

