/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.aop;

import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.aop.support.AopUtils;
import org.springframework.context.expression.MapAccessor;
import org.springframework.core.LocalVariableTableParameterNameDiscoverer;
import org.springframework.core.ParameterNameDiscoverer;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.ParseException;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.SpelParserConfiguration;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;
import org.springframework.integration.Message;
import org.springframework.integration.MessageChannel;
import org.springframework.integration.aop.PublisherMetadataSource;
import org.springframework.integration.core.MessagingTemplate;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.integration.support.channel.ChannelResolver;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessagePublishingInterceptor
implements MethodInterceptor {
    private final MessagingTemplate messagingTemplate = new MessagingTemplate();
    private volatile PublisherMetadataSource metadataSource;
    private final ExpressionParser parser = new SpelExpressionParser(new SpelParserConfiguration(true, true));
    private volatile ChannelResolver channelResolver;
    private final ParameterNameDiscoverer parameterNameDiscoverer = new LocalVariableTableParameterNameDiscoverer();

    public MessagePublishingInterceptor(PublisherMetadataSource metadataSource) {
        Assert.notNull((Object)metadataSource, (String)"metadataSource must not be null");
        this.metadataSource = metadataSource;
    }

    public void setPublisherMetadataSource(PublisherMetadataSource metadataSource) {
        Assert.notNull((Object)metadataSource, (String)"metadataSource must not be null");
        this.metadataSource = metadataSource;
    }

    public void setDefaultChannel(MessageChannel defaultChannel) {
        this.messagingTemplate.setDefaultChannel(defaultChannel);
    }

    public void setChannelResolver(ChannelResolver channelResolver) {
        this.channelResolver = channelResolver;
    }

    public final Object invoke(MethodInvocation invocation) throws Throwable {
        Assert.notNull((Object)this.metadataSource, (String)"PublisherMetadataSource is required.");
        StandardEvaluationContext context = new StandardEvaluationContext();
        context.addPropertyAccessor((PropertyAccessor)new MapAccessor());
        Class targetClass = AopUtils.getTargetClass((Object)invocation.getThis());
        Method method = AopUtils.getMostSpecificMethod((Method)invocation.getMethod(), (Class)targetClass);
        String[] argumentNames = this.resolveArgumentNames(method);
        context.setVariable("method", (Object)method.getName());
        if (invocation.getArguments().length > 0 && argumentNames != null) {
            HashMap<Object, Object> argumentMap = new HashMap<Object, Object>();
            for (int i = 0; i < argumentNames.length && invocation.getArguments().length > i; ++i) {
                Object argValue = invocation.getArguments()[i];
                argumentMap.put(i, argValue);
                argumentMap.put(argumentNames[i], argValue);
            }
            context.setVariable("args", argumentMap);
        }
        try {
            Object returnValue = invocation.proceed();
            context.setVariable("return", returnValue);
            Object object = returnValue;
            return object;
        }
        catch (Throwable t) {
            context.setVariable("exception", (Object)t);
            throw t;
        }
        finally {
            this.publishMessage(method, context);
        }
    }

    private String[] resolveArgumentNames(Method method) {
        return this.parameterNameDiscoverer.getParameterNames(method);
    }

    private void publishMessage(Method method, StandardEvaluationContext context) throws Exception {
        Expression expression;
        Object result;
        String payloadExpressionString = this.metadataSource.getPayloadExpression(method);
        if (!StringUtils.hasText((String)payloadExpressionString)) {
            payloadExpressionString = "#return";
        }
        if ((result = (expression = this.parser.parseExpression(payloadExpressionString)).getValue((EvaluationContext)context)) != null) {
            MessageBuilder<Object> builder = result instanceof Message ? MessageBuilder.fromMessage((Message)result) : MessageBuilder.withPayload(result);
            Map<String, Object> headers = this.evaluateHeaders(method, context);
            if (headers != null) {
                builder.copyHeaders(headers);
            }
            Message<Object> message = builder.build();
            String channelName = this.metadataSource.getChannelName(method);
            MessageChannel channel = null;
            if (channelName != null) {
                Assert.state((this.channelResolver != null ? 1 : 0) != 0, (String)"ChannelResolver is required to resolve channel names.");
                channel = this.channelResolver.resolveChannelName(channelName);
            }
            if (channel != null) {
                this.messagingTemplate.send(channel, message);
            } else {
                this.messagingTemplate.send(message);
            }
        }
    }

    private Map<String, Object> evaluateHeaders(Method method, StandardEvaluationContext context) throws ParseException, EvaluationException {
        Map<String, String> headerExpressionMap = this.metadataSource.getHeaderExpressions(method);
        if (headerExpressionMap != null) {
            HashMap<String, Object> headers = new HashMap<String, Object>();
            for (Map.Entry<String, String> headerExpressionEntry : headerExpressionMap.entrySet()) {
                Expression expression;
                Object result;
                String headerExpression = headerExpressionEntry.getValue();
                if (!StringUtils.hasText((String)headerExpression) || (result = (expression = this.parser.parseExpression(headerExpression)).getValue((EvaluationContext)context)) == null) continue;
                headers.put(headerExpressionEntry.getKey(), result);
            }
            if (headers.size() > 0) {
                return headers;
            }
        }
        return null;
    }
}

