/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.channel;

import java.util.concurrent.atomic.AtomicInteger;
import org.springframework.integration.Message;
import org.springframework.integration.MessageDeliveryException;
import org.springframework.integration.MessageDispatchingException;
import org.springframework.integration.channel.AbstractMessageChannel;
import org.springframework.integration.core.MessageHandler;
import org.springframework.integration.core.SubscribableChannel;
import org.springframework.integration.dispatcher.AbstractDispatcher;
import org.springframework.integration.dispatcher.MessageDispatcher;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSubscribableChannel
extends AbstractMessageChannel
implements SubscribableChannel {
    private final AtomicInteger handlerCounter = new AtomicInteger();

    @Override
    public boolean subscribe(MessageHandler handler) {
        MessageDispatcher dispatcher;
        boolean added = (dispatcher = this.getRequiredDispatcher()).addHandler(handler);
        this.adjustCounterIfNecessary(dispatcher, added ? 1 : 0);
        return added;
    }

    @Override
    public boolean unsubscribe(MessageHandler handle) {
        MessageDispatcher dispatcher;
        boolean removed = (dispatcher = this.getRequiredDispatcher()).removeHandler(handle);
        this.adjustCounterIfNecessary(dispatcher, removed ? -1 : 0);
        return removed;
    }

    private void adjustCounterIfNecessary(MessageDispatcher dispatcher, int delta) {
        if (delta != 0) {
            int counter = 0;
            counter = dispatcher instanceof AbstractDispatcher ? ((AbstractDispatcher)dispatcher).getHandlerCount() : this.handlerCounter.addAndGet(delta);
            if (this.logger.isInfoEnabled()) {
                this.logger.info((Object)("Channel '" + this.getComponentName() + "' has " + counter + " subscriber(s)."));
            }
        }
    }

    @Override
    protected boolean doSend(Message<?> message, long timeout) {
        try {
            return this.getRequiredDispatcher().dispatch(message);
        }
        catch (MessageDispatchingException e) {
            String componentName = this.getComponentName();
            componentName = StringUtils.hasText((String)componentName) ? componentName : "unknown";
            throw new MessageDeliveryException(message, e.getMessage() + " for channel " + componentName + ".", e);
        }
    }

    private MessageDispatcher getRequiredDispatcher() {
        MessageDispatcher dispatcher = this.getDispatcher();
        Assert.state((dispatcher != null ? 1 : 0) != 0, (String)"'dispatcher' must not be null");
        return dispatcher;
    }

    protected abstract MessageDispatcher getDispatcher();
}

