/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.channel;

import java.util.concurrent.Executor;
import org.springframework.integration.channel.AbstractSubscribableChannel;
import org.springframework.integration.channel.MessagePublishingErrorHandler;
import org.springframework.integration.dispatcher.LoadBalancingStrategy;
import org.springframework.integration.dispatcher.RoundRobinLoadBalancingStrategy;
import org.springframework.integration.dispatcher.UnicastingDispatcher;
import org.springframework.integration.support.channel.BeanFactoryChannelResolver;
import org.springframework.integration.util.ErrorHandlingTaskExecutor;
import org.springframework.util.Assert;

public class ExecutorChannel
extends AbstractSubscribableChannel {
    private volatile UnicastingDispatcher dispatcher;
    private volatile Executor executor;
    private volatile boolean failover = true;
    private volatile int maxSubscribers = Integer.MAX_VALUE;
    private volatile LoadBalancingStrategy loadBalancingStrategy;

    public ExecutorChannel(Executor executor) {
        this(executor, new RoundRobinLoadBalancingStrategy());
    }

    public ExecutorChannel(Executor executor, LoadBalancingStrategy loadBalancingStrategy) {
        Assert.notNull((Object)executor, (String)"executor must not be null");
        this.executor = executor;
        this.dispatcher = new UnicastingDispatcher(executor);
        if (loadBalancingStrategy != null) {
            this.loadBalancingStrategy = loadBalancingStrategy;
            this.dispatcher.setLoadBalancingStrategy(loadBalancingStrategy);
        }
    }

    public void setFailover(boolean failover) {
        this.failover = failover;
        this.dispatcher.setFailover(failover);
    }

    public void setMaxSubscribers(int maxSubscribers) {
        this.maxSubscribers = maxSubscribers;
        this.dispatcher.setMaxSubscribers(maxSubscribers);
    }

    protected UnicastingDispatcher getDispatcher() {
        return this.dispatcher;
    }

    public final void onInit() {
        if (!(this.executor instanceof ErrorHandlingTaskExecutor)) {
            MessagePublishingErrorHandler errorHandler = new MessagePublishingErrorHandler(new BeanFactoryChannelResolver(this.getBeanFactory()));
            this.executor = new ErrorHandlingTaskExecutor(this.executor, errorHandler);
        }
        this.dispatcher = new UnicastingDispatcher(this.executor);
        this.dispatcher.setFailover(this.failover);
        this.dispatcher.setMaxSubscribers(this.maxSubscribers);
        if (this.loadBalancingStrategy != null) {
            this.dispatcher.setLoadBalancingStrategy(this.loadBalancingStrategy);
        }
    }
}

