/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.channel;

import java.util.Comparator;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.springframework.integration.Message;
import org.springframework.integration.MessageHeaders;
import org.springframework.integration.channel.QueueChannel;
import org.springframework.integration.util.UpperBound;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PriorityChannel
extends QueueChannel {
    private final UpperBound upperBound;
    private final AtomicLong sequenceCounter = new AtomicLong();

    public PriorityChannel(int capacity, Comparator<Message<?>> comparator) {
        super(new PriorityBlockingQueue(11, new SequenceFallbackComparator(comparator)));
        this.upperBound = new UpperBound(capacity);
    }

    public PriorityChannel(int capacity) {
        this(capacity, null);
    }

    public PriorityChannel(Comparator<Message<?>> comparator) {
        this(0, comparator);
    }

    public PriorityChannel() {
        this(0, null);
    }

    @Override
    protected boolean doSend(Message<?> message, long timeout) {
        if (!this.upperBound.tryAcquire(timeout)) {
            return false;
        }
        message = new MessageWrapper(message);
        return super.doSend(message, 0L);
    }

    @Override
    protected Message<?> doReceive(long timeout) {
        Message<?> message = super.doReceive(timeout);
        if (message != null) {
            message = ((MessageWrapper)message).getRootMessage();
            this.upperBound.release();
        }
        return message;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MessageWrapper
    implements Message<Object> {
        private final Message<?> rootMessage;
        private final long sequence;

        public MessageWrapper(Message<?> rootMessage) {
            this.rootMessage = rootMessage;
            this.sequence = PriorityChannel.this.sequenceCounter.incrementAndGet();
        }

        public Message<?> getRootMessage() {
            return this.rootMessage;
        }

        @Override
        public MessageHeaders getHeaders() {
            return this.rootMessage.getHeaders();
        }

        @Override
        public Object getPayload() {
            return this.rootMessage.getPayload();
        }

        long getSequence() {
            return this.sequence;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class SequenceFallbackComparator
    implements Comparator<Message<?>> {
        private final Comparator<Message<?>> targetComparator;

        public SequenceFallbackComparator(Comparator<Message<?>> targetComparator) {
            this.targetComparator = targetComparator;
        }

        @Override
        public int compare(Message<?> message1, Message<?> message2) {
            int compareResult = 0;
            if (this.targetComparator != null) {
                compareResult = this.targetComparator.compare(message1, message2);
            } else {
                Integer priority1 = message1.getHeaders().getPriority();
                Integer priority2 = message2.getHeaders().getPriority();
                priority1 = priority1 != null ? priority1 : 0;
                priority2 = priority2 != null ? priority2 : 0;
                compareResult = priority2.compareTo(priority1);
            }
            if (compareResult == 0) {
                Long sequence1 = ((MessageWrapper)message1).getSequence();
                Long sequence2 = ((MessageWrapper)message2).getSequence();
                compareResult = sequence1.compareTo(sequence2);
            }
            return compareResult;
        }
    }
}

