/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.channel.interceptor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.aop.framework.Advised;
import org.springframework.aop.support.AopUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.DirectFieldAccessor;
import org.springframework.beans.NotReadablePropertyException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.OrderComparator;
import org.springframework.integration.MessageChannel;
import org.springframework.integration.channel.ChannelInterceptor;
import org.springframework.integration.channel.interceptor.GlobalChannelInterceptorWrapper;
import org.springframework.util.PatternMatchUtils;
import org.springframework.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class GlobalChannelInterceptorBeanPostProcessor
implements BeanPostProcessor,
InitializingBean {
    private static final Log logger = LogFactory.getLog(GlobalChannelInterceptorBeanPostProcessor.class);
    private final OrderComparator comparator = new OrderComparator();
    private volatile List<GlobalChannelInterceptorWrapper> channelInterceptors;
    private final Set<GlobalChannelInterceptorWrapper> positiveOrderInterceptors = new LinkedHashSet<GlobalChannelInterceptorWrapper>();
    private final Set<GlobalChannelInterceptorWrapper> negativeOrderInterceptors = new LinkedHashSet<GlobalChannelInterceptorWrapper>();

    GlobalChannelInterceptorBeanPostProcessor(List<GlobalChannelInterceptorWrapper> channelInterceptors) {
        this.channelInterceptors = channelInterceptors;
    }

    public void afterPropertiesSet() throws Exception {
        for (GlobalChannelInterceptorWrapper channelInterceptor : this.channelInterceptors) {
            if (channelInterceptor.getOrder() >= 0) {
                this.positiveOrderInterceptors.add(channelInterceptor);
                continue;
            }
            this.negativeOrderInterceptors.add(channelInterceptor);
        }
    }

    public Object postProcessBeforeInitialization(Object bean, String beanName) throws BeansException {
        return bean;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof MessageChannel) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Applying global interceptors on channel '" + beanName + "'"));
            }
            this.addMatchingInterceptors((MessageChannel)bean, beanName);
        }
        return bean;
    }

    private void addMatchingInterceptors(MessageChannel channel, String beanName) {
        List<ChannelInterceptor> interceptors = this.getExistingInterceptors(channel);
        if (interceptors != null) {
            String[] patterns;
            ArrayList<GlobalChannelInterceptorWrapper> tempInterceptors = new ArrayList<GlobalChannelInterceptorWrapper>();
            for (GlobalChannelInterceptorWrapper globalChannelInterceptorWrapper : this.positiveOrderInterceptors) {
                patterns = globalChannelInterceptorWrapper.getPatterns();
                if (!PatternMatchUtils.simpleMatch((String[])(patterns = StringUtils.trimArrayElements((String[])patterns)), (String)beanName)) continue;
                tempInterceptors.add(globalChannelInterceptorWrapper);
            }
            Collections.sort(tempInterceptors, this.comparator);
            for (GlobalChannelInterceptorWrapper next : tempInterceptors) {
                interceptors.add(next.getChannelInterceptor());
            }
            tempInterceptors = new ArrayList();
            for (GlobalChannelInterceptorWrapper globalChannelInterceptorWrapper : this.negativeOrderInterceptors) {
                patterns = globalChannelInterceptorWrapper.getPatterns();
                if (!PatternMatchUtils.simpleMatch((String[])(patterns = StringUtils.trimArrayElements((String[])patterns)), (String)beanName)) continue;
                tempInterceptors.add(globalChannelInterceptorWrapper);
            }
            Collections.sort(tempInterceptors, this.comparator);
            if (!tempInterceptors.isEmpty()) {
                for (int i = tempInterceptors.size() - 1; i >= 0; --i) {
                    interceptors.add(0, ((GlobalChannelInterceptorWrapper)tempInterceptors.get(i)).getChannelInterceptor());
                }
            }
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("Global Channel interceptors will not be applied to Channel: " + beanName));
        }
    }

    private List<ChannelInterceptor> getExistingInterceptors(MessageChannel channel) {
        block5: {
            try {
                DirectFieldAccessor channelAccessor;
                Object interceptorListWrapper;
                Object target;
                MessageChannel targetChannel = channel;
                if (AopUtils.isAopProxy((Object)channel) && (target = ((Advised)channel).getTargetSource().getTarget()) instanceof MessageChannel) {
                    targetChannel = (MessageChannel)target;
                }
                if ((interceptorListWrapper = (channelAccessor = new DirectFieldAccessor((Object)targetChannel)).getPropertyValue("interceptors")) != null) {
                    return (List)new DirectFieldAccessor(interceptorListWrapper).getPropertyValue("interceptors");
                }
            }
            catch (NotReadablePropertyException e) {
            }
            catch (Exception e) {
                if (!logger.isDebugEnabled() || channel == null) break block5;
                logger.debug((Object)("interceptors not supported by channel '" + channel + "'"), (Throwable)e);
            }
        }
        return null;
    }
}

