/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config;

import org.springframework.beans.factory.BeanClassLoaderAware;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.context.SmartLifecycle;
import org.springframework.integration.MessageChannel;
import org.springframework.integration.core.MessageSource;
import org.springframework.integration.endpoint.SourcePollingChannelAdapter;
import org.springframework.integration.scheduling.PollerMetadata;
import org.springframework.util.Assert;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourcePollingChannelAdapterFactoryBean
implements FactoryBean<SourcePollingChannelAdapter>,
BeanFactoryAware,
BeanNameAware,
BeanClassLoaderAware,
InitializingBean,
SmartLifecycle {
    private volatile MessageSource<?> source;
    private volatile MessageChannel outputChannel;
    private volatile PollerMetadata pollerMetadata;
    private volatile boolean autoStartup = true;
    private volatile Long sendTimeout;
    private volatile String beanName;
    private volatile ConfigurableBeanFactory beanFactory;
    private volatile ClassLoader beanClassLoader;
    private volatile SourcePollingChannelAdapter adapter;
    private volatile boolean initialized;
    private final Object initializationMonitor = new Object();

    public void setSource(MessageSource<?> source) {
        this.source = source;
    }

    public void setSendTimeout(long sendTimeout) {
        this.sendTimeout = sendTimeout;
    }

    public void setOutputChannel(MessageChannel outputChannel) {
        this.outputChannel = outputChannel;
    }

    public void setPollerMetadata(PollerMetadata pollerMetadata) {
        this.pollerMetadata = pollerMetadata;
    }

    public void setAutoStartup(boolean autoStartup) {
        this.autoStartup = autoStartup;
    }

    public void setBeanFactory(BeanFactory beanFactory) {
        Assert.isInstanceOf(ConfigurableBeanFactory.class, (Object)beanFactory, (String)"a ConfigurableBeanFactory is required");
        this.beanFactory = (ConfigurableBeanFactory)beanFactory;
    }

    public void setBeanClassLoader(ClassLoader classLoader) {
        this.beanClassLoader = classLoader;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public void afterPropertiesSet() throws Exception {
        this.initializeAdapter();
    }

    public SourcePollingChannelAdapter getObject() throws Exception {
        if (this.adapter == null) {
            this.initializeAdapter();
        }
        return this.adapter;
    }

    public Class<?> getObjectType() {
        return SourcePollingChannelAdapter.class;
    }

    public boolean isSingleton() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeAdapter() {
        Object object = this.initializationMonitor;
        synchronized (object) {
            if (this.initialized) {
                return;
            }
            Assert.notNull(this.source, (String)"source is required");
            Assert.notNull((Object)this.outputChannel, (String)"outputChannel is required");
            SourcePollingChannelAdapter spca = new SourcePollingChannelAdapter();
            spca.setSource(this.source);
            spca.setOutputChannel(this.outputChannel);
            if (this.pollerMetadata == null) {
                this.pollerMetadata = PollerMetadata.getDefaultPollerMetadata((BeanFactory)this.beanFactory);
                Assert.notNull((Object)this.pollerMetadata, (String)("No poller has been defined for channel-adapter '" + this.beanName + "', and no default poller is available within the context."));
            }
            if (this.pollerMetadata.getMaxMessagesPerPoll() == Integer.MIN_VALUE) {
                this.pollerMetadata.setMaxMessagesPerPoll(1L);
            }
            spca.setMaxMessagesPerPoll(this.pollerMetadata.getMaxMessagesPerPoll());
            if (this.sendTimeout != null) {
                spca.setSendTimeout(this.sendTimeout);
            }
            spca.setTaskExecutor(this.pollerMetadata.getTaskExecutor());
            spca.setAdviceChain(this.pollerMetadata.getAdviceChain());
            spca.setTrigger(this.pollerMetadata.getTrigger());
            spca.setErrorHandler(this.pollerMetadata.getErrorHandler());
            spca.setBeanClassLoader(this.beanClassLoader);
            spca.setAutoStartup(this.autoStartup);
            spca.setBeanName(this.beanName);
            spca.setBeanFactory((BeanFactory)this.beanFactory);
            spca.setTransactionSynchronizationFactory(this.pollerMetadata.getTransactionSynchronizationFactory());
            spca.afterPropertiesSet();
            this.adapter = spca;
            this.initialized = true;
        }
    }

    public boolean isAutoStartup() {
        return this.adapter != null ? this.adapter.isAutoStartup() : true;
    }

    public int getPhase() {
        return this.adapter != null ? this.adapter.getPhase() : 0;
    }

    public boolean isRunning() {
        return this.adapter != null ? this.adapter.isRunning() : false;
    }

    public void start() {
        if (this.adapter != null) {
            this.adapter.start();
        }
    }

    public void stop() {
        if (this.adapter != null) {
            this.adapter.stop();
        }
    }

    public void stop(Runnable callback) {
        if (this.adapter != null) {
            this.adapter.stop(callback);
        }
    }
}

