/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config.xml;

import org.springframework.beans.BeanMetadataElement;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractConsumerEndpointParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;

public abstract class AbstractCorrelatingMessageHandlerParser
extends AbstractConsumerEndpointParser {
    private static final String CORRELATION_STRATEGY_REF_ATTRIBUTE = "correlation-strategy";
    private static final String CORRELATION_STRATEGY_METHOD_ATTRIBUTE = "correlation-strategy-method";
    private static final String CORRELATION_STRATEGY_EXPRESSION_ATTRIBUTE = "correlation-strategy-expression";
    private static final String CORRELATION_STRATEGY_PROPERTY = "correlationStrategy";
    private static final String RELEASE_STRATEGY_REF_ATTRIBUTE = "release-strategy";
    private static final String RELEASE_STRATEGY_METHOD_ATTRIBUTE = "release-strategy-method";
    private static final String RELEASE_STRATEGY_EXPRESSION_ATTRIBUTE = "release-strategy-expression";
    private static final String RELEASE_STRATEGY_PROPERTY = "releaseStrategy";
    private static final String MESSAGE_STORE_ATTRIBUTE = "message-store";
    private static final String DISCARD_CHANNEL_ATTRIBUTE = "discard-channel";
    private static final String SEND_TIMEOUT_ATTRIBUTE = "send-timeout";
    private static final String SEND_PARTIAL_RESULT_ON_EXPIRY_ATTRIBUTE = "send-partial-result-on-expiry";

    protected void doParse(BeanDefinitionBuilder builder, Element element, BeanMetadataElement processor, ParserContext parserContext) {
        this.injectPropertyWithAdapter(CORRELATION_STRATEGY_REF_ATTRIBUTE, CORRELATION_STRATEGY_METHOD_ATTRIBUTE, CORRELATION_STRATEGY_EXPRESSION_ATTRIBUTE, CORRELATION_STRATEGY_PROPERTY, "CorrelationStrategy", element, builder, processor, parserContext);
        this.injectPropertyWithAdapter(RELEASE_STRATEGY_REF_ATTRIBUTE, RELEASE_STRATEGY_METHOD_ATTRIBUTE, RELEASE_STRATEGY_EXPRESSION_ATTRIBUTE, RELEASE_STRATEGY_PROPERTY, "ReleaseStrategy", element, builder, processor, parserContext);
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined(builder, element, MESSAGE_STORE_ATTRIBUTE);
        IntegrationNamespaceUtils.setReferenceIfAttributeDefined(builder, element, DISCARD_CHANNEL_ATTRIBUTE);
        IntegrationNamespaceUtils.setValueIfAttributeDefined(builder, element, SEND_TIMEOUT_ATTRIBUTE);
        IntegrationNamespaceUtils.setValueIfAttributeDefined(builder, element, SEND_PARTIAL_RESULT_ON_EXPIRY_ATTRIBUTE);
    }

    protected void injectPropertyWithAdapter(String beanRefAttribute, String methodRefAttribute, String expressionAttribute, String beanProperty, String adapterClass, Element element, BeanDefinitionBuilder builder, BeanMetadataElement processor, ParserContext parserContext) {
        String beanRef = element.getAttribute(beanRefAttribute);
        String beanMethod = element.getAttribute(methodRefAttribute);
        String expression = element.getAttribute(expressionAttribute);
        boolean hasBeanRef = StringUtils.hasText((String)beanRef);
        boolean hasExpression = StringUtils.hasText((String)expression);
        if (hasBeanRef && hasExpression) {
            parserContext.getReaderContext().error("Exactly one of the '" + beanRefAttribute + "' or '" + expressionAttribute + "' attribute is allowed.", (Object)element);
        }
        BeanMetadataElement adapter = null;
        if (hasBeanRef) {
            adapter = this.createAdapter((BeanMetadataElement)new RuntimeBeanReference(beanRef), beanMethod, adapterClass, parserContext);
        } else if (hasExpression) {
            BeanDefinitionBuilder adapterBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)("org.springframework.integration.aggregator.ExpressionEvaluating" + adapterClass));
            adapterBuilder.addConstructorArgValue((Object)expression);
            adapter = adapterBuilder.getBeanDefinition();
        } else {
            adapter = processor != null ? this.createAdapter(processor, beanMethod, adapterClass, parserContext) : this.createAdapter(null, beanMethod, adapterClass, parserContext);
        }
        builder.addPropertyValue(beanProperty, (Object)adapter);
    }

    private BeanMetadataElement createAdapter(BeanMetadataElement ref, String method, String unqualifiedClassName, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition((String)("org.springframework.integration.config." + unqualifiedClassName + "FactoryBean"));
        builder.addConstructorArgValue((Object)ref);
        if (StringUtils.hasText((String)method)) {
            builder.addConstructorArgValue((Object)method);
        }
        return builder.getBeanDefinition();
    }
}

