/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config.xml;

import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedSet;
import org.springframework.beans.factory.xml.BeanDefinitionDecorator;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandler;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.ChannelInitializer;
import org.springframework.util.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class AbstractIntegrationNamespaceHandler
implements NamespaceHandler {
    private static final String VERSION = "2.2";
    public static final String CHANNEL_INITIALIZER_BEAN_NAME = "channelInitializer";
    private static final String DEFAULT_CONFIGURING_POSTPROCESSOR_SIMPLE_CLASS_NAME = "DefaultConfiguringBeanFactoryPostProcessor";
    private static final String DEFAULT_CONFIGURING_POSTPROCESSOR_BEAN_NAME = "org.springframework.integration.internalDefaultConfiguringBeanFactoryPostProcessor";
    private final NamespaceHandlerDelegate delegate = new NamespaceHandlerDelegate();

    public final BeanDefinition parse(Element element, ParserContext parserContext) {
        this.verifySchemaVersion(element, parserContext);
        this.registerImplicitChannelCreator(parserContext);
        this.registerDefaultConfiguringBeanFactoryPostProcessorIfNecessary(parserContext);
        return this.delegate.parse(element, parserContext);
    }

    public final BeanDefinitionHolder decorate(Node source, BeanDefinitionHolder definition, ParserContext parserContext) {
        return this.delegate.decorate(source, definition, parserContext);
    }

    private void registerImplicitChannelCreator(ParserContext parserContext) {
        boolean alreadyRegistered = false;
        alreadyRegistered = parserContext.getRegistry() instanceof ListableBeanFactory ? ((ListableBeanFactory)parserContext.getRegistry()).containsBeanDefinition(CHANNEL_INITIALIZER_BEAN_NAME) : parserContext.getRegistry().isBeanNameInUse(CHANNEL_INITIALIZER_BEAN_NAME);
        if (!alreadyRegistered) {
            BeanDefinitionBuilder channelDef = BeanDefinitionBuilder.genericBeanDefinition(ChannelInitializer.class);
            BeanDefinitionHolder channelCreatorHolder = new BeanDefinitionHolder((BeanDefinition)channelDef.getBeanDefinition(), CHANNEL_INITIALIZER_BEAN_NAME);
            BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)channelCreatorHolder, (BeanDefinitionRegistry)parserContext.getRegistry());
        }
        if (!(alreadyRegistered = parserContext.getRegistry() instanceof ListableBeanFactory ? ((ListableBeanFactory)parserContext.getRegistry()).containsBeanDefinition(ChannelInitializer.AUTO_CREATE_CHANNEL_CANDIDATES_BEAN_NAME) : parserContext.getRegistry().isBeanNameInUse(ChannelInitializer.AUTO_CREATE_CHANNEL_CANDIDATES_BEAN_NAME))) {
            BeanDefinitionBuilder channelRegistryBuilder = BeanDefinitionBuilder.genericBeanDefinition(ChannelInitializer.AutoCreateCandidatesCollector.class);
            channelRegistryBuilder.addConstructorArgValue((Object)new ManagedSet());
            BeanDefinitionHolder channelRegistryHolder = new BeanDefinitionHolder((BeanDefinition)channelRegistryBuilder.getBeanDefinition(), ChannelInitializer.AUTO_CREATE_CHANNEL_CANDIDATES_BEAN_NAME);
            BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)channelRegistryHolder, (BeanDefinitionRegistry)parserContext.getRegistry());
        }
    }

    private void registerDefaultConfiguringBeanFactoryPostProcessorIfNecessary(ParserContext parserContext) {
        boolean alreadyRegistered = false;
        alreadyRegistered = parserContext.getRegistry() instanceof ListableBeanFactory ? ((ListableBeanFactory)parserContext.getRegistry()).containsBean(DEFAULT_CONFIGURING_POSTPROCESSOR_BEAN_NAME) : parserContext.getRegistry().isBeanNameInUse(DEFAULT_CONFIGURING_POSTPROCESSOR_BEAN_NAME);
        if (!alreadyRegistered) {
            BeanDefinitionBuilder postProcessorBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.integration.config.xml.DefaultConfiguringBeanFactoryPostProcessor");
            BeanDefinitionHolder postProcessorHolder = new BeanDefinitionHolder((BeanDefinition)postProcessorBuilder.getBeanDefinition(), DEFAULT_CONFIGURING_POSTPROCESSOR_BEAN_NAME);
            BeanDefinitionReaderUtils.registerBeanDefinition((BeanDefinitionHolder)postProcessorHolder, (BeanDefinitionRegistry)parserContext.getRegistry());
        }
    }

    protected final void registerBeanDefinitionDecorator(String elementName, BeanDefinitionDecorator decorator) {
        this.delegate.doRegisterBeanDefinitionDecorator(elementName, decorator);
    }

    protected final void registerBeanDefinitionDecoratorForAttribute(String attributeName, BeanDefinitionDecorator decorator) {
        this.delegate.doRegisterBeanDefinitionDecoratorForAttribute(attributeName, decorator);
    }

    protected final void registerBeanDefinitionParser(String elementName, BeanDefinitionParser parser) {
        this.delegate.doRegisterBeanDefinitionParser(elementName, parser);
    }

    private void verifySchemaVersion(Element element, ParserContext parserContext) {
        if (!AbstractIntegrationNamespaceHandler.matchesVersion(element) || !AbstractIntegrationNamespaceHandler.matchesVersion(element.getOwnerDocument().getDocumentElement())) {
            parserContext.getReaderContext().error("You cannot use prior versions of Spring Integration schemas with Spring Integration 2.2. Please upgrade your schema declarations or use versionless aliases (e.g. spring-integration.xsd).", (Object)element);
        }
    }

    private static boolean matchesVersion(Element element) {
        String schemaLocation = element.getAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "schemaLocation");
        return !StringUtils.hasText((String)schemaLocation) || schemaLocation.matches("(?m).*spring-integration-[a-z-]*2.2.xsd.*") || schemaLocation.matches("(?m).*spring-integration[a-z-]*.xsd.*") || !schemaLocation.matches("(?m).*spring-integration.*");
    }

    private class NamespaceHandlerDelegate
    extends NamespaceHandlerSupport {
        private NamespaceHandlerDelegate() {
        }

        public void init() {
            AbstractIntegrationNamespaceHandler.this.init();
        }

        private void doRegisterBeanDefinitionDecorator(String elementName, BeanDefinitionDecorator decorator) {
            super.registerBeanDefinitionDecorator(elementName, decorator);
        }

        private void doRegisterBeanDefinitionDecoratorForAttribute(String attributeName, BeanDefinitionDecorator decorator) {
            super.registerBeanDefinitionDecoratorForAttribute(attributeName, decorator);
        }

        private void doRegisterBeanDefinitionParser(String elementName, BeanDefinitionParser parser) {
            super.registerBeanDefinitionParser(elementName, parser);
        }
    }
}

