/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config.xml;

import java.util.List;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.BeanDefinitionReaderUtils;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.xml.ParserContext;
import org.springframework.integration.config.xml.AbstractConsumerEndpointParser;
import org.springframework.integration.config.xml.IntegrationNamespaceUtils;
import org.springframework.integration.handler.MessageHandlerChain;
import org.springframework.util.StringUtils;
import org.springframework.util.xml.DomUtils;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ChainParser
extends AbstractConsumerEndpointParser {
    protected BeanDefinitionBuilder parseHandler(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(MessageHandlerChain.class);
        ManagedList handlerList = new ManagedList();
        NodeList children = element.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1 || "poller".equals(child.getLocalName())) continue;
            BeanDefinitionHolder holder = this.parseChild((Element)child, parserContext, (BeanDefinition)builder.getBeanDefinition());
            if ("gateway".equals(child.getLocalName())) {
                BeanDefinitionBuilder gwBuilder = BeanDefinitionBuilder.genericBeanDefinition((String)"org.springframework.integration.gateway.RequestReplyMessageHandlerAdapter");
                gwBuilder.addConstructorArgValue((Object)holder);
                handlerList.add((Object)gwBuilder.getBeanDefinition());
                continue;
            }
            handlerList.add((Object)holder);
        }
        builder.addPropertyValue("handlers", (Object)handlerList);
        IntegrationNamespaceUtils.setValueIfAttributeDefined(builder, element, "send-timeout");
        IntegrationNamespaceUtils.setValueIfAttributeDefined(builder, element, "auto-startup");
        IntegrationNamespaceUtils.setValueIfAttributeDefined(builder, element, "phase");
        return builder;
    }

    private void validateChild(Element element, ParserContext parserContext) {
        List pollerChildElements;
        Object source = parserContext.extractSource((Object)element);
        String order = element.getAttribute("order");
        if (StringUtils.hasText((String)order)) {
            parserContext.getReaderContext().error(IntegrationNamespaceUtils.createElementDescription(element) + " must not define " + "an 'order' attribute when used within a chain.", source);
        }
        if (!(pollerChildElements = DomUtils.getChildElementsByTagName((Element)element, (String)"poller")).isEmpty()) {
            parserContext.getReaderContext().error(IntegrationNamespaceUtils.createElementDescription(element) + " must not define " + "a 'poller' sub-element when used within a chain.", source);
        }
    }

    private BeanDefinitionHolder parseChild(Element element, ParserContext parserContext, BeanDefinition parentDefinition) {
        BeanDefinitionHolder holder = null;
        if ("bean".equals(element.getLocalName())) {
            holder = parserContext.getDelegate().parseBeanDefinitionElement(element, parentDefinition);
        } else {
            this.validateChild(element, parserContext);
            BeanDefinition beanDefinition = parserContext.getDelegate().parseCustomElement(element, parentDefinition);
            if (beanDefinition == null) {
                parserContext.getReaderContext().error("child BeanDefinition must not be null", (Object)element);
            } else {
                String beanName = BeanDefinitionReaderUtils.generateBeanName((BeanDefinition)beanDefinition, (BeanDefinitionRegistry)parserContext.getRegistry(), (boolean)true);
                holder = new BeanDefinitionHolder(beanDefinition, beanName);
            }
        }
        return holder;
    }
}

